/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BeeFishingRecipe
implements Recipe<Container> {
    private static Map<BeeFishingRecipe, List<Biome>> cachedBiomes = new HashMap<BeeFishingRecipe, List<Biome>>();
    private static Map<Biome, List<BeeFishingRecipe>> cachedRecipes = new HashMap<Biome, List<BeeFishingRecipe>>();
    private final ResourceLocation id;
    public final Lazy<BeeIngredient> output;
    public final List<String> biomes;
    public final double chance;

    public BeeFishingRecipe(ResourceLocation id, Lazy<BeeIngredient> output, List<String> biomes, double chance) {
        this.id = id;
        this.output = output;
        this.biomes = biomes;
        this.chance = chance;
    }

    public boolean m_5818_(Container inv, Level levelIn) {
        return false;
    }

    public boolean matches(Biome biome) {
        for (String biomeId : this.biomes) {
            if (!biome.getRegistryName().toString().equals(biomeId)) continue;
            return true;
        }
        return false;
    }

    public static List<Biome> getBiomeList(BeeFishingRecipe recipe) {
        if (!cachedBiomes.containsKey(recipe)) {
            ArrayList<Biome> list = new ArrayList<Biome>();
            for (String biomeId : recipe.biomes) {
                Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeId));
                list.add(biome);
            }
            cachedBiomes.put(recipe, list);
        }
        return cachedBiomes.get(recipe);
    }

    public static List<BeeFishingRecipe> getRecipeList(Biome biome, Level level) {
        if (!cachedRecipes.containsKey(biome)) {
            ArrayList<BeeFishingRecipe> list = new ArrayList<BeeFishingRecipe>();
            Map allRecipes = level.m_7465_().m_44054_(ModRecipeTypes.BEE_FISHING_TYPE);
            for (Map.Entry recipe : allRecipes.entrySet()) {
                BeeFishingRecipe fishRecipe;
                Object v = recipe.getValue();
                if (!(v instanceof BeeFishingRecipe) || !(fishRecipe = (BeeFishingRecipe)v).matches(biome)) continue;
                list.add(fishRecipe);
            }
            cachedRecipes.put(biome, list);
        }
        return cachedRecipes.get(biome);
    }

    @Nonnull
    public ItemStack m_5874_(Container inv) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.BEE_FISHING.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return ModRecipeTypes.BEE_FISHING_TYPE;
    }

    public static class Serializer<T extends BeeFishingRecipe>
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T fromJson(ResourceLocation id, JsonObject json) {
            Lazy output = Lazy.of(BeeIngredientFactory.getIngredient(GsonHelper.m_13906_((JsonObject)json, (String)"bee")));
            ArrayList<String> biomes = new ArrayList<String>();
            if (json.has("biomes")) {
                GsonHelper.m_13933_((JsonObject)json, (String)"biomes").forEach(jsonElement -> biomes.add(jsonElement.getAsString()));
            }
            double chance = GsonHelper.m_144742_((JsonObject)json, (String)"chance", (double)0.05);
            return this.factory.create(id, (Lazy<BeeIngredient>)output, biomes, chance);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            try {
                BeeIngredient output = BeeIngredient.fromNetwork(buffer);
                ArrayList<String> biomes = new ArrayList<String>();
                IntStream.range(0, buffer.readInt()).forEach(i -> biomes.add(buffer.m_130277_()));
                return this.factory.create(id, (Lazy<BeeIngredient>)Lazy.of(() -> output), biomes, buffer.readDouble());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee fishing recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, T recipe) {
            try {
                ((BeeIngredient)((BeeFishingRecipe)recipe).output.get()).toNetwork(buffer);
                buffer.writeInt(((BeeFishingRecipe)recipe).biomes.size());
                ((BeeFishingRecipe)recipe).biomes.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130070_(arg_0));
                buffer.writeDouble(((BeeFishingRecipe)recipe).chance);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee fishing recipe to packet. " + ((BeeFishingRecipe)recipe).m_6423_(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends BeeFishingRecipe> {
            public T create(ResourceLocation var1, Lazy<BeeIngredient> var2, List<String> var3, double var4);
        }
    }
}

