/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.client.render.item.StoneChipRenderer;
import cy.jdkdigital.productivebees.common.item.WoodChip;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTags;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.IItemRenderProperties;

public class StoneChip
extends WoodChip {
    public StoneChip(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack getStack(Block block) {
        return StoneChip.getStack(block, 1);
    }

    public static ItemStack getStack(Block block, int count) {
        return StoneChip.getStack(block.getRegistryName().toString(), count);
    }

    public static ItemStack getStack(String blockName, int count) {
        ItemStack result = new ItemStack((ItemLike)ModItems.STONE_CHIP.get(), count);
        StoneChip.setBlock(result, blockName);
        return result;
    }

    @Override
    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        Block block = StoneChip.getBlock(stack);
        if (block != null) {
            return new TranslatableComponent(this.m_5524_() + ".named", new Object[]{new TranslatableComponent(block.m_7705_())});
        }
        return super.m_7626_(stack);
    }

    @Override
    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            try {
                Registry.f_122824_.m_206058_(ModTags.QUARRY).forEach(blockHolder -> {
                    Block block = (Block)blockHolder.m_203334_();
                    if (block.getRegistryName() != null && !block.getRegistryName().m_135815_().contains("infested")) {
                        items.add((Object)StoneChip.getStack(block));
                    }
                });
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){
            final BlockEntityWithoutLevelRenderer myRenderer = new StoneChipRenderer();

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return this.myRenderer;
            }
        });
    }

    public static ShapelessRecipe getRecipe(Block b) {
        ItemStack chip = StoneChip.getStack(b);
        String[] id = b.getRegistryName().toString().split(":");
        NonNullList list = NonNullList.m_122779_();
        for (int i = 0; i < 9; ++i) {
            Ingredient ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{chip});
            if (ingredient.m_43947_()) continue;
            list.add((Object)ingredient);
        }
        return new ShapelessRecipe(new ResourceLocation("productivebees", "stone_chip_" + id[1]), "", new ItemStack((ItemLike)b.m_5456_()), list);
    }
}

