/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntityAbstract;
import cy.jdkdigital.productivebees.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.common.block.entity.UpgradeableBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.common.item.FilterUpgradeItem;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.container.AdvancedBeehiveContainer;
import cy.jdkdigital.productivebees.handler.bee.CapabilityBee;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import cy.jdkdigital.productivebees.util.BeeAttribute;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class AdvancedBeehiveBlockEntity
extends AdvancedBeehiveBlockEntityAbstract
implements MenuProvider,
UpgradeableBlockEntity {
    protected int tickCounter = 0;
    private int abandonCountdown = 0;
    protected boolean hasTicked = false;
    protected LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.ItemHandler(12, (BlockEntity)this){

        @Override
        public boolean isInputSlotItem(int slot, ItemStack item) {
            if (slot == 11) {
                return item.m_41720_() instanceof BeeCage;
            }
            return super.isInputSlotItem(slot, item);
        }

        @Override
        public boolean isInputSlot(int slot) {
            return super.isInputSlot(slot) || slot == 11;
        }
    });
    protected LazyOptional<IItemHandlerModifiable> upgradeHandler = LazyOptional.of(() -> new InventoryHandlerHelper.UpgradeHandler(4, (BlockEntity)this));

    public AdvancedBeehiveBlockEntity(BlockEntityType<?> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
    }

    public AdvancedBeehiveBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModTileEntityTypes.ADVANCED_BEEHIVE.get(), pos, state);
        this.MAX_BEES = 3;
    }

    @Nonnull
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new AdvancedBeehiveContainer(windowId, playerInventory, this);
    }

    @Nonnull
    public Component m_5446_() {
        return new TranslatableComponent(this.m_58900_().m_60734_().m_7705_());
    }

    public boolean m_58777_() {
        return true;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AdvancedBeehiveBlockEntity blockEntity) {
        if (!blockEntity.hasTicked && ++blockEntity.tickCounter > (Integer)ProductiveBeesConfig.GENERAL.hiveTickRate.get()) {
            EntityType beeType;
            ConfigurableBee newBee;
            List bees;
            blockEntity.tickCounter = 0;
            BlockPos front = pos.m_142300_((Direction)state.m_61143_((Property)BeehiveBlock.f_49563_));
            if (((Boolean)ProductiveBeesConfig.BEES.spawnUndeadBees.get()).booleanValue() && level.f_46441_.nextDouble() <= (Double)ProductiveBeesConfig.BEES.spawnUndeadBeesChance.get() && level.m_46462_() && level.m_8055_(front).m_60812_((BlockGetter)level, front).m_83281_() && blockEntity.m_58776_() + blockEntity.beesOutsideHive() == 0 && level.m_45517_(LightLayer.BLOCK, front) == 0 && (bees = level.m_45976_(Bee.class, new AABB(pos).m_82377_(3.0, 3.0, 3.0))).size() < (Integer)ProductiveBeesConfig.UPGRADES.breedingMaxNearbyEntities.get() && (newBee = (ConfigurableBee)(beeType = (EntityType)ModEntities.CONFIGURABLE_BEE.get()).m_20615_(level)) != null) {
                if (level.f_46441_.nextBoolean()) {
                    newBee.setBeeType("productivebees:skeletal");
                } else {
                    newBee.setBeeType("productivebees:zombie");
                }
                newBee.setAttributes();
                newBee.f_27698_ = pos;
                blockEntity.m_58741_((Entity)newBee, false);
            }
        }
        if (!blockEntity.hasTicked && blockEntity.tickCounter % 23 == 0 && state.m_60734_() instanceof AdvancedBeehive) {
            int honeyLevel = (Integer)state.m_61143_((Property)BeehiveBlock.f_49564_);
            if (honeyLevel >= 5) {
                int finalHoneyLevel = honeyLevel;
                blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
                    ItemStack filledBottle;
                    boolean addedBottle;
                    ItemStack bottles = inv.getStackInSlot(0);
                    if (!bottles.m_41619_() && (addedBottle = ((InventoryHandlerHelper.ItemHandler)((Object)inv)).addOutput(filledBottle = new ItemStack((ItemLike)Items.f_42787_)))) {
                        ((InventoryHandlerHelper.ItemHandler)((Object)inv)).addOutput(new ItemStack((ItemLike)Items.f_42784_));
                        bottles.m_41774_(1);
                        level.m_46597_(pos, (BlockState)state.m_61124_((Property)BeehiveBlock.f_49564_, (Comparable)Integer.valueOf(finalHoneyLevel - 5)));
                    }
                });
                honeyLevel = (Integer)level.m_8055_(pos).m_61143_((Property)BeehiveBlock.f_49564_);
            }
            if (state.m_61143_(AdvancedBeehive.EXPANDED) != VerticalHive.NONE && honeyLevel >= AdvancedBeehiveBlockEntity.getMaxHoneyLevel(state)) {
                ((AdvancedBeehive)state.m_60734_()).updateState(level, pos, state, false);
            }
            if (((Boolean)ProductiveBeesConfig.BEES.allowBeeSimulation.get()).booleanValue() && blockEntity.getUpgradeCount((Item)ModItems.UPGRADE_SIMULATOR.get()) > 0) {
                blockEntity.inventoryHandler.ifPresent(h -> {
                    if (h instanceof InventoryHandlerHelper.ItemHandler) {
                        InventoryHandlerHelper.ItemHandler invHelper = (InventoryHandlerHelper.ItemHandler)((Object)h);
                        ItemStack cageStack = h.getStackInSlot(11);
                        if (!cageStack.m_41619_() && cageStack.m_41720_() instanceof BeeCage) {
                            if (BeeCage.isFilled(cageStack) && invHelper.canFitStacks(List.of(new ItemStack((ItemLike)cageStack.m_41720_())))) {
                                ProductiveBee pBee;
                                Bee bee;
                                if (!blockEntity.m_58775_() && (bee = BeeCage.getEntityFromStack(cageStack, level, true)) != null && blockEntity.acceptsBee(bee) && (!(bee instanceof ProductiveBee) || (pBee = (ProductiveBee)bee).getAttributeValue(BeeAttributes.TYPE).equals("hive"))) {
                                    blockEntity.m_58741_((Entity)bee, bee.m_27856_());
                                    if (cageStack.m_41720_().equals(ModItems.STURDY_BEE_CAGE.get())) {
                                        invHelper.addOutput(new ItemStack((ItemLike)cageStack.m_41720_()));
                                    }
                                    cageStack.m_41774_(1);
                                    level.m_7260_(pos, state, state, 3);
                                }
                            } else if (!blockEntity.m_58774_()) {
                                blockEntity.getCapability(CapabilityBee.BEE).ifPresent(inhabitantStorage -> {
                                    Iterator<AdvancedBeehiveBlockEntityAbstract.Inhabitant> inhabitantIterator = inhabitantStorage.getInhabitants().iterator();
                                    AdvancedBeehiveBlockEntityAbstract.Inhabitant inhabitant = inhabitantIterator.next();
                                    Entity entity = EntityType.m_20645_((CompoundTag)inhabitant.nbt, (Level)level, spawnedEntity -> spawnedEntity);
                                    if (entity instanceof Bee) {
                                        Bee beeEntity = (Bee)entity;
                                        beeEntity.f_27698_ = blockEntity.f_58858_;
                                        ItemStack filledCage = new ItemStack((ItemLike)cageStack.m_41720_());
                                        BeeCage.captureEntity(beeEntity, filledCage);
                                        if (invHelper.canFitStacks(List.of(new ItemStack((ItemLike)cageStack.m_41720_())))) {
                                            cageStack.m_41774_(1);
                                            invHelper.addOutput(filledCage);
                                            inhabitantIterator.remove();
                                            level.m_7260_(pos, state, state, 3);
                                        }
                                    }
                                });
                            }
                        }
                    }
                });
            }
        }
        if (--blockEntity.abandonCountdown < 0) {
            blockEntity.abandonCountdown = 0;
        }
        AdvancedBeehiveBlockEntityAbstract.tick(level, pos, state, blockEntity);
        blockEntity.hasTicked = false;
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getUpgradeHandler() {
        return this.upgradeHandler;
    }

    @Override
    protected int getTimeInHive(boolean hasNectar, @Nullable Bee beeEntity) {
        double timeUpgradeModifier = 1.0 - (double)this.getUpgradeCount((Item)ModItems.UPGRADE_TIME.get()) * (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get();
        return (int)((double)super.getTimeInHive(hasNectar, beeEntity) * Math.max(0.0, timeUpgradeModifier));
    }

    @Override
    protected void beeReleasePostAction(@Nonnull Level level, Bee beeEntity, BlockState state, BeehiveBlockEntity.BeeReleaseStatus beeState) {
        super.beeReleasePostAction(level, beeEntity, state, beeState);
        if (beeState == BeehiveBlockEntity.BeeReleaseStatus.HONEY_DELIVERED) {
            int samplerUpgrades;
            ProductiveBee productiveBee;
            if (beeEntity instanceof ProductiveBee && (productiveBee = (ProductiveBee)beeEntity).hasConverted()) {
                productiveBee.setHasConverted(false);
            } else {
                this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> BeeHelper.getBeeProduce(level, beeEntity, this.getUpgradeCount((Item)ModItems.UPGRADE_COMB_BLOCK.get()) > 0).forEach(stackIn -> {
                    ItemStack stack = stackIn.m_41777_();
                    this.applyHiveProductionModifier(stack);
                    if (!stack.m_41619_()) {
                        int productivityUpgrades;
                        int productivity;
                        if (beeEntity instanceof ProductiveBee && (productivity = ((ProductiveBee)beeEntity).getAttributeValue(BeeAttributes.PRODUCTIVITY).intValue()) > 0) {
                            float modifier = (1.0f / ((float)productivity + 2.0f) + ((float)productivity + 1.0f) / 2.0f) * (float)stack.m_41613_();
                            stack.m_41769_(Math.round(modifier));
                        }
                        if ((productivityUpgrades = this.getUpgradeCount((Item)ModItems.UPGRADE_PRODUCTIVITY.get())) > 0) {
                            double upgradeMod = (double)stack.m_41613_() * ((Double)ProductiveBeesConfig.UPGRADES.productivityMultiplier.get() * (double)productivityUpgrades);
                            stack.m_41764_(Math.round((float)upgradeMod));
                        }
                        ((InventoryHandlerHelper.ItemHandler)((Object)inv)).addOutput(stack);
                    }
                }));
            }
            int breedingUpgrades = this.getUpgradeCount((Item)ModItems.UPGRADE_BREEDING.get());
            if (breedingUpgrades > 0 && !beeEntity.m_6162_() && this.m_58776_() > 0 && (double)level.f_46441_.nextFloat() <= (Double)ProductiveBeesConfig.UPGRADES.breedingChance.get() * (double)breedingUpgrades) {
                List bees;
                boolean canBreed;
                boolean bl = canBreed = !(beeEntity instanceof ProductiveBee) || ((ProductiveBee)beeEntity).canSelfBreed();
                if (canBreed && (bees = level.m_45976_(Bee.class, new AABB(this.f_58858_).m_82377_(3.0, 3.0, 3.0))).size() < (Integer)ProductiveBeesConfig.UPGRADES.breedingMaxNearbyEntities.get()) {
                    Entity offspring;
                    AdvancedBeehiveBlockEntityAbstract.Inhabitant otherBeeInhabitant = this.getBeeList().get(level.f_46441_.nextInt(this.m_58776_()));
                    Entity otherBee = EntityType.m_20645_((CompoundTag)otherBeeInhabitant.nbt, (Level)level, spawnedEntity -> spawnedEntity);
                    if (otherBee instanceof Bee && (offspring = BeeHelper.getBreedingResult(beeEntity, (AgeableMob)((Bee)otherBee), (ServerLevel)this.f_58857_)) != null) {
                        if (offspring instanceof ProductiveBee && beeEntity instanceof ProductiveBee) {
                            BeeHelper.setOffspringAttributes((ProductiveBee)offspring, (ProductiveBee)beeEntity, (AgeableMob)((Bee)otherBee));
                        }
                        if (offspring instanceof AgeableMob) {
                            ((AgeableMob)offspring).m_146762_(-24000);
                        }
                        BlockPos frontPos = this.m_58899_().m_142300_((Direction)state.m_61143_((Property)BeehiveBlock.f_49563_));
                        offspring.m_7678_((double)frontPos.m_123341_(), (double)((float)frontPos.m_123342_() + 0.5f), (double)frontPos.m_123343_(), 0.0f, 0.0f);
                        level.m_7967_(offspring);
                    }
                }
            }
            if ((samplerUpgrades = this.getUpgradeCount((Item)ModItems.UPGRADE_BEE_SAMPLER.get())) > 0 && !beeEntity.m_6162_() && beeEntity instanceof ProductiveBee && (double)level.f_46441_.nextFloat() <= (Double)ProductiveBeesConfig.UPGRADES.samplerChance.get() * (double)samplerUpgrades) {
                this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
                    Map<BeeAttribute<?>, Object> attributes = ((ProductiveBee)beeEntity).getBeeAttributes();
                    int attr = ProductiveBees.rand.nextInt(attributes.size() + 2);
                    if (attr >= BeeAttributes.attributeList().size()) {
                        String type = beeEntity instanceof ConfigurableBee ? ((ConfigurableBee)beeEntity).getBeeType() : beeEntity.m_20078_();
                        ((InventoryHandlerHelper.ItemHandler)((Object)inv)).addOutput(Gene.getStack(type, ProductiveBees.rand.nextInt(4) + 1));
                    } else {
                        BeeAttribute<?> attribute = BeeAttributes.map.get(BeeAttributes.attributeList().get(attr));
                        Object value = ((ProductiveBee)beeEntity).getAttributeValue(attribute);
                        if (value instanceof Integer) {
                            ((InventoryHandlerHelper.ItemHandler)((Object)inv)).addOutput(Gene.getStack(attribute, (int)((Integer)value), 1, ProductiveBees.rand.nextInt(4) + 1));
                        }
                    }
                });
            }
        }
        this.abandonCountdown += this.getTimeInHive(true, beeEntity);
    }

    protected void applyHiveProductionModifier(ItemStack stack) {
    }

    protected int beesOutsideHive() {
        return (int)Math.ceil(this.abandonCountdown % this.getTimeInHive(true, null));
    }

    @Override
    public boolean acceptsUpgrades() {
        return this.m_58900_().m_61143_(AdvancedBeehive.EXPANDED) != VerticalHive.NONE;
    }

    @Override
    public boolean acceptsBee(Bee bee) {
        boolean isInFilters = false;
        List filters = this.getInstalledUpgrades((Item)ModItems.UPGRADE_FILTER.get());
        for (ItemStack filter : filters) {
            List<Supplier<BeeIngredient>> allowedBees = FilterUpgradeItem.getAllowedBees(filter);
            for (Supplier<BeeIngredient> allowedBee : allowedBees) {
                String type = BeeIngredientFactory.getIngredientKey(bee);
                if (!allowedBee.get().getBeeType().toString().equals(type)) continue;
                isInFilters = true;
            }
        }
        return filters.size() == 0 || isInFilters;
    }

    @Override
    public void loadPacketNBT(CompoundTag tag) {
        super.loadPacketNBT(tag);
        CompoundTag invTag = tag.m_128469_("inv");
        this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> ((INBTSerializable)inv).deserializeNBT((Tag)invTag));
        CompoundTag upgradesTag = tag.m_128469_("upgrades");
        this.upgradeHandler.ifPresent(inv -> ((INBTSerializable)inv).deserializeNBT((Tag)upgradesTag));
        this.MAX_BEES = tag.m_128441_("max_bees") ? tag.m_128451_("max_bees") : this.MAX_BEES;
    }

    @Override
    public void savePacketNBT(CompoundTag tag) {
        super.savePacketNBT(tag);
        this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
            CompoundTag compound = (CompoundTag)((INBTSerializable)inv).serializeNBT();
            tag.m_128365_("inv", (Tag)compound);
        });
        this.upgradeHandler.ifPresent(inv -> {
            CompoundTag compound = (CompoundTag)((INBTSerializable)inv).serializeNBT();
            tag.m_128365_("upgrades", (Tag)compound);
        });
        tag.m_128405_("max_bees", this.MAX_BEES);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

