/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehiveAbstract;
import cy.jdkdigital.productivebees.common.block.entity.SolitaryNestBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.item.HoneyTreat;
import cy.jdkdigital.productivebees.common.recipe.BeeSpawningRecipe;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class SolitaryNest
extends AdvancedBeehiveAbstract {
    public static Supplier<BiMap<Block, Block>> BLOCK_TO_NEST = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)Blocks.f_49999_, (Object)((Block)ModBlocks.OAK_WOOD_NEST.get())).put((Object)Blocks.f_50001_, (Object)((Block)ModBlocks.BIRCH_WOOD_NEST.get())).put((Object)Blocks.f_50000_, (Object)((Block)ModBlocks.SPRUCE_WOOD_NEST.get())).put((Object)Blocks.f_50003_, (Object)((Block)ModBlocks.ACACIA_WOOD_NEST.get())).put((Object)Blocks.f_50004_, (Object)((Block)ModBlocks.DARK_OAK_WOOD_NEST.get())).put((Object)Blocks.f_50002_, (Object)((Block)ModBlocks.JUNGLE_WOOD_NEST.get())).put((Object)Blocks.f_50141_, (Object)((Block)ModBlocks.GLOWSTONE_NEST.get())).put((Object)Blocks.f_50331_, (Object)((Block)ModBlocks.NETHER_QUARTZ_NEST.get())).put((Object)Blocks.f_50197_, (Object)((Block)ModBlocks.NETHER_BRICK_NEST.get())).put((Object)Blocks.f_49995_, (Object)((Block)ModBlocks.NETHER_GOLD_NEST.get())).put((Object)Blocks.f_50259_, (Object)((Block)ModBlocks.END_NEST.get())).put((Object)Blocks.f_50080_, (Object)((Block)ModBlocks.OBSIDIAN_PILLAR_NEST.get())).put((Object)Blocks.f_50374_, (Object)((Block)ModBlocks.SLIMY_NEST.get())).put((Object)Blocks.f_50130_, (Object)((Block)ModBlocks.SUGAR_CANE_NEST.get())).put((Object)Blocks.f_50493_, (Object)((Block)ModBlocks.COARSE_DIRT_NEST.get())).put((Object)Blocks.f_50069_, (Object)((Block)ModBlocks.STONE_NEST.get())).put((Object)Blocks.f_49992_, (Object)((Block)ModBlocks.SAND_NEST.get())).put((Object)Blocks.f_50127_, (Object)((Block)ModBlocks.SNOW_NEST.get())).put((Object)Blocks.f_49994_, (Object)((Block)ModBlocks.GRAVEL_NEST.get())).build());
    List<BeeSpawningRecipe> recipes = new ArrayList<BeeSpawningRecipe>();

    public SolitaryNest(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH));
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : SolitaryNest.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModTileEntityTypes.SOLITARY_NEST.get()), SolitaryNestBlockEntity::tick);
    }

    @Override
    public int getMaxHoneyLevel() {
        return 0;
    }

    public Entity getNestingBeeType(Level level, Biome biome) {
        List<BeeSpawningRecipe> spawningRecipes = this.getSpawningRecipes(level, biome);
        if (!spawningRecipes.isEmpty()) {
            BeeSpawningRecipe spawningRecipe = spawningRecipes.get(level.f_46441_.nextInt(spawningRecipes.size()));
            BeeIngredient beeIngredient = (BeeIngredient)spawningRecipe.output.get(level.f_46441_.nextInt(spawningRecipe.output.size())).get();
            if (beeIngredient != null) {
                Entity bee = beeIngredient.getBeeEntity().m_20615_(level);
                if (bee instanceof ConfigurableBee) {
                    ((ConfigurableBee)bee).setBeeType(beeIngredient.getBeeType().toString());
                    ((ConfigurableBee)bee).setAttributes();
                }
                return bee;
            }
            ProductiveBees.LOGGER.debug("No bee ingredient found in " + spawningRecipe);
        }
        return null;
    }

    public List<BeeSpawningRecipe> getSpawningRecipes(Level world, Biome biome) {
        if (this.recipes.isEmpty()) {
            HashMap allRecipes = new HashMap();
            allRecipes.putAll(world.m_7465_().m_44054_(ModRecipeTypes.BEE_SPAWNING_BIG_TYPE));
            allRecipes.putAll(world.m_7465_().m_44054_(ModRecipeTypes.BEE_SPAWNING_TYPE));
            ItemStack nestItem = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(this.getRegistryName()));
            for (Map.Entry entry : allRecipes.entrySet()) {
                BeeSpawningRecipe recipe = (BeeSpawningRecipe)entry.getValue();
                if (!recipe.matches(nestItem)) continue;
                this.recipes.add(recipe);
            }
        }
        ArrayList<BeeSpawningRecipe> spawningRecipes = new ArrayList<BeeSpawningRecipe>();
        if (!this.recipes.isEmpty()) {
            for (BeeSpawningRecipe recipe : this.recipes) {
                if ((!recipe.biomes.isEmpty() || world.m_46472_() != Level.f_46428_) && !recipe.biomes.contains(biome.m_47567_().m_47645_())) continue;
                spawningRecipes.add(recipe);
            }
        }
        return spawningRecipes;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SolitaryNestBlockEntity(pos, state);
    }

    public BlockState m_5573_(BlockPlaceContext itemUseContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)itemUseContext.m_7820_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_});
    }

    public boolean canRepopulateIn(Level world, Biome biome) {
        return !this.getSpawningRecipes(world, biome).isEmpty();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.m_5776_()) {
            SolitaryNestBlockEntity tileEntity = (SolitaryNestBlockEntity)world.m_7702_(pos);
            ItemStack heldItem = player.m_21120_(hand);
            if (tileEntity != null && heldItem.m_41720_() instanceof HoneyTreat && !HoneyTreat.hasGene(heldItem)) {
                boolean itemUse = false;
                int currentCooldown = tileEntity.getNestTickCooldown();
                if (tileEntity.canRepopulate()) {
                    itemUse = true;
                    if (currentCooldown <= 0) {
                        tileEntity.setNestCooldown((Integer)ProductiveBeesConfig.GENERAL.nestSpawnCooldown.get());
                    } else {
                        tileEntity.setNestCooldown((int)((double)currentCooldown * 0.9));
                    }
                }
                if (itemUse) {
                    world.m_46796_(2005, pos, 0);
                    CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, heldItem);
                    if (!player.m_7500_()) {
                        heldItem.m_41774_(1);
                    }
                }
            }
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    @Override
    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41782_() && stack.m_41783_().m_128451_("spawnCount") >= (Integer)ProductiveBeesConfig.BEES.cuckooSpawnCount.get()) {
            tooltip.add((Component)new TranslatableComponent("productivebees.hive.tooltip.nest_inactive").m_130940_(ChatFormatting.BOLD));
        }
    }
}

