/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.voidtotem.core;

import com.affehund.voidtotem.VoidTotem;
import com.affehund.voidtotem.core.VoidTotemTags;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.UsedTotemTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.data.loot.ChestLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ModDataGeneration {
    private static final Logger DATA_GEN_LOGGER = LogManager.getLogger();

    public static final class RecipeGen
    extends RecipeProvider {
        public RecipeGen(DataGenerator gen) {
            super(gen);
        }

        protected void m_176531_(@Nonnull Consumer<FinishedRecipe> consumer) {
            ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)VoidTotem.VOID_TOTEM_ITEM.get())).m_126130_("cec").m_126130_("dtd").m_126130_(" e ").m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42730_).m_126127_(Character.valueOf('e'), (ItemLike)Items.f_42545_).m_126127_(Character.valueOf('d'), (ItemLike)Items.f_42616_).m_126127_(Character.valueOf('t'), (ItemLike)Items.f_42747_).m_142284_("has_chorus_fruit", (CriterionTriggerInstance)RecipeGen.m_125977_((ItemLike)Items.f_42730_)).m_142284_("has_ender_eye", (CriterionTriggerInstance)RecipeGen.m_125977_((ItemLike)Items.f_42545_)).m_142284_("has_emerald", (CriterionTriggerInstance)RecipeGen.m_125977_((ItemLike)Items.f_42616_)).m_142284_("has_totem", (CriterionTriggerInstance)RecipeGen.m_125977_((ItemLike)Items.f_42747_)).m_176498_(consumer);
        }
    }

    public static class LootTableGen
    extends LootTableProvider {
        public LootTableGen(DataGenerator dataGeneratorIn) {
            super(dataGeneratorIn);
        }

        @NotNull
        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(Chests::new, (Object)LootContextParamSets.f_81411_));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, @NotNull ValidationContext validationContext) {
            map.forEach((resourceLocation, lootTable) -> LootTables.m_79202_((ValidationContext)validationContext, (ResourceLocation)resourceLocation, (LootTable)lootTable));
        }

        public static class Chests
        extends ChestLoot {
            public void accept(@NotNull BiConsumer<ResourceLocation, LootTable.Builder> builder) {
                ImmutableList list = ImmutableList.of((Object)BuiltInLootTables.f_78741_);
                LootPool.Builder voidTotemLootPool = LootPool.m_79043_().m_6509_(LootItemRandomChanceCondition.m_81927_((float)0.33f)).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)VoidTotem.VOID_TOTEM_ITEM.get())).m_79707_(1));
                this.createInjectPools(builder, (List<ResourceLocation>)list, LootTable.m_79147_().m_79161_(voidTotemLootPool));
            }

            private void createInjectPools(BiConsumer<ResourceLocation, LootTable.Builder> consumer, List<ResourceLocation> list, LootTable.Builder builder) {
                list.forEach(reLoc -> consumer.accept(new ResourceLocation("voidtotem", "inject/" + reLoc.m_135815_()), builder));
            }
        }
    }

    public static final class ItemTagsGen
    extends ItemTagsProvider {
        public ItemTagsGen(DataGenerator gen, BlockTagsProvider provider, String modID, ExistingFileHelper existingFileHelper) {
            super(gen, provider, modID, existingFileHelper);
        }

        protected void m_6577_() {
            this.m_206424_(VoidTotemTags.ADDITIONAL_TOTEMS);
            this.m_206424_(VoidTotemTags.CURIOS_CHARM).m_206428_(VoidTotemTags.ADDITIONAL_TOTEMS).m_126582_((Object)((Item)VoidTotem.VOID_TOTEM_ITEM.get()));
        }
    }

    public static final class BlockTagsGen
    extends BlockTagsProvider {
        public BlockTagsGen(DataGenerator generatorIn, String modId, ExistingFileHelper existingFileHelper) {
            super(generatorIn, modId, existingFileHelper);
        }
    }

    public static class AdvancementGen
    extends AdvancementProvider {
        public AdvancementGen(DataGenerator generator, ExistingFileHelper existingFileHelper) {
            super(generator, existingFileHelper);
        }

        protected void registerAdvancements(@NotNull Consumer<Advancement> consumer, @NotNull ExistingFileHelper existingFileHelper) {
            Advancement.Builder.m_138353_().m_138398_(Advancement.Builder.m_138353_().m_138403_(new ResourceLocation("adventure/totem_of_undying"))).m_138371_((ItemLike)VoidTotem.VOID_TOTEM_ITEM.get(), (Component)new TranslatableComponent("advancements.voidtotem.adventure.totem_of_void_undying.title"), (Component)new TranslatableComponent("advancements.voidtotem.adventure.totem_of_void_undying.description"), null, FrameType.GOAL, true, true, false).m_138386_("used_void_totem", (CriterionTriggerInstance)UsedTotemTrigger.TriggerInstance.m_74452_((ItemLike)((ItemLike)VoidTotem.VOID_TOTEM_ITEM.get()))).save(consumer, new ResourceLocation("voidtotem", "adventure/totem_of_void_undying"), existingFileHelper);
        }
    }

    public static final class ItemModelGen
    extends ItemModelProvider {
        public ItemModelGen(DataGenerator gen, String modid, ExistingFileHelper existingFileHelper) {
            super(gen, modid, existingFileHelper);
        }

        protected void registerModels() {
            for (ResourceLocation id : ForgeRegistries.ITEMS.getKeys()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
                if (item == null || !"voidtotem".equals(id.m_135827_())) continue;
                if (item instanceof BlockItem) {
                    return;
                }
                this.defaultItem(id, item);
            }
        }

        private void defaultItem(ResourceLocation id, Item item) {
            ((ItemModelBuilder)this.withExistingParent(id.m_135815_(), "item/generated")).texture("layer0", new ResourceLocation(id.m_135827_(), "item/" + id.m_135815_()));
            DATA_GEN_LOGGER.debug("Generated item model for: " + item.getRegistryName());
        }
    }

    public static final class LanguageGen
    extends LanguageProvider {
        public LanguageGen(DataGenerator gen, String locale) {
            super(gen, "voidtotem", locale);
        }

        protected void addTranslations() {
            String locale;
            switch (locale = this.m_6055_().replace("Languages: ", "")) {
                case "de_de": {
                    this.add("_comment", "Translation (de_de) by Affehund");
                    this.add((Item)VoidTotem.VOID_TOTEM_ITEM.get(), "Totem der Unsterblichkeit in der Leere");
                    this.add("tooltip.voidtotem.totem_of_void_undying", "Lege diese Totem in deine Haupt-/Nebenhand, um zu verhindern, dass du stirbst, wenn du in die Leere f\u00c3\u00a4llst.");
                    this.add("advancements.voidtotem.adventure.totem_of_void_undying.title", "Post mortem 2");
                    this.add("advancements.voidtotem.adventure.totem_of_void_undying.description", "Benutze ein Totem der Unsterblichkeit in der Leere, um dem Tod, wenn du in die Leere f\u00c3\u00a4llst, von der Schippe zu springen");
                    break;
                }
                case "en_us": {
                    this.add("_comment", "Translation (en_us) by Affehund");
                    this.add((Item)VoidTotem.VOID_TOTEM_ITEM.get(), "Totem of Void Undying");
                    this.add("tooltip.voidtotem.totem_of_void_undying", "Put this totem in your main-/offhand to prevent dying if you fall in the void.");
                    this.add("advancements.voidtotem.adventure.totem_of_void_undying.title", "Postmortal 2");
                    this.add("advancements.voidtotem.adventure.totem_of_void_undying.description", "Use a Totem of Void Undying to cheat death when falling in the void");
                }
            }
        }
    }
}

