/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.util;

import mods.waterstrainer.Config;
import mods.waterstrainer.block.BlockStrainerBase;
import mods.waterstrainer.item.ItemStrainer;
import mods.waterstrainer.tileentity.TileEntityStrainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.material.FluidState;

public class EfficiencyData {
    private float efficiencyStrainerType = 0.0f;
    private float efficiencyEnchants = 0.0f;
    private float efficiencyFluidLevel = 0.0f;
    private float efficiencyAdjacentBases = 0.0f;
    private float efficiencyBiome = 0.0f;

    public EfficiencyData(TileEntityStrainer tile) {
        if (tile == null) {
            return;
        }
        ItemStack strainer = tile.getStrainer();
        if (strainer.m_41720_() instanceof ItemStrainer) {
            this.efficiencyStrainerType = ((ItemStrainer)strainer.m_41720_()).getEfficiencyBonus();
        }
        this.efficiencyEnchants += (float)(ItemStrainer.getEnchantmentLevel(strainer, Enchantments.f_44984_) * 5);
        if (((Boolean)Config.MISC_ENABLE_EFFICIENCY.get()).booleanValue()) {
            Holder biomeHolder;
            BiomeManager biomeManager;
            int level;
            BlockPos pos = tile.m_58899_();
            FluidState fluid = tile.m_58904_().m_6425_(pos.m_7494_());
            if (fluid != null && (level = fluid.m_76186_()) > 0) {
                this.efficiencyFluidLevel -= (float)(Math.max(0, 6 - level) * 4);
            }
            for (int curZ = pos.m_123343_() - 1; curZ < pos.m_123343_() + 2; ++curZ) {
                for (int curX = pos.m_123341_() - 1; curX < pos.m_123341_() + 2; ++curX) {
                    if (curX == pos.m_123341_() && curZ == pos.m_123343_() || !(tile.m_58904_().m_8055_(new BlockPos(curX, pos.m_123342_(), curZ)).m_60734_() instanceof BlockStrainerBase)) continue;
                    this.efficiencyAdjacentBases -= 15.0f;
                }
            }
            Level world = tile.m_58904_();
            if (world != null && (biomeManager = world.m_7062_()) != null && (biomeHolder = biomeManager.m_204214_(pos)) != null) {
                if (Biome.m_204183_((Holder)biomeHolder) == Biome.BiomeCategory.OCEAN) {
                    this.efficiencyBiome += 10.0f;
                } else if (Biome.m_204183_((Holder)biomeHolder) == Biome.BiomeCategory.BEACH) {
                    this.efficiencyBiome += 15.0f;
                } else if (Biome.m_204183_((Holder)biomeHolder) == Biome.BiomeCategory.RIVER) {
                    this.efficiencyBiome += 20.0f;
                }
            }
        }
    }

    public float getStrainerTypeEfficiency() {
        return this.efficiencyStrainerType;
    }

    public float getEnchantEfficiency() {
        return this.efficiencyEnchants;
    }

    public float getFluidLevelEfficiency() {
        return this.efficiencyFluidLevel;
    }

    public float getAdjacentBasesEfficiency() {
        return this.efficiencyAdjacentBases;
    }

    public float getBiomeEfficiency() {
        return this.efficiencyBiome;
    }

    public float getTotalEfficiency() {
        return this.efficiencyStrainerType + this.efficiencyEnchants + this.efficiencyFluidLevel + this.efficiencyAdjacentBases + this.efficiencyBiome;
    }
}

