/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.integration.jei.wormbin;

import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mods.waterstrainer.integration.jei.WaterStrainerPlugin;
import mods.waterstrainer.integration.jei.wormbin.WormBinRecipe;
import mods.waterstrainer.registry.BlockRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class WormBinCategory
implements IRecipeCategory<WormBinRecipe> {
    private final IDrawable BACKGROUND;
    private final IDrawable ICON;
    private final ResourceLocation BACKGROUND_LOCATION = new ResourceLocation("waterstrainer", "textures/gui/jei_worm_bin.png");

    public WormBinCategory(IGuiHelper guiHelper) {
        this.BACKGROUND = guiHelper.createDrawable(this.BACKGROUND_LOCATION, 0, 0, 170, 56);
        this.ICON = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)BlockRegistry.worm_bin));
    }

    public ResourceLocation getUid() {
        return WaterStrainerPlugin.UID_CAT_WORM_BIN;
    }

    public Class<? extends WormBinRecipe> getRecipeClass() {
        return WormBinRecipe.class;
    }

    public Component getTitle() {
        return new TextComponent("Worm Farming");
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    public void draw(WormBinRecipe recipe, PoseStack matrix, double mouseX, double mouseY) {
        ItemStack input = recipe.getInput();
        int healing = input.m_41720_().m_41473_().m_38744_();
        int percWorm = healing > 0 ? (int)(25.0f * (float)healing) : 0;
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.f_91062_.m_92883_(matrix, percWorm + "%", (float)(73 - minecraft.f_91062_.m_92895_(Integer.toString(percWorm)) / 2), 5.0f, -8355712);
    }

    public void setIngredients(WormBinRecipe recipe, IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)recipe.getInput());
        ingredients.setOutputLists(VanillaTypes.ITEM, recipe.getOutput());
    }

    public void setRecipe(IRecipeLayout recipeLayout, WormBinRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 34, 19);
        guiItemStacks.init(1, false, 94, 19);
        guiItemStacks.init(2, false, 114, 19);
        guiItemStacks.set(ingredients);
    }
}

