/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.integration.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mods.waterstrainer.Config;
import mods.waterstrainer.gui.GuiStrainer;
import mods.waterstrainer.gui.GuiWormBin;
import mods.waterstrainer.integration.jei.gardentrowel.GardenTrowelCategory;
import mods.waterstrainer.integration.jei.gardentrowel.GardenTrowelRecipeMaker;
import mods.waterstrainer.integration.jei.strainer.StrainerCategory;
import mods.waterstrainer.integration.jei.strainer.StrainerRecipeMaker;
import mods.waterstrainer.integration.jei.wormbin.WormBinCategory;
import mods.waterstrainer.integration.jei.wormbin.WormBinRecipeMaker;
import mods.waterstrainer.item.ItemStrainer;
import mods.waterstrainer.registry.BlockRegistry;
import mods.waterstrainer.registry.ItemRegistry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class WaterStrainerPlugin
implements IModPlugin {
    public static final ResourceLocation UID_INTERNAL = new ResourceLocation("waterstrainer", "internal");
    public static final ResourceLocation UID_CAT_STRAINER = new ResourceLocation("waterstrainer", "strainer");
    public static final ResourceLocation UID_CAT_WORM_BIN = new ResourceLocation("waterstrainer", "worm_bin");
    public static final ResourceLocation UID_CAT_GARDEN_TROWEL = new ResourceLocation("waterstrainer", "garden_trowel");

    public ResourceLocation getPluginUid() {
        return UID_INTERNAL;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new StrainerCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new WormBinCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new GardenTrowelCategory(guiHelper)});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
    }

    public void registerRecipes(IRecipeRegistration registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        registry.addRecipes(StrainerRecipeMaker.getRecipes(jeiHelpers), UID_CAT_STRAINER);
        registry.addRecipes(WormBinRecipeMaker.getRecipes(jeiHelpers), UID_CAT_WORM_BIN);
        registry.addRecipes(GardenTrowelRecipeMaker.getRecipes(jeiHelpers), UID_CAT_GARDEN_TROWEL);
        if (((Boolean)Config.MISC_ENABLE_ENCHANTING.get()).booleanValue()) {
            for (ItemStrainer strainer : ItemRegistry.getStrainerList(ItemStrainer.StrainerTier.REINFORCED)) {
                registry.addIngredientInfo((Object)new ItemStack((ItemLike)strainer), VanillaTypes.ITEM, new Component[]{new TextComponent("*** Valid Enchantments ***\nEfficiency:\n- Increases efficiency (speed)\nUnbreaking:\n- Increases durability\nFortune:\n- Increases item output\nLuck of the Sea:\n- Increases rare item drop")});
            }
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        registry.addRecipeClickArea(GuiStrainer.class, 155, 5, 15, 15, new ResourceLocation[]{UID_CAT_STRAINER});
        registry.addRecipeClickArea(GuiWormBin.class, 155, 5, 15, 15, new ResourceLocation[]{UID_CAT_WORM_BIN});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        for (ItemStrainer strainer : ItemRegistry.strainers) {
            registry.addRecipeCatalyst(new ItemStack((ItemLike)strainer), new ResourceLocation[]{UID_CAT_STRAINER});
        }
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.worm_bin), new ResourceLocation[]{UID_CAT_WORM_BIN});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ItemRegistry.garden_trowel), new ResourceLocation[]{UID_CAT_GARDEN_TROWEL});
    }
}

