/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.block;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import mods.waterstrainer.item.ItemEfficiencyMeter;
import mods.waterstrainer.item.ItemStrainer;
import mods.waterstrainer.registry.BlockRegistry;
import mods.waterstrainer.tileentity.TileEntityStrainer;
import mods.waterstrainer.util.EfficiencyData;
import mods.waterstrainer.util.WaterStrainerUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;

public class BlockStrainerBase
extends Block
implements EntityBlock {
    public static final IntegerProperty MODELID = IntegerProperty.m_61631_((String)"modelid", (int)0, (int)7);

    public BlockStrainerBase() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76314_).m_60918_(SoundType.f_56736_).m_60955_().m_60913_(2.0f, 5.0f));
        this.setRegistryName("strainer_base");
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)MODELID, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{MODELID});
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag advanced) {
        WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList("Generates items while in water.", "Requires a strainer and water on top."));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTrace) {
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ItemStack heldItemStack = player.m_21120_(hand);
            TileEntityStrainer tile = this.getTileEntity((LevelReader)level, pos);
            if (heldItemStack.m_41720_() instanceof ItemStrainer && tile != null) {
                int slot = player.m_150109_().f_35977_;
                if (tile.inv.getStackInSlot(0) == ItemStack.f_41583_) {
                    tile.inv.setStackInSlot(0, heldItemStack);
                    player.m_150109_().m_6836_(slot, ItemStack.f_41583_);
                    return InteractionResult.SUCCESS;
                }
            }
            if (heldItemStack.m_41720_() instanceof ItemEfficiencyMeter) {
                if (!BlockStrainerBase.isStrainerInLiquid(level, pos)) {
                    WaterStrainerUtils.sendChatMessage((CommandSource)player, ChatFormatting.RED + "Strainer has no water!");
                    return InteractionResult.SUCCESS;
                }
                if (tile != null) {
                    EfficiencyData data = new EfficiencyData(tile);
                    WaterStrainerUtils.sendChatMessage((CommandSource)player, " ");
                    this.printEfficiency(player, "Bonus efficiency", data.getTotalEfficiency());
                    this.printEfficiency(player, "> Strainer type", data.getStrainerTypeEfficiency());
                    this.printEfficiency(player, "> Enchantments", data.getEnchantEfficiency());
                    this.printEfficiency(player, "> Fluid level", data.getFluidLevelEfficiency());
                    this.printEfficiency(player, "> Biome", data.getBiomeEfficiency());
                    this.printEfficiency(player, "> Adjacent strainers", data.getAdjacentBasesEfficiency());
                    return InteractionResult.SUCCESS;
                }
            }
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)tile, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    private void printEfficiency(Player player, String category, float efficiency) {
        if (efficiency == 0.0f) {
            WaterStrainerUtils.sendChatMessage((CommandSource)player, ChatFormatting.GOLD + category + ": " + ChatFormatting.YELLOW + "0%");
        } else if (efficiency > 0.0f) {
            WaterStrainerUtils.sendChatMessage((CommandSource)player, ChatFormatting.GOLD + category + ": " + ChatFormatting.GREEN + "+" + (int)efficiency + "%");
        } else {
            WaterStrainerUtils.sendChatMessage((CommandSource)player, ChatFormatting.GOLD + category + ": " + ChatFormatting.RED + (int)efficiency + "%");
        }
    }

    public static void updateModel(TileEntityStrainer tile) {
        if (tile != null) {
            if (BlockStrainerBase.canStayAt((LevelReader)tile.m_58904_(), tile.m_58899_())) {
                ItemStack strainerStack = tile.inv.getStackInSlot(0);
                if (strainerStack.m_41720_() instanceof ItemStrainer) {
                    BlockStrainerBase.setState(tile.m_58904_(), tile.m_58899_(), ((ItemStrainer)strainerStack.m_41720_()).MODEL);
                } else {
                    BlockStrainerBase.setState(tile.m_58904_(), tile.m_58899_(), Model.BASE_DEFAULT);
                }
            } else {
                BlockStrainerBase.setState(tile.m_58904_(), tile.m_58899_(), Model.BASE_BLOCKED);
            }
        }
    }

    public static void setState(Level world, BlockPos pos, Model model) {
        BlockState state = world.m_8055_(pos);
        if (state == null || state.m_60734_() != BlockRegistry.strainer_base) {
            return;
        }
        int newState = model.id;
        int oldState = (Integer)state.m_61143_((Property)MODELID);
        if (newState != oldState) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)MODELID, (Comparable)Integer.valueOf(newState)));
        }
    }

    public static boolean canStayAt(LevelReader world, BlockPos pos) {
        BlockState state = world.m_8055_(pos.m_7494_());
        Material material = state.m_60767_();
        return material == Material.f_76296_ || material.m_76332_();
    }

    public static boolean isStrainerInLiquid(Level world, BlockPos pos) {
        return world.m_6425_(pos.m_7494_()).m_205070_(FluidTags.f_13131_);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return BlockStrainerBase.canStayAt(world, pos);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        if (!world.m_5776_()) {
            BlockStrainerBase.updateModel(this.getTileEntity((LevelReader)world, pos));
        }
        return super.m_7417_(state, facing, facingState, world, pos, facingPos);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            TileEntityStrainer tile = this.getTileEntity((LevelReader)world, pos);
            if (tile != null) {
                WaterStrainerUtils.dropInventoryItems(world, pos, (IItemHandler)tile.inv);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityStrainer(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return null;
        }
        return (level1, blockPos, blockState, t) -> {
            if (t instanceof TileEntityStrainer) {
                TileEntityStrainer tile = (TileEntityStrainer)t;
                tile.serverTick();
            }
        };
    }

    public TileEntityStrainer getTileEntity(LevelReader world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        return tile instanceof TileEntityStrainer ? (TileEntityStrainer)tile : null;
    }

    public static enum Model {
        BASE_DEFAULT(0),
        BASE_BLOCKED(1),
        STRAINER_SURVIVALIST(2),
        STRAINER_SURVIVALIST_SOLID(3),
        STRAINER_SURVIVALIST_REINFORCED(4),
        STRAINER_FISHERMAN(5),
        STRAINER_FISHERMAN_SOLID(6),
        STRAINER_FISHERMAN_REINFORCED(7);

        public final int id;

        private Model(int id) {
            this.id = id;
        }
    }
}

