/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.AccessLogRecord;

public class BackpackStorage
extends SavedData {
    private static final String SAVED_DATA_NAME = "sophisticatedbackpacks";
    private final Map<UUID, CompoundTag> backpackContents = new HashMap<UUID, CompoundTag>();
    private static final BackpackStorage clientStorageCopy = new BackpackStorage();
    private final Map<UUID, AccessLogRecord> accessLogRecords = new HashMap<UUID, AccessLogRecord>();
    private final Set<UUID> updatedBackpackSettingsFlags = new HashSet<UUID>();

    private BackpackStorage() {
    }

    public static BackpackStorage get() {
        MinecraftServer server;
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            ServerLevel overworld = server.m_129880_(Level.f_46428_);
            DimensionDataStorage storage = overworld.m_8895_();
            return (BackpackStorage)storage.m_164861_(BackpackStorage::load, BackpackStorage::new, SAVED_DATA_NAME);
        }
        return clientStorageCopy;
    }

    public static BackpackStorage load(CompoundTag nbt) {
        BackpackStorage storage = new BackpackStorage();
        BackpackStorage.readBackpackContents(nbt, storage);
        BackpackStorage.readAccessLogs(nbt, storage);
        return storage;
    }

    private static void readAccessLogs(CompoundTag nbt, BackpackStorage storage) {
        for (Tag n : nbt.m_128437_("accessLogRecords", 10)) {
            AccessLogRecord alr = AccessLogRecord.deserializeFromNBT((CompoundTag)n);
            storage.accessLogRecords.put(alr.getBackpackUuid(), alr);
        }
    }

    private static void readBackpackContents(CompoundTag nbt, BackpackStorage storage) {
        for (Tag n : nbt.m_128437_("backpackContents", 10)) {
            CompoundTag uuidContentsPair = (CompoundTag)n;
            UUID uuid = NbtUtils.m_129233_((Tag)Objects.requireNonNull(uuidContentsPair.m_128423_("uuid")));
            CompoundTag contents = uuidContentsPair.m_128469_("contents");
            storage.backpackContents.put(uuid, contents);
        }
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        CompoundTag ret = new CompoundTag();
        this.writeBackpackContents(ret);
        this.writeAccessLogs(ret);
        return ret;
    }

    private void writeBackpackContents(CompoundTag ret) {
        ListTag backpackContentsNbt = new ListTag();
        for (Map.Entry<UUID, CompoundTag> entry : this.backpackContents.entrySet()) {
            CompoundTag uuidContentsPair = new CompoundTag();
            uuidContentsPair.m_128365_("uuid", (Tag)NbtUtils.m_129226_((UUID)entry.getKey()));
            uuidContentsPair.m_128365_("contents", (Tag)entry.getValue());
            backpackContentsNbt.add((Object)uuidContentsPair);
        }
        ret.m_128365_("backpackContents", (Tag)backpackContentsNbt);
    }

    private void writeAccessLogs(CompoundTag ret) {
        ListTag accessLogsNbt = new ListTag();
        for (AccessLogRecord alr : this.accessLogRecords.values()) {
            accessLogsNbt.add((Object)alr.serializeToNBT());
        }
        ret.m_128365_("accessLogRecords", (Tag)accessLogsNbt);
    }

    public CompoundTag getOrCreateBackpackContents(UUID backpackUuid) {
        return this.backpackContents.computeIfAbsent(backpackUuid, uuid -> {
            this.m_77762_();
            return new CompoundTag();
        });
    }

    public void putAccessLog(AccessLogRecord alr) {
        this.accessLogRecords.put(alr.getBackpackUuid(), alr);
        this.m_77762_();
    }

    public void removeBackpackContents(UUID backpackUuid) {
        this.backpackContents.remove(backpackUuid);
    }

    public void setBackpackContents(UUID backpackUuid, CompoundTag contents) {
        if (!this.backpackContents.containsKey(backpackUuid)) {
            this.backpackContents.put(backpackUuid, contents);
            this.updatedBackpackSettingsFlags.add(backpackUuid);
        } else {
            CompoundTag currentContents = this.backpackContents.get(backpackUuid);
            for (String key : contents.m_128431_()) {
                currentContents.m_128365_(key, contents.m_128423_(key));
                if (!key.equals("settings")) continue;
                this.updatedBackpackSettingsFlags.add(backpackUuid);
            }
        }
    }

    public Map<UUID, AccessLogRecord> getAccessLogs() {
        return this.accessLogRecords;
    }

    public int removeNonPlayerBackpackContents(boolean onlyWithEmptyInventory) {
        AtomicInteger numberRemoved = new AtomicInteger(0);
        this.backpackContents.entrySet().removeIf(entry -> {
            if (!(this.accessLogRecords.containsKey(entry.getKey()) || onlyWithEmptyInventory && ((CompoundTag)entry.getValue()).m_128441_("inventory"))) {
                numberRemoved.incrementAndGet();
                return true;
            }
            return false;
        });
        if (numberRemoved.get() > 0) {
            this.m_77762_();
        }
        return numberRemoved.get();
    }

    public boolean removeUpdatedBackpackSettingsFlag(UUID backpackUuid) {
        return this.updatedBackpackSettingsFlags.remove(backpackUuid);
    }
}

