/*
 * Decompiled with CFR 0.152.
 */
package snownee.lightingwand.compat;

import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.extensions.IExtendableRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import snownee.lightingwand.common.RepairRecipe;

@JeiPlugin
public class JEICompat
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("lightingwand", "main");
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        IExtendableRecipeCategory craftingCategory = registration.getCraftingCategory();
        craftingCategory.addCategoryExtension(RepairRecipe.class, RepairRecipeWrapper::new);
    }

    private static class RepairRecipeWrapper
    implements ICraftingCategoryExtension {
        private RepairRecipe recipe;

        public RepairRecipeWrapper(RepairRecipe recipe) {
            this.recipe = recipe;
        }

        public void setRecipe(IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
            builder.setShapeless();
            ItemStack broken = new ItemStack((ItemLike)this.recipe.getRepairable());
            int duration = broken.m_41776_();
            broken.m_41721_(duration);
            craftingGridHelper.setInputs(builder, VanillaTypes.ITEM, List.of(List.of(broken), List.of(this.recipe.getMaterial().m_43908_())), 0, 0);
            ItemStack output = new ItemStack((ItemLike)this.recipe.getRepairable());
            output.m_41721_(Mth.m_14045_((int)(duration - Mth.m_14167_((float)(duration / this.recipe.getRatio()))), (int)0, (int)duration));
            craftingGridHelper.setOutputs(builder, VanillaTypes.ITEM, List.of(output));
        }
    }
}

