/*
 * Decompiled with CFR 0.152.
 */
package snownee.lightingwand;

import com.mojang.math.Vector3f;
import snownee.kiwi.config.KiwiConfig;

@KiwiConfig
public class CommonConfig {
    @KiwiConfig.Comment(value={"Should wand be able to shoot projectile."})
    public static boolean shootProjectile = true;
    @KiwiConfig.Comment(value={"How much FE to repair one use of wand. Zero to disable."})
    @KiwiConfig.Range(min=0.0)
    public static int energyPerUse = 50;
    @KiwiConfig.Comment(value={"Should use glowstone dust to repair wand."})
    public static boolean repairRecipe = true;
    @KiwiConfig.Comment(value={"Max durability of wand."})
    @KiwiConfig.Range(min=1.0)
    public static int wandDurability = 255;
    public static int defaultLightColor = -683;
    public static Vector3f defaultLightColorVector = Vector3f.f_176763_;

    public static void onChanged(String path) {
        if ("defaultLightColor".equals(path)) {
            defaultLightColorVector = CommonConfig.intColorToVector3(defaultLightColor);
        }
    }

    public static Vector3f intColorToVector3(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new Vector3f(r, g, b);
    }

    static {
        CommonConfig.onChanged("defaultLightColor");
    }
}

