/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.core.model.Model;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.function.Supplier;

public abstract class AbstractInstancer<D extends InstanceData>
implements Instancer<D> {
    protected final Supplier<D> factory;
    protected final Model modelData;
    protected final ArrayList<D> data = new ArrayList();
    protected boolean anyToRemove;

    protected AbstractInstancer(Supplier<D> factory, Model modelData) {
        this.factory = factory;
        this.modelData = modelData;
    }

    @Override
    public D createInstance() {
        return (D)this._add((InstanceData)this.factory.get());
    }

    @Override
    public void stealInstance(D inOther) {
        if (((InstanceData)inOther).getOwner() == this) {
            return;
        }
        ((InstanceData)inOther).getOwner().notifyRemoval();
        this._add(inOther);
    }

    @Override
    public void notifyRemoval() {
        this.anyToRemove = true;
    }

    public void clear() {
        this.data.clear();
        this.anyToRemove = true;
    }

    public int getModelVertexCount() {
        return this.modelData.vertexCount();
    }

    public int getInstanceCount() {
        return this.data.size();
    }

    public int getVertexCount() {
        return this.getModelVertexCount() * this.getInstanceCount();
    }

    protected void removeDeletedInstances() {
        int oldSize = this.data.size();
        int removeCount = 0;
        BitSet removeSet = new BitSet(oldSize);
        for (int i = 0; i < oldSize; ++i) {
            InstanceData element = (InstanceData)this.data.get(i);
            if (!element.isRemoved() && element.getOwner() == this) continue;
            removeSet.set(i);
            ++removeCount;
        }
        int newSize = oldSize - removeCount;
        int i = 0;
        for (int j = 0; i < oldSize && j < newSize; ++i, ++j) {
            if ((i = removeSet.nextClearBit(i)) == j) continue;
            InstanceData element = (InstanceData)this.data.get(i);
            this.data.set(j, element);
            element.markDirty();
        }
        this.data.subList(newSize, oldSize).clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private D _add(D instanceData) {
        ((InstanceData)instanceData).setOwner(this);
        ((InstanceData)instanceData).markDirty();
        ArrayList<D> arrayList = this.data;
        synchronized (arrayList) {
            this.data.add(instanceData);
        }
        return instanceData;
    }

    public String toString() {
        return "Instancer[" + this.modelData + "]";
    }
}

