/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CableTiers.gui;

import com.YTrollman.CableTiers.blockentity.TieredExporterBlockEntity;
import com.YTrollman.CableTiers.container.TieredExporterContainerMenu;
import com.YTrollman.CableTiers.gui.TieredScreen;
import com.YTrollman.CableTiers.node.TieredExporterNetworkNode;
import com.YTrollman.CableTiers.util.MathUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.ExactModeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.RedstoneModeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.SideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.TypeSideButton;
import com.refinedmods.refinedstorage.util.RenderUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;

public class TieredExporterScreen
extends TieredScreen<TieredExporterBlockEntity, TieredExporterContainerMenu, TieredExporterNetworkNode> {
    private boolean hasRegulatorMode = this.hasRegulatorMode();

    public TieredExporterScreen(TieredExporterContainerMenu container, Inventory inventory, Component title) {
        super(container, 211, 119 + 18 * MathUtil.ceilDiv(9 * container.getTier().getSlotsMultiplier(), 9), inventory, title);
    }

    private boolean hasRegulatorMode() {
        return ((TieredExporterNetworkNode)((Object)this.getNode())).getUpgrades().hasUpgrade(UpgradeItem.Type.REGULATOR);
    }

    public void onPostInit(int x, int y) {
        this.addSideButton((SideButton)new RedstoneModeSideButton((BaseScreen)this, TieredExporterBlockEntity.REDSTONE_MODE));
        this.addSideButton((SideButton)new TypeSideButton((BaseScreen)this, TieredExporterBlockEntity.TYPE));
        this.addSideButton((SideButton)new ExactModeSideButton((BaseScreen)this, TieredExporterBlockEntity.COMPARE));
    }

    @Override
    public void tick(int x, int y) {
        boolean updatedHasRegulatorMode = this.hasRegulatorMode();
        if (this.hasRegulatorMode != updatedHasRegulatorMode) {
            this.hasRegulatorMode = updatedHasRegulatorMode;
            ((TieredExporterContainerMenu)this.f_97732_).checkRegulator();
        }
    }

    public void renderBackground(PoseStack poseStack, int x, int y, int mouseX, int mouseY) {
        this.bindTexture("cabletiers", "gui/" + this.getTier().getName() + "_exporter_importer_destructor.png");
        this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void renderForeground(PoseStack poseStack, int i, int i1) {
        this.renderString(poseStack, 7, 7, RenderUtils.shorten((String)this.f_96539_.getString(), (int)26));
        this.renderString(poseStack, 7, 24 + 18 * MathUtil.ceilDiv(9 * this.getTier().getSlotsMultiplier(), 9), new TranslatableComponent("container.inventory").getString());
    }
}

