/*
 * Decompiled with CFR 0.152.
 */
package nomowanderer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nomowanderer.Config;
import nomowanderer.Registry;
import nomowanderer.compat.ExternalMods;
import nomowanderer.tileentity.NoSolicitingSignBlockEntity;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="nomowanderer")
public class EntitySpawnHandler {
    @SubscribeEvent
    public static void maybeBlockEntitySpawn(LivingSpawnEvent.SpecialSpawn event) {
        EntitySpawnHandler.checkSpawn((LivingSpawnEvent)event);
    }

    @SubscribeEvent
    public static void maybeBlockEntitySpawn(LivingSpawnEvent.CheckSpawn event) {
        EntitySpawnHandler.checkSpawn((LivingSpawnEvent)event);
    }

    private static void checkSpawn(LivingSpawnEvent event) {
        Entity entity;
        String registryName;
        List blockedEntities = (List)Config.ENTITY_BLOCK_LIST.get();
        if (blockedEntities.contains(registryName = Objects.requireNonNull((entity = event.getEntity()).m_6095_().getRegistryName()).toString())) {
            boolean cancelSpawn;
            boolean bl = cancelSpawn = (Boolean)Config.DISABLE_ENTITY_SPAWNS.get() != false || EntitySpawnHandler.canFindTotem(event) || EntitySpawnHandler.canFindSign(event);
            if (cancelSpawn) {
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                event.setResult(Event.Result.DENY);
            }
        }
    }

    private static boolean canFindTotem(LivingSpawnEvent event) {
        int spawnCheckDist = (Integer)Config.SPAWN_PREV_RANGE.get() * 16;
        boolean curios = ExternalMods.CURIOS.isLoaded();
        AABB aabb = new AABB(event.getX() - (double)spawnCheckDist, event.getY() - (double)spawnCheckDist, event.getZ() - (double)spawnCheckDist, event.getX() + (double)spawnCheckDist, event.getY() + (double)spawnCheckDist, event.getZ() + (double)spawnCheckDist);
        HashSet<Item> totemSet = new HashSet<Item>();
        totemSet.add((Item)Registry.NO_MO_WANDERER_TOTEM_ITEM.get());
        List entities = event.getWorld().m_45976_(Player.class, aabb);
        for (Player player : entities) {
            if (!player.m_150109_().m_18949_(totemSet) && (!curios || !CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)Registry.NO_MO_WANDERER_TOTEM_ITEM.get()).isPresent())) continue;
            return true;
        }
        return false;
    }

    private static boolean canFindSign(LivingSpawnEvent event) {
        BlockPos eventPos = event.getEntity().m_20097_();
        LevelAccessor world = event.getWorld();
        ChunkAccess eventChunk = world.m_46865_(eventPos);
        ArrayList<ChunkAccess> chunks = EntitySpawnHandler.getChunksInRadius(world, eventChunk.m_7697_(), (Integer)Config.SPAWN_PREV_RANGE.get());
        return EntitySpawnHandler.lookForSignsInChunks(chunks);
    }

    private static boolean lookForSignsInChunks(ArrayList<ChunkAccess> chunks) {
        for (ChunkAccess chunk : chunks) {
            if (!(chunk instanceof LevelChunk)) continue;
            LevelChunk newChunk = (LevelChunk)chunk;
            Map tileEntities = newChunk.m_62954_();
            for (BlockPos pos : tileEntities.keySet()) {
                BlockEntity te = (BlockEntity)tileEntities.get(pos);
                if (!(te instanceof NoSolicitingSignBlockEntity)) continue;
                return true;
            }
        }
        return false;
    }

    private static ArrayList<ChunkAccess> getChunksInRadius(LevelAccessor w, ChunkPos chunkPos, int radius) {
        int curX = chunkPos.f_45578_ - radius;
        int startX = curX;
        int endX = chunkPos.f_45578_ + radius;
        int endZ = chunkPos.f_45579_ + radius;
        ArrayList<ChunkAccess> chunks = new ArrayList<ChunkAccess>();
        for (int curZ = chunkPos.f_45579_ - radius; curZ <= endZ; ++curZ) {
            while (curX <= endX) {
                ChunkAccess chunk = w.m_6325_(curX, curZ);
                chunks.add(chunk);
                ++curX;
            }
            curX = startX;
        }
        return chunks;
    }
}

