/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.immersiveengineering.recipe;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientStackJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class IERecipeJS
extends RecipeJS {
    public final List<FluidTagInput> inputFluids = new ArrayList<FluidTagInput>(1);
    public final List<FluidStack> outputFluids = new ArrayList<FluidStack>(1);

    public JsonElement serializeIngredientStack(IngredientStackJS in) {
        if (in.getCount() == 1) {
            return in.ingredient.toJson();
        }
        JsonObject o = new JsonObject();
        o.addProperty("count", (Number)in.getCount());
        o.add("base_ingredient", in.ingredient.toJson());
        return o;
    }

    public IngredientJS convertReplacedInput(int index, IngredientJS oldIngredient, IngredientJS newIngredient) {
        return newIngredient.asIngredientStack();
    }

    public IngredientStackJS parseIngredientItemIE(JsonElement json) {
        JsonObject obj;
        if (json instanceof JsonObject && (obj = (JsonObject)json).has("base_ingredient")) {
            int c = GsonHelper.m_13824_((JsonObject)obj, (String)"count", (int)1);
            return IngredientJS.of((Object)obj.get("base_ingredient")).withCount(c).asIngredientStack();
        }
        return IngredientJS.of((Object)json).asIngredientStack();
    }

    public IERecipeJS time(int t) {
        this.json.addProperty("time", (Number)t);
        this.save();
        return this;
    }

    public IERecipeJS energy(int e) {
        this.json.addProperty("energy", (Number)e);
        this.save();
        return this;
    }

    public ItemStackJS parseResultItem(@Nullable Object o) {
        JsonObject json;
        if (o instanceof JsonObject && ((json = (JsonObject)o).has("base_ingredient") || json.has("tag"))) {
            return ItemStackJS.of((Object)IEApi.getPreferredStackbyMod((ItemStack[])IngredientWithSize.deserialize((JsonElement)json).getMatchingStacks()));
        }
        return super.parseResultItem(o);
    }
}

