/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tileentities;

import com.direwolf20.buildinggadgets.common.capability.CapabilityTemplate;
import com.direwolf20.buildinggadgets.common.containers.TemplateManagerContainer;
import com.direwolf20.buildinggadgets.common.tileentities.OurTileEntities;
import com.direwolf20.buildinggadgets.common.util.ref.Reference;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TemplateManagerTileEntity
extends BlockEntity
implements MenuProvider {
    public static final TagKey<Item> TEMPLATE_CONVERTIBLES = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)Reference.ItemReference.TAG_TEMPLATE_CONVERTIBLE);
    public static final int SIZE = 2;
    private final ItemStackHandler itemStackHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            TemplateManagerTileEntity.this.m_6596_();
        }

        private boolean isTemplateStack(ItemStack stack) {
            return stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).isPresent();
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0 && this.isTemplateStack(stack) || slot == 1 && (this.isTemplateStack(stack) || stack.m_204117_(TEMPLATE_CONVERTIBLES));
        }
    };
    private LazyOptional<IItemHandler> handlerOpt;

    public TemplateManagerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)OurTileEntities.TEMPLATE_MANAGER_TILE_ENTITY.get(), pos, state);
    }

    @Nonnull
    public Component m_5446_() {
        return new TextComponent("Template Manager GUI");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        Preconditions.checkArgument((this.m_58904_() != null ? 1 : 0) != 0);
        return new TemplateManagerContainer(windowId, playerInventory, this);
    }

    public void onLoad() {
        this.onChunkUnloaded();
        this.handlerOpt = LazyOptional.of(() -> this.itemStackHandler);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("items")) {
            this.itemStackHandler.deserializeNBT(nbt.m_128469_("items"));
        }
    }

    @Nonnull
    protected void m_183515_(CompoundTag compound) {
        compound.m_128365_("items", (Tag)this.itemStackHandler.serializeNBT());
        super.m_183515_(compound);
    }

    public boolean canInteractWith(Player playerIn) {
        return !this.m_58901_() && playerIn.m_20238_(Vec3.m_82528_((Vec3i)this.f_58858_).m_82520_(0.5, 0.5, 0.5)) <= 64.0;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.handlerOpt != null) {
            return this.handlerOpt.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onChunkUnloaded() {
        if (this.handlerOpt != null) {
            this.handlerOpt.invalidate();
            this.handlerOpt = null;
        }
    }
}

