/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.template;

import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileDataSerializer;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.building.view.IBuildView;
import com.direwolf20.buildinggadgets.common.tainted.building.view.PositionalBuildView;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.tainted.registry.Registries;
import com.direwolf20.buildinggadgets.common.tainted.template.SerialisationSupport;
import com.direwolf20.buildinggadgets.common.tainted.template.TemplateHeader;
import com.direwolf20.buildinggadgets.common.util.CommonUtils;
import com.direwolf20.buildinggadgets.common.util.compression.DataCompressor;
import com.direwolf20.buildinggadgets.common.util.compression.DataDecompressor;
import com.direwolf20.buildinggadgets.common.util.tools.MathUtils;
import com.direwolf20.buildinggadgets.common.util.tools.RegistryUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;

public final class Template {
    private final ImmutableMap<BlockPos, BlockData> map;
    private TemplateHeader header;
    private boolean isNormalized;

    public static Template deserialize(CompoundTag nbt, @Nullable TemplateHeader externalHeader, boolean persisted) {
        ListTag posList = nbt.m_128437_("pos", 4);
        TemplateHeader.Builder header = TemplateHeader.builderFromNBT(nbt.m_128469_("header"));
        if (externalHeader != null) {
            header = header.name(externalHeader.getName()).author(externalHeader.getAuthor());
        }
        DataDecompressor<ITileDataSerializer> serializerDecompressor = persisted ? new DataDecompressor<ITileDataSerializer>(nbt.m_128437_("serializer", 8), inbt -> RegistryUtils.getFromString(Registries.TileEntityData.getTileDataSerializers(), inbt.m_7916_()), value -> SerialisationSupport.dummyDataSerializer()) : null;
        DataDecompressor<BlockData> dataDecompressor = new DataDecompressor<BlockData>(nbt.m_128437_("data", 10), inbt -> persisted ? BlockData.tryDeserialize((CompoundTag)inbt, serializerDecompressor, true) : BlockData.tryDeserialize((CompoundTag)inbt, false), value -> BlockData.AIR);
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Tag inbt2 : posList) {
            LongTag longNBT = (LongTag)inbt2;
            BlockPos pos = MathUtils.posFromLong(longNBT.m_7046_());
            BlockData data = dataDecompressor.apply(MathUtils.readStateId(longNBT.m_7046_()));
            mapBuilder.put((Object)pos, (Object)data);
        }
        return new Template((ImmutableMap<BlockPos, BlockData>)mapBuilder.build(), header.build());
    }

    public Template(ImmutableMap<BlockPos, BlockData> map, TemplateHeader header) {
        this(map, header, false);
    }

    private Template(ImmutableMap<BlockPos, BlockData> map, TemplateHeader header, boolean isNormalized) {
        this.map = map;
        this.header = header;
        this.isNormalized = isNormalized;
    }

    public Template() {
        this((ImmutableMap<BlockPos, BlockData>)ImmutableMap.of(), TemplateHeader.builder(Region.singleZero()).build());
    }

    public TemplateHeader getHeaderAndForceMaterials(BuildContext context) {
        if (this.header.getRequiredItems() == null) {
            MaterialList materialList = CommonUtils.estimateRequiredItems(this.createViewInContext(context), context, context.getPlayer() != null ? context.getPlayer().m_20182_().m_82520_(0.0, (double)context.getPlayer().m_20192_(), 0.0) : null);
            this.header = TemplateHeader.builderOf(this.header).requiredItems(materialList).build();
        }
        return this.getHeader();
    }

    public TemplateHeader getHeader() {
        return this.header;
    }

    public IBuildView createViewInContext(BuildContext context) {
        return PositionalBuildView.createUnsafe(context, this.map, this.header.getBoundingBox());
    }

    public CompoundTag serialize(boolean persisted) {
        if (!this.isNormalized) {
            return this.normalize().serialize(persisted);
        }
        CompoundTag res = new CompoundTag();
        ListTag posList = new ListTag();
        DataCompressor<BlockData> blockDataCompressor = new DataCompressor<BlockData>();
        DataCompressor<ITileDataSerializer> dataSerializerCompressor = new DataCompressor<ITileDataSerializer>();
        for (Map.Entry entry : this.map.entrySet()) {
            long posEntry = MathUtils.includeStateId(MathUtils.posToLong((BlockPos)entry.getKey()), blockDataCompressor.applyAsInt((BlockData)entry.getValue()));
            posList.add((Object)LongTag.m_128882_((long)posEntry));
        }
        ListTag dataList = blockDataCompressor.write(d -> persisted ? d.serialize(dataSerializerCompressor, true) : d.serialize(false));
        ListTag serializerList = persisted ? dataSerializerCompressor.write(s -> StringTag.m_129297_((String)s.getRegistryName().toString())) : null;
        res.m_128365_("data", (Tag)dataList);
        res.m_128365_("pos", (Tag)posList);
        res.m_128365_("header", (Tag)this.header.toNBT(persisted));
        if (persisted) {
            res.m_128365_("serializer", (Tag)serializerList);
        }
        return res;
    }

    public Template rotate(Rotation rotation) {
        return this.rotate(Direction.Axis.Y, rotation);
    }

    public Template rotate(Direction.Axis axis, Rotation rotation) {
        if (this.map.isEmpty()) {
            return this;
        }
        int[][] matrix = MathUtils.rotationMatrixFor(axis, rotation);
        rotation = axis == Direction.Axis.Y ? rotation : Rotation.NONE;
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        Region.Builder regionBuilder = Region.enclosingBuilder();
        for (Map.Entry entry : this.map.entrySet()) {
            BlockPos newPos = MathUtils.matrixMul(matrix, (BlockPos)entry.getKey());
            mapBuilder.put((Object)newPos, (Object)((BlockData)entry.getValue()).rotate(rotation));
            regionBuilder.enclose((Vec3i)newPos);
        }
        return new Template((ImmutableMap<BlockPos, BlockData>)mapBuilder.build(), TemplateHeader.builderOf(this.header, regionBuilder.build()).build()).normalize();
    }

    public Template mirror(Direction.Axis axis) {
        Mirror mirror;
        int xFac = 1;
        int zFac = 1;
        switch (axis) {
            case X: {
                mirror = Mirror.LEFT_RIGHT;
                zFac = -1;
                break;
            }
            case Z: {
                mirror = Mirror.FRONT_BACK;
                xFac = -1;
                break;
            }
            default: {
                mirror = Mirror.NONE;
            }
        }
        Region.Builder regionBuilder = Region.enclosingBuilder();
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.map.entrySet()) {
            BlockPos newPos = new BlockPos(((BlockPos)entry.getKey()).m_123341_() * xFac, ((BlockPos)entry.getKey()).m_123342_(), ((BlockPos)entry.getKey()).m_123343_() * zFac);
            mapBuilder.put((Object)newPos, (Object)((BlockData)entry.getValue()).mirror(mirror));
            regionBuilder.enclose((Vec3i)newPos);
        }
        return new Template((ImmutableMap<BlockPos, BlockData>)mapBuilder.build(), TemplateHeader.builderOf(this.header, regionBuilder.build()).build()).normalize();
    }

    public Template replace(Function<BlockPos, Optional<BlockData>> replacements) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.map.entrySet()) {
            mapBuilder.put((Object)((BlockPos)entry.getKey()), (Object)replacements.apply((BlockPos)entry.getKey()).orElse((BlockData)entry.getValue()));
        }
        return new Template((ImmutableMap<BlockPos, BlockData>)mapBuilder.build(), this.header, this.isNormalized);
    }

    public Template withName(@Nullable String name) {
        return new Template(this.map, TemplateHeader.builderOf(this.header).name(name).build());
    }

    public Template withNameAndAuthor(@Nullable String name, @Nullable String author) {
        return new Template(this.map, TemplateHeader.builderOf(this.header).name(name).author(author).build());
    }

    public Template clearMaterials() {
        return new Template(this.map, TemplateHeader.builderOf(this.header).requiredItems(null).build());
    }

    public Template normalize() {
        if (this.isNormalized) {
            return this;
        }
        Region region = this.header.getBoundingBox();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : this.map.entrySet()) {
            builder.put((Object)((BlockPos)entry.getKey()).m_141950_((Vec3i)region.getMin()), (Object)((BlockData)entry.getValue()));
        }
        return new Template((ImmutableMap<BlockPos, BlockData>)builder.build(), TemplateHeader.builderOf(this.header, region.inverseTranslate((Vec3i)region.getMin())).build(), true);
    }
}

