/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.building;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileDataSerializer;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileEntityData;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.tainted.registry.Registries;
import com.direwolf20.buildinggadgets.common.util.tools.RegistryUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;

public final class BlockData {
    public static final BlockData AIR = new BlockData(Blocks.f_50016_.m_49966_(), TileSupport.dummyTileEntityData());
    private final BlockState state;
    private final ITileEntityData tileData;

    @Nullable
    public static BlockData tryDeserialize(@Nullable CompoundTag tag, boolean persisted) {
        return BlockData.tryDeserialize(tag, persisted ? null : i -> RegistryUtils.getById(Registries.TileEntityData.getTileDataSerializers(), i), persisted);
    }

    @Nullable
    public static BlockData tryDeserialize(@Nullable CompoundTag tag, @Nullable IntFunction<ITileDataSerializer> serializerProvider, boolean readDataPersisted) {
        ITileDataSerializer serializer;
        if (!(tag != null && tag.m_128441_("state") && tag.m_128441_("serializer") && tag.m_128441_("data"))) {
            return null;
        }
        BlockState state = NbtUtils.m_129241_((CompoundTag)tag.m_128469_("state"));
        try {
            serializer = serializerProvider == null ? RegistryUtils.getFromString(Registries.TileEntityData.getTileDataSerializers(), tag.m_128461_("serializer")) : serializerProvider.apply(tag.m_128451_("serializer"));
        }
        catch (Exception e) {
            BuildingGadgets.LOG.error("Failed to create deserializer!", (Throwable)e);
            return null;
        }
        if (serializer == null) {
            return null;
        }
        ITileEntityData data = serializer.deserialize(tag.m_128469_("data"), readDataPersisted);
        return new BlockData(state, data);
    }

    public static BlockData deserialize(CompoundTag tag, boolean persisted) {
        return BlockData.deserialize(tag, persisted ? null : i -> RegistryUtils.getById(Registries.TileEntityData.getTileDataSerializers(), i), persisted);
    }

    public static BlockData deserialize(CompoundTag tag, @Nullable IntFunction<ITileDataSerializer> serializerProvider, boolean readDataPersisted) {
        ITileDataSerializer serializer;
        Preconditions.checkNotNull((Object)tag, (Object)"Cannot deserialize from a null tag compound");
        Preconditions.checkArgument((tag.m_128441_("state") && tag.m_128441_("serializer") && tag.m_128441_("data") ? 1 : 0) != 0, (String)"Given NBTTagCompound does not contain a valid BlockData instance. Missing NBT-Keys in Tag {}!", (Object)tag.toString());
        BlockState state = NbtUtils.m_129241_((CompoundTag)tag.m_128469_("state"));
        try {
            serializer = serializerProvider == null ? RegistryUtils.getFromString(Registries.TileEntityData.getTileDataSerializers(), tag.m_128461_("serializer")) : serializerProvider.apply(tag.m_128451_("serializer"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not retrieve serializer with persisted=" + readDataPersisted + "!", e);
        }
        Preconditions.checkArgument((serializer != null ? 1 : 0) != 0, (String)"Failed to retrieve serializer for tag {} and persisted={}", (Object)tag.toString(), (Object)readDataPersisted);
        ITileEntityData data = serializer.deserialize(tag.m_128469_("data"), readDataPersisted);
        return new BlockData(state, data);
    }

    public BlockData(BlockState state, ITileEntityData tileData) {
        this.state = Objects.requireNonNull(state);
        this.tileData = Objects.requireNonNull(tileData);
    }

    public BlockState getState() {
        return this.state;
    }

    public ITileEntityData getTileData() {
        return this.tileData;
    }

    public boolean placeIn(BuildContext context, BlockPos pos) {
        return this.tileData.placeIn(context, this.state, pos);
    }

    public CompoundTag serialize(boolean persisted) {
        return this.serialize(persisted ? null : ser -> RegistryUtils.getId(Registries.TileEntityData.getTileDataSerializers(), ser), persisted);
    }

    public CompoundTag serialize(@Nullable ToIntFunction<ITileDataSerializer> idGetter, boolean writeDataPersisted) {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("state", (Tag)NbtUtils.m_129202_((BlockState)this.state));
        if (idGetter == null) {
            tag.m_128359_("serializer", this.tileData.getSerializer().getRegistryName().toString());
        } else {
            tag.m_128405_("serializer", idGetter.applyAsInt(this.tileData.getSerializer()));
        }
        tag.m_128365_("data", (Tag)this.tileData.getSerializer().serialize(this.tileData, writeDataPersisted));
        return tag;
    }

    public BlockData mirror(Mirror mirror) {
        return new BlockData(this.getState().m_60715_(mirror), this.getTileData());
    }

    public BlockData rotate(Rotation rotation) {
        return new BlockData(this.getState().m_60717_(rotation), this.getTileData());
    }

    public MaterialList getRequiredItems(BuildContext context, @Nullable HitResult target, @Nullable BlockPos pos) {
        return this.getTileData().getRequiredItems(context, this.getState(), target, pos);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockData)) {
            return false;
        }
        BlockData blockData = (BlockData)o;
        if (!this.getState().equals(blockData.getState())) {
            return false;
        }
        return this.getTileData().equals(blockData.getTileData());
    }

    public int hashCode() {
        int result = this.getState().hashCode();
        result = 31 * result + this.getTileData().hashCode();
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("state", (Object)this.state).add("tileData", (Object)this.tileData).toString();
    }
}

