/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.modes;

import com.direwolf20.buildinggadgets.common.blocks.OurBlocks;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.tileentities.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.Shapes;

public abstract class AbstractMode {
    private boolean isExchanging;

    public AbstractMode(boolean isExchanging) {
        this.isExchanging = isExchanging;
    }

    abstract List<BlockPos> collect(UseContext var1, Player var2, BlockPos var3);

    public List<BlockPos> getCollection(UseContext context, Player player) {
        BlockPos startPos = this.withOffset(context.getStartPos(), context.getHitSide(), context.isPlaceOnTop());
        BlockState lookingAtState = this.isExchanging() ? context.getWorldState(startPos) : null;
        return this.collect(context, player, startPos).stream().filter(e -> this.isExchanging ? this.exchangingValidator((BlockPos)e, lookingAtState, context) : this.validator(player, (BlockPos)e, context)).sorted(Comparator.comparing(pos -> player.m_142538_().m_123331_((Vec3i)pos))).collect(Collectors.toList());
    }

    public boolean validator(Player player, BlockPos pos, UseContext context) {
        if (!context.getWorldState(pos).m_60629_(context.createBlockUseContext(player))) {
            return false;
        }
        if (context.world.m_151570_(pos)) {
            return false;
        }
        return (Boolean)Config.GENERAL.allowOverwriteBlocks.get() != false ? context.getWorldState(pos).m_60767_().m_76336_() : context.getWorldState(pos).m_60767_() != Material.f_76296_;
    }

    private boolean exchangingValidator(BlockPos pos, BlockState lookingAtState, UseContext context) {
        BlockState worldBlockState = context.getWorldState(pos);
        BlockEntity te = context.getWorld().m_7702_(pos);
        if (worldBlockState.m_60767_() == Material.f_76296_ || worldBlockState.m_60767_().m_76332_()) {
            return false;
        }
        if (worldBlockState == ((Block)OurBlocks.EFFECT_BLOCK.get()).m_49966_() || worldBlockState == context.getSetState()) {
            return false;
        }
        if (!(te == null || te instanceof ConstructionBlockTileEntity && te.m_58900_() != context.getSetState())) {
            return false;
        }
        if (worldBlockState.m_60800_((BlockGetter)context.getWorld(), pos) < 0.0f) {
            return false;
        }
        if (worldBlockState.m_60734_().m_49966_() != lookingAtState.m_60734_().m_49966_() && !context.isFuzzy()) {
            return false;
        }
        boolean hasSingeValid = false;
        for (Direction direction : Direction.values()) {
            BlockPos offset = pos.m_142300_(direction);
            BlockState state = context.getWorld().m_8055_(offset);
            if (!state.m_60795_() && (state.m_60808_((BlockGetter)context.getWorld(), offset) == Shapes.m_83144_() || state.m_60734_() instanceof StairBlock)) continue;
            hasSingeValid = true;
            break;
        }
        return hasSingeValid;
    }

    public BlockPos withOffset(BlockPos pos, Direction side, boolean placeOnTop) {
        return placeOnTop ? pos.m_5484_(side, 1) : pos;
    }

    public boolean isExchanging() {
        return this.isExchanging;
    }

    public static class UseContext {
        private final Level world;
        private final BlockState setState;
        private final BlockPos startPos;
        private final Direction hitSide;
        private final boolean isFuzzy;
        private final boolean placeOnTop;
        private final int range;
        private final boolean rayTraceFluid;
        private final boolean isConnected;

        public UseContext(Level world, BlockState setState, BlockPos startPos, ItemStack gadget, Direction hitSide, boolean placeOnTop, boolean isConnected) {
            this.world = world;
            this.setState = setState;
            this.startPos = startPos;
            this.range = GadgetUtils.getToolRange(gadget);
            this.isFuzzy = AbstractGadget.getFuzzy(gadget);
            this.rayTraceFluid = AbstractGadget.shouldRayTraceFluid(gadget);
            this.hitSide = hitSide;
            this.isConnected = isConnected;
            this.placeOnTop = placeOnTop;
        }

        public UseContext(Level world, BlockState setState, BlockPos startPos, ItemStack gadget, Direction hitSide, boolean isConnected) {
            this(world, setState, startPos, gadget, hitSide, false, isConnected);
        }

        public BlockPlaceContext createBlockUseContext(Player player) {
            return new BlockPlaceContext(new UseOnContext(player, InteractionHand.MAIN_HAND, VectorHelper.getLookingAt(player, this.rayTraceFluid)));
        }

        public boolean isConnected() {
            return this.isConnected;
        }

        public BlockState getWorldState(BlockPos pos) {
            return this.world.m_8055_(pos);
        }

        public Level getWorld() {
            return this.world;
        }

        public BlockState getSetState() {
            return this.setState;
        }

        public boolean isFuzzy() {
            return this.isFuzzy;
        }

        public boolean isRayTraceFluid() {
            return this.rayTraceFluid;
        }

        public boolean isPlaceOnTop() {
            return this.placeOnTop;
        }

        public int getRange() {
            return this.range;
        }

        public BlockPos getStartPos() {
            return this.startPos;
        }

        public Direction getHitSide() {
            return this.hitSide;
        }

        public String toString() {
            return "UseContext{world=" + this.world + ", setState=" + this.setState + ", startPos=" + this.startPos + ", hitSide=" + this.hitSide + ", isFuzzy=" + this.isFuzzy + ", placeOnTop=" + this.placeOnTop + ", range=" + this.range + ", rayTraceFluid=" + this.rayTraceFluid + "}";
        }
    }
}

