/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.SwitchBlock;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.Overlay;

public class ContactSwitchBlock
extends SwitchBlock {
    public ContactSwitchBlock(long config, BlockBehaviour.Properties properties, AABB unrotatedBBUnpowered, @Nullable AABB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config | 0x40000000L, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    @Override
    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return side == null || side == Direction.UP && !this.isWallMount() || side == ((Direction)state.m_61143_((Property)FACING)).m_122424_();
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float distance) {
        if ((this.config & 0x400000000000L) != 0L) {
            this.onEntityCollided(world, pos, world.m_8055_(pos));
        }
        super.m_142072_(world, state, pos, entity, distance);
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        if (world.m_5776_()) {
            return;
        }
        if ((this.config & 0xC00000000000L) == 0xC00000000000L && !entity.m_6144_()) {
            this.onEntityCollided(world, pos, world.m_8055_(pos));
        }
    }

    @Override
    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (world.m_5776_()) {
            return;
        }
        if ((this.config & 0x400000000000L) != 0L && (double)entity.f_19789_ < 0.2) {
            return;
        }
        this.onEntityCollided(world, pos, state);
    }

    @Override
    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        if ((this.config & 0x400000000000L) != 0L || !this.onEntityCollided((Level)world, pos, state)) {
            super.m_7458_(state, world, pos, random);
        }
    }

    protected boolean onEntityCollided(Level world, BlockPos pos, BlockState state) {
        if (world.m_5776_()) {
            return false;
        }
        ContactSwitchTileEntity te = this.getTe((LevelReader)world, pos);
        if (te == null) {
            return false;
        }
        boolean active = false;
        boolean powered = (Boolean)state.m_61143_((Property)POWERED);
        List hits = world.m_45976_(te.filter_class(), this.detectionVolume(pos));
        if (hits.size() >= te.entity_count_threshold()) {
            if (te.high_sensitivity()) {
                active = true;
            } else {
                for (Entity e : hits) {
                    if (e.m_6090_()) continue;
                    active = true;
                    break;
                }
            }
        }
        if (active) {
            int t = te.configured_on_time();
            te.on_timer_reset(t <= 0 ? 20 : Math.max(t, 4));
        }
        if (active && !powered) {
            state = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true));
            world.m_7731_(pos, state, 27);
            this.power_on_sound.play(world, pos);
            this.notifyNeighbours(world, pos, state, te, false);
            if ((this.config & 0x100000000000000L) != 0L && !te.activateSwitchLinks(te.setpower(), 15, true)) {
                ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(world, pos);
            }
        }
        te.reschedule_block_tick();
        return active;
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ContactSwitchTileEntity(pos, state);
    }

    protected AABB detectionVolume(BlockPos pos) {
        return new AABB(Vec3.m_82528_((Vec3i)pos), Vec3.m_82528_((Vec3i)pos).m_82520_(1.0, 2.0, 1.0));
    }

    @Override
    public ContactSwitchTileEntity getTe(LevelReader world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (!(te instanceof ContactSwitchTileEntity)) {
            return null;
        }
        return (ContactSwitchTileEntity)te;
    }

    public static class ContactSwitchTileEntity
    extends SwitchBlock.SwitchTileEntity {
        public static final Class<?>[] filter_classes = new Class[]{Entity.class, LivingEntity.class, Player.class, Monster.class, Animal.class, Villager.class, ItemEntity.class};
        public static final String[] filter_class_names = new String[]{"everything", "creatures", "players", "mobs", "animals", "villagers", "objects"};
        private static final int max_entity_count = 64;
        private boolean high_sensitivity_ = false;
        private int count_threshold_ = 1;
        private int filter_ = 0;

        public ContactSwitchTileEntity(BlockEntityType<?> te_type, BlockPos pos, BlockState state) {
            super(te_type, pos, state);
        }

        public ContactSwitchTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.TET_CONTACT_SWITCH, pos, state);
        }

        public int filter() {
            return this.filter_;
        }

        public void filter(int sel) {
            this.filter_ = sel < 0 ? 0 : (sel >= filter_classes.length ? filter_classes.length - 1 : sel);
        }

        public Class<?> filter_class() {
            return this.filter_ <= 0 ? filter_classes[0] : (this.filter_ >= filter_classes.length ? filter_classes[filter_classes.length - 1] : filter_classes[this.filter_]);
        }

        public boolean high_sensitivity() {
            return this.high_sensitivity_;
        }

        public void high_sensitivity(boolean sel) {
            this.high_sensitivity_ = sel;
        }

        public int entity_count_threshold() {
            return this.count_threshold_;
        }

        public void entity_count_threshold(int sel) {
            this.count_threshold_ = sel < 1 ? 1 : Math.min(sel, 64);
        }

        @Override
        public void write(CompoundTag nbt, boolean updatePacket) {
            super.write(nbt, updatePacket);
            nbt.m_128405_("filter", this.filter());
            nbt.m_128379_("highsensitive", this.high_sensitivity());
            nbt.m_128405_("entitythreshold", this.entity_count_threshold());
        }

        @Override
        public void read(CompoundTag nbt, boolean updatePacket) {
            super.read(nbt, updatePacket);
            this.filter(nbt.m_128451_("filter"));
            this.high_sensitivity(nbt.m_128471_("highsensitive"));
            this.entity_count_threshold(nbt.m_128451_("entitythreshold"));
        }

        @Override
        public void reset(@Nullable LevelReader world) {
            super.reset(world);
            this.filter_ = 0;
            this.count_threshold_ = 1;
            this.high_sensitivity_ = false;
            this.configured_on_time(20);
        }

        @Override
        public boolean activation_config(BlockState state, @Nullable Player player, double x, double y, boolean show_only) {
            if (state == null) {
                return false;
            }
            SwitchBlock block = (SwitchBlock)state.m_60734_();
            int direction = 0;
            int field = 0;
            if (block.isLateral()) {
                int n = y >= 13.0 && y <= 15.0 ? 1 : (direction = y >= 10.0 && y <= 12.0 ? -1 : 0);
                int n2 = x >= 9.5 && x <= 10.1 ? 1 : (x >= 10.9 && x <= 11.7 ? 2 : (x >= 12.2 && x <= 13.0 ? 3 : (field = x >= 13.5 && x <= 14.2 ? 4 : 0)));
            }
            if (direction == 0 || field == 0) {
                return false;
            }
            if (!show_only) {
                switch (field) {
                    case 1: {
                        this.high_sensitivity(direction > 0);
                        break;
                    }
                    case 2: {
                        this.entity_count_threshold(this.entity_count_threshold() + direction);
                        break;
                    }
                    case 3: {
                        this.filter(this.filter() + direction);
                        break;
                    }
                    case 4: {
                        this.setpower(Mth.m_14045_((int)(this.setpower() + direction), (int)1, (int)15));
                    }
                }
                this.m_6596_();
            }
            Overlay.show(player, (Component)new TextComponent("").m_7220_((Component)Auxiliaries.localizable("switchconfig.touchcontactmat.sensitivity", ChatFormatting.BLUE, new Object[]{Auxiliaries.localizable("switchconfig.touchcontactmat.sensitivity." + (this.high_sensitivity() ? "high" : "normal"))})).m_130946_(" | ").m_7220_((Component)Auxiliaries.localizable("switchconfig.touchcontactmat.entity_threshold", ChatFormatting.YELLOW, new Object[]{this.entity_count_threshold()})).m_130946_(" | ").m_7220_((Component)Auxiliaries.localizable("switchconfig.touchcontactmat.entity_filter", ChatFormatting.DARK_GREEN, new Object[]{new TranslatableComponent("rsgauges.switchconfig.touchcontactmat.entity_filter." + filter_class_names[this.filter_])})).m_130946_(" | ").m_7220_((Component)Auxiliaries.localizable("switchconfig.touchcontactmat.output_power", ChatFormatting.RED, new Object[]{this.setpower()})));
            return true;
        }
    }
}

