/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import wile.rsgauges.ModConfig;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.GaugeBlock;
import wile.rsgauges.blocks.IndicatorBlock;
import wile.rsgauges.blocks.RsBlock;
import wile.rsgauges.blocks.RsDirectedBlock;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.detail.SwitchLink;
import wile.rsgauges.items.SwitchLinkPearlItem;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.Overlay;

public class AbstractGaugeBlock
extends RsDirectedBlock
implements EntityBlock,
SwitchLink.ISwitchLinkable {
    public static final long GAUGE_DATA_POWER_MASK = 15L;
    public static final int GAUGE_DATA_POWER_SHIFT = 0;
    public static final long GAUGE_DATA_BLINKING = 256L;
    public static final long GAUGE_DATA_INVERTED = 512L;
    public static final long GAUGE_DATA_COMPARATOR_MODE = 2048L;
    @Nullable
    public final ModResources.BlockSoundEvent power_on_sound;
    @Nullable
    public final ModResources.BlockSoundEvent power_off_sound;

    public AbstractGaugeBlock(long config, BlockBehaviour.Properties props, AABB aabb, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, props, aabb, null);
        this.power_on_sound = powerOnSound;
        this.power_off_sound = powerOffSound;
    }

    public AbstractGaugeBlock(long config, BlockBehaviour.Properties props, AABB aabb) {
        this(config, props, aabb, null, null);
    }

    @Override
    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (world.m_5776_() || !this.isAffectedByNeigbour(state, (LevelAccessor)world, pos, fromPos)) {
            return;
        }
        GaugeTileEntity te = this.getTe((LevelReader)world, pos);
        if (te == null) {
            te.reset_timer();
        }
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        world.m_186460_(pos, state.m_60734_(), 1);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack_held = player.m_21120_(hand);
        if (ModConfig.isWrench(stack_held)) {
            GaugeTileEntity te = this.getTe((LevelReader)world, pos);
            if (te == null) {
                return InteractionResult.CONSUME;
            }
            te.on_wrench(state, world, pos, player, player.m_21120_(hand));
        } else if (stack_held.m_41720_() == Items.f_42584_ || stack_held.m_41720_() == ModContent.SWITCH_LINK_PEARL) {
            this.m_6256_(state, world, pos, player);
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
        ItemStack item_held = player.m_150109_().m_36056_();
        if (item_held.m_41720_() == Items.f_42584_) {
            if (ModConfig.without_switch_linking) {
                return;
            }
            ItemStack link_stack = SwitchLinkPearlItem.createFromPearl(world, pos, player);
            if (link_stack.m_41619_()) {
                Overlay.show(player, (Component)Auxiliaries.localizable("switchlinking.target_assign.error_notarget"));
                ModResources.BlockSoundEvents.SWITCHLINK_CANNOT_LINK_THAT.play(world, pos);
            } else {
                player.m_150109_().m_6836_(player.m_150109_().f_35977_, link_stack);
                Overlay.show(player, (Component)Auxiliaries.localizable("switchlinking.target_assign.ok"));
                ModResources.BlockSoundEvents.SWITCHLINK_LINK_TARGET_SELECTED.play(world, pos);
            }
        } else if (item_held.m_41720_() == ModContent.SWITCH_LINK_PEARL) {
            if (ModConfig.without_switch_linking) {
                return;
            }
            if (SwitchLinkPearlItem.cycleLinkMode(item_held, world, pos, true)) {
                Overlay.show(player, (Component)Auxiliaries.localizable("switchlinking.relayconfig.confval" + Integer.toString(SwitchLink.fromItemStack(item_held).mode().index())));
            } else {
                Overlay.show(player, (Component)Auxiliaries.localizable("switchlinking.source_assign.error_nosource"));
            }
        }
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return false;
    }

    public boolean getWeakChanges(BlockState state, LevelReader world, BlockPos pos) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return state.m_60734_() instanceof AbstractGaugeBlock && side == ((Direction)state.m_61143_((Property)FACING)).m_122424_();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        return state == null ? null : (state.m_61138_((Property)GaugeBlock.POWER) ? (BlockState)state.m_61124_((Property)GaugeBlock.POWER, (Comparable)Integer.valueOf(0)) : state);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new GaugeTileEntity(pos, state);
    }

    @Override
    public boolean isWallMount() {
        return true;
    }

    @Override
    public boolean isCube() {
        return false;
    }

    @Override
    public boolean isLateral() {
        return false;
    }

    @Override
    public boolean switchLinkHasTargetSupport(Level world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean switchLinkHasSourceSupport(Level world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean switchLinkHasAnalogSupport(Level world, BlockPos pos) {
        return true;
    }

    @Override
    public ImmutableList<SwitchLink.LinkMode> switchLinkGetSupportedTargetModes() {
        return ImmutableList.of((Object)((Object)SwitchLink.LinkMode.AS_STATE), (Object)((Object)SwitchLink.LinkMode.INV_STATE));
    }

    @Override
    public Optional<Integer> switchLinkOutputPower(Level world, BlockPos pos) {
        GaugeTileEntity te = this.getTe((LevelReader)world, pos);
        if (te == null) {
            return Optional.empty();
        }
        return Optional.of(te.power());
    }

    @Override
    public Optional<Integer> switchLinkInputPower(Level world, BlockPos pos) {
        return Optional.empty();
    }

    @Override
    public Optional<Integer> switchLinkComparatorInput(Level world, BlockPos pos) {
        return Optional.empty();
    }

    @Override
    public SwitchLink.RequestResult switchLinkTrigger(SwitchLink link) {
        GaugeTileEntity te = this.getTe((LevelReader)link.world, link.target_position);
        if (te == null) {
            return SwitchLink.RequestResult.TARGET_GONE;
        }
        te.switchlink_input(link.source_analog_power);
        return SwitchLink.RequestResult.OK;
    }

    @Override
    public void switchLinkInit(SwitchLink link) {
        GaugeTileEntity te = this.getTe((LevelReader)link.world, link.target_position);
        if (te != null) {
            te.switchlink_input(link.source_analog_power);
        }
    }

    @Override
    public void switchLinkUnlink(SwitchLink link) {
        GaugeTileEntity te = this.getTe((LevelReader)link.world, link.target_position);
        if (te != null) {
            te.switchlink_input(0);
        }
    }

    public GaugeTileEntity getTe(LevelReader world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        return te instanceof GaugeTileEntity ? (GaugeTileEntity)te : null;
    }

    public static class GaugeTileEntity
    extends RsBlock.RsTileEntity {
        private boolean alternation_state_ = false;
        private long trigger_timer_ = 0L;
        private long scd_ = 0L;
        private long last_wrench_click_ = 0L;
        private int switchlink_input_ = 0;

        public GaugeTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.TET_GAUGE, pos, state);
        }

        public int power() {
            return (int)((this.scd_ & 0xFL) >> 0);
        }

        public void power(int p) {
            this.scd_ = this.scd_ & 0xFFFFFFFFFFFFFFF0L | (long)((p <= 0 ? 0 : Math.min(p, 15)) << 0) & 0xFL;
        }

        public boolean inverted() {
            return (this.scd_ & 0x200L) != 0L;
        }

        public void inverted(boolean i) {
            this.scd_ = this.scd_ & 0xFFFFFFFFFFFFFDFFL | (i ? 512L : 0L);
        }

        public int switchlink_input() {
            return this.switchlink_input_;
        }

        public void switchlink_input(int power) {
            this.switchlink_input_ = power;
            this.trigger_timer_ = Math.min(this.trigger_timer_, 1L);
        }

        public boolean comparator_mode() {
            return (this.scd_ & 0x800L) != 0L;
        }

        public void comparator_mode(boolean i) {
            this.scd_ = this.scd_ & 0xFFFFFFFFFFFFF7FFL | (i ? 2048L : 0L);
        }

        public void reset_timer() {
            this.trigger_timer_ = 0L;
        }

        public void reset() {
            this.reset((LevelReader)this.m_58904_());
        }

        public void reset(LevelReader world) {
            this.trigger_timer_ = 0L;
            if (world == null) {
                this.scd_ = 0L;
            } else {
                try {
                    long current_scd = this.scd_;
                    this.scd_ = (int)((AbstractGaugeBlock)world.m_8055_((BlockPos)this.m_58899_()).m_60734_()).config;
                    if (current_scd != this.scd_) {
                        this.m_6596_();
                    }
                }
                catch (Exception e) {
                    this.scd_ = 0L;
                }
            }
        }

        public void on_wrench(BlockState state, Level world, BlockPos pos, Player player, ItemStack wrench) {
            long t = world.m_46467_();
            if (Math.abs(t - this.last_wrench_click_) < 40L) {
                switch ((this.inverted() ? 1 : 0) | (this.comparator_mode() ? 2 : 0)) {
                    case 0: {
                        this.inverted(true);
                        this.comparator_mode(false);
                        break;
                    }
                    case 1: {
                        this.inverted(false);
                        this.comparator_mode(true);
                        break;
                    }
                    case 2: {
                        this.inverted(true);
                        this.comparator_mode(true);
                        break;
                    }
                    default: {
                        this.inverted(false);
                        this.comparator_mode(false);
                    }
                }
            }
            this.last_wrench_click_ = t;
            TranslatableComponent tr = Auxiliaries.localizable("gaugeconfig.options." + (this.inverted() ? "inverted" : "notinverted"), ChatFormatting.DARK_AQUA, new Object[0]);
            if (this.comparator_mode()) {
                tr.m_7220_((Component)new TextComponent(" | ")).m_7220_((Component)Auxiliaries.localizable("gaugeconfig.options.comparator", ChatFormatting.DARK_AQUA, new Object[0]));
            }
            Overlay.show(player, (Component)tr);
        }

        @Override
        public void write(CompoundTag nbt, boolean updatePacket) {
            nbt.m_128356_("scd", this.scd_);
            nbt.m_128405_("lnkinp", this.switchlink_input_);
        }

        @Override
        public void read(CompoundTag nbt, boolean updatePacket) {
            this.scd_ = nbt.m_128454_("scd");
            this.switchlink_input_ = nbt.m_128451_("lnkinp");
        }

        @Override
        public void tick() {
            if (--this.trigger_timer_ > 0L) {
                return;
            }
            this.trigger_timer_ = ModConfig.gauge_update_interval;
            BlockState state = this.m_58900_();
            Block block = state.m_60734_();
            if (!(block instanceof AbstractGaugeBlock)) {
                return;
            }
            AbstractGaugeBlock block2 = (AbstractGaugeBlock)block;
            try {
                boolean sync;
                BlockPos neighbourPos = this.f_58858_.m_5484_((Direction)state.m_61143_((Property)FACING), -1);
                if (!this.f_58857_.m_46805_(neighbourPos)) {
                    return;
                }
                BlockState neighborState = this.f_58857_.m_8055_(neighbourPos);
                int p = 0;
                if (this.comparator_mode()) {
                    if (neighborState.m_60807_()) {
                        p = neighborState.m_60674_(this.f_58857_, neighbourPos);
                    }
                } else if (block2 instanceof IndicatorBlock && this.f_58857_.m_46753_(this.m_58899_())) {
                    p = 15;
                } else if (neighborState.m_60803_()) {
                    p = this.f_58857_.m_46681_(neighbourPos, ((Direction)state.m_61143_((Property)RsDirectedBlock.FACING)).m_122424_());
                } else if (neighborState.m_60807_()) {
                    p = neighborState.m_60674_(this.f_58857_, neighbourPos);
                } else {
                    boolean is_indicator = block2 instanceof IndicatorBlock;
                    for (Direction nbf : Direction.values()) {
                        if (p >= 15 || is_indicator && p > 0) break;
                        BlockPos nbp = neighbourPos.m_142300_(nbf);
                        if (!this.f_58857_.m_46805_(nbp)) continue;
                        BlockState nbs = this.f_58857_.m_8055_(nbp);
                        p = Math.max(p, this.f_58857_.m_46681_(nbp, nbf));
                    }
                }
                if (this.inverted()) {
                    p = Mth.m_14045_((int)(15 - p), (int)0, (int)15);
                }
                boolean bl = sync = this.power() != p;
                if ((block2.config & 0x100L) == 0L) {
                    if (block2.power_on_sound != null && this.power() == 0 && p > 0) {
                        block2.power_on_sound.play(this.f_58857_, this.f_58858_);
                    } else if (block2.power_off_sound != null && this.power() > 0 && p == 0) {
                        block2.power_off_sound.play(this.f_58857_, this.f_58858_);
                    }
                }
                p = Math.max(p, this.switchlink_input_);
                this.power(p);
                if (block2 instanceof IndicatorBlock) {
                    boolean powered;
                    boolean bl2 = powered = p != 0;
                    if ((Boolean)state.m_61143_((Property)IndicatorBlock.POWERED) != powered) {
                        this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)IndicatorBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 19);
                    }
                } else if (block2 instanceof GaugeBlock && (Integer)state.m_61143_((Property)GaugeBlock.POWER) != p) {
                    this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)GaugeBlock.POWER, (Comparable)Integer.valueOf(p)), 27);
                }
                if ((block2.power_off_sound != null || block2.power_on_sound != null) && (block2.config & 0x100L) != 0L && block2 instanceof IndicatorBlock) {
                    if (((Boolean)state.m_61143_((Property)IndicatorBlock.POWERED)).booleanValue()) {
                        boolean alternation;
                        boolean bl3 = alternation = (this.f_58857_.m_46467_() & 0xFL) < 8L;
                        if (alternation != this.alternation_state_) {
                            this.alternation_state_ = alternation;
                            if (alternation && block2.power_on_sound != null) {
                                block2.power_on_sound.play(this.f_58857_, this.f_58858_);
                            } else if (!alternation && block2.power_off_sound != null) {
                                block2.power_off_sound.play(this.f_58857_, this.f_58858_);
                            }
                        }
                    } else {
                        this.alternation_state_ = true;
                    }
                }
            }
            catch (Throwable e) {
                this.trigger_timer_ = 100L;
                Auxiliaries.logger().error("TE update() failed: " + e);
            }
        }
    }
}

