/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wile.rsgauges.ModConfig;
import wile.rsgauges.ModContent;
import wile.rsgauges.detail.BlockCategories;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.Networking;
import wile.rsgauges.libmc.detail.OptionalRecipeCondition;
import wile.rsgauges.libmc.detail.Overlay;
import wile.rsgauges.libmc.detail.PlayerBlockInteraction;
import wile.rsgauges.libmc.detail.Registries;

@Mod(value="rsgauges")
public class ModRsGauges {
    public static final String MODID = "rsgauges";
    public static final String MODNAME = "Gauges and Switches";
    public static final int VERSION_DATAFIXER = 0;
    private static final Logger LOGGER = LogManager.getLogger();

    public ModRsGauges() {
        Auxiliaries.init(MODID, LOGGER, ModConfig::getServerConfig);
        Auxiliaries.logGitVersion(MODNAME);
        Registries.init(MODID, "industrial_small_lever");
        ModContent.init(MODID);
        OptionalRecipeCondition.init(MODID, LOGGER);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfig.COMMON_CONFIG_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ForgeEvents::onSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ForgeEvents::onClientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        PlayerBlockInteraction.init(MODID, LOGGER);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static final class ForgeEvents {
        @SubscribeEvent
        public static final void onRegisterBlocks(RegistryEvent.Register<Block> event) {
            Registries.onBlockRegistry((rl, block) -> event.getRegistry().register((IForgeRegistryEntry)block));
        }

        @SubscribeEvent
        public static final void onRegisterItems(RegistryEvent.Register<Item> event) {
            Registries.onItemRegistry((rl, item) -> event.getRegistry().register((IForgeRegistryEntry)item));
        }

        @SubscribeEvent
        public static final void onRegisterBlockEntityTypes(RegistryEvent.Register<BlockEntityType<?>> event) {
            Registries.onBlockEntityRegistry((rl, tet) -> event.getRegistry().register((IForgeRegistryEntry)tet));
        }

        @SubscribeEvent
        public static final void onRegisterSounds(RegistryEvent.Register<SoundEvent> event) {
            ModResources.registerSoundEvents(event);
        }

        public static void onSetup(FMLCommonSetupEvent event) {
            CraftingHelper.register((IConditionSerializer)OptionalRecipeCondition.Serializer.INSTANCE);
            Networking.init(ModRsGauges.MODID);
            BlockCategories.update();
        }

        public static void onClientSetup(FMLClientSetupEvent event) {
            Overlay.register();
            ModContent.processContentClientSide(event);
        }

        @SubscribeEvent
        public static void onConfigLoad(ModConfigEvent.Loading event) {
            ModConfig.apply();
        }

        @SubscribeEvent
        public static void onConfigReload(ModConfigEvent.Reloading event) {
            try {
                Auxiliaries.logger().info("Config file changed {}", (Object)event.getConfig().getFileName());
                ModConfig.apply();
            }
            catch (Throwable e) {
                Auxiliaries.logger().error("Failed to load changed config: " + e.getMessage());
            }
        }
    }
}

