/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges;

import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ObjectHolder;
import wile.rsgauges.blocks.AbstractGaugeBlock;
import wile.rsgauges.blocks.BistableKnockSwitchBlock;
import wile.rsgauges.blocks.BistableSwitchBlock;
import wile.rsgauges.blocks.ComparatorSwitchBlock;
import wile.rsgauges.blocks.ContactMatBlock;
import wile.rsgauges.blocks.ContactSwitchBlock;
import wile.rsgauges.blocks.DayTimerSwitchBlock;
import wile.rsgauges.blocks.DimmerSwitchBlock;
import wile.rsgauges.blocks.DoorSensorSwitchBlock;
import wile.rsgauges.blocks.ElevatorSwitchBlock;
import wile.rsgauges.blocks.EntityDetectorSwitchBlock;
import wile.rsgauges.blocks.EnvironmentalSensorSwitchBlock;
import wile.rsgauges.blocks.GaugeBlock;
import wile.rsgauges.blocks.IndicatorBlock;
import wile.rsgauges.blocks.IntervalTimerSwitchBlock;
import wile.rsgauges.blocks.LinkReceiverSwitchBlock;
import wile.rsgauges.blocks.LinkSenderSwitchBlock;
import wile.rsgauges.blocks.ObserverSwitchBlock;
import wile.rsgauges.blocks.PowerPlantBlock;
import wile.rsgauges.blocks.PulseKnockSwitchBlock;
import wile.rsgauges.blocks.PulseSwitchBlock;
import wile.rsgauges.blocks.RsBlock;
import wile.rsgauges.blocks.SensitiveGlassBlock;
import wile.rsgauges.blocks.SwitchBlock;
import wile.rsgauges.blocks.TrapdoorSwitchBlock;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.items.SwitchLinkPearlItem;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.Registries;

public class ModContent {
    @ObjectHolder(value="rsgauges:te_gauge")
    public static final BlockEntityType<AbstractGaugeBlock.GaugeTileEntity> TET_GAUGE = null;
    @ObjectHolder(value="rsgauges:te_switch")
    public static final BlockEntityType<SwitchBlock.SwitchTileEntity> TET_SWITCH = null;
    @ObjectHolder(value="rsgauges:te_contact_switch")
    public static final BlockEntityType<ContactSwitchBlock.ContactSwitchTileEntity> TET_CONTACT_SWITCH = null;
    @ObjectHolder(value="rsgauges:te_detector_switch")
    public static final BlockEntityType<EntityDetectorSwitchBlock.DetectorSwitchTileEntity> TET_DETECTOR_SWITCH = null;
    @ObjectHolder(value="rsgauges:te_envsensor_switch")
    public static final BlockEntityType<EnvironmentalSensorSwitchBlock.EnvironmentalSensorSwitchTileEntity> TET_ENVSENSOR_SWITCH = null;
    @ObjectHolder(value="rsgauges:te_daytimer_switch")
    public static final BlockEntityType<DayTimerSwitchBlock.DayTimerSwitchTileEntity> TET_DAYTIMER_SWITCH = null;
    @ObjectHolder(value="rsgauges:te_intervaltimer_switch")
    public static final BlockEntityType<IntervalTimerSwitchBlock.IntervalTimerSwitchTileEntity> TET_TIMER_SWITCH = null;
    @ObjectHolder(value="rsgauges:te_comparator_switch")
    public static final BlockEntityType<ComparatorSwitchBlock.ComparatorSwitchTileEntity> TET_COMPARATOR_SWITCH = null;
    @ObjectHolder(value="rsgauges:te_observer_switch")
    public static final BlockEntityType<ObserverSwitchBlock.ObserverSwitchTileEntity> TET_OBSERVER_SWITCH = null;
    @ObjectHolder(value="rsgauges:te_doorsensor_switch")
    public static final BlockEntityType<DoorSensorSwitchBlock.DoorSensorSwitchTileEntity> TET_DOORSENSOR_SWITCH = null;
    @ObjectHolder(value="rsgauges:switchlink_pearl")
    public static final SwitchLinkPearlItem SWITCH_LINK_PEARL = null;

    public static void init(String modid) {
        detail.MODID = modid;
        ModContent.initTags();
        ModContent.initBlocks();
        ModContent.initItems();
    }

    private static void initTags() {
        Registries.addOptionalBlockTag("clay_like", "minecraft:clay");
        Registries.addOptionalBlockTag("glass_like", "minecraft:glass");
        Registries.addOptionalBlockTag("logs", "minecraft:oak_log");
        Registries.addOptionalBlockTag("ores", "minecraft:iron_ore");
        Registries.addOptionalBlockTag("planks", "minecraft:oak_planks");
        Registries.addOptionalBlockTag("plants", "minecraft:dandelion");
        Registries.addOptionalBlockTag("saplings", "minecraft:oak_sapling");
        Registries.addOptionalBlockTag("slabs", "minecraft:oak_slab");
        Registries.addOptionalBlockTag("soils", "minecraft:farmland");
        Registries.addOptionalBlockTag("stone_like", "minecraft:stone");
        Registries.addOptionalBlockTag("water_like", "minecraft:water");
        Registries.addOptionalBlockTag("wooden", "minecraft:oak_log");
    }

    public static void initBlocks() {
        Registries.addBlock("industrial_small_lever", () -> new BistableSwitchBlock(5980780305419599872L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(4.0, 4.0, 0.0, 12.0, 15.0, 4.0), Auxiliaries.getPixeledAABB(4.0, 1.0, 0.0, 12.0, 12.0, 4.0)));
        Registries.addBlock("industrial_lever", () -> new BistableSwitchBlock(5980780305419599872L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(5.0, 4.0, 0.0, 11.0, 15.0, 5.0), Auxiliaries.getPixeledAABB(5.0, 1.0, 0.0, 11.0, 12.0, 5.0)));
        Registries.addBlock("industrial_rotary_lever", () -> new BistableSwitchBlock(5980780305419599872L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(1.0, 4.0, 0.0, 12.0, 12.0, 6.0), Auxiliaries.getPixeledAABB(1.0, 1.0, 0.0, 12.0, 12.0, 6.0)));
        Registries.addBlock("industrial_rotary_machine_switch", () -> new BistableSwitchBlock(5980780305419599872L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(4.0, 4.0, 0.0, 12.0, 12.0, 1.5), null));
        Registries.addBlock("industrial_machine_switch", () -> new BistableSwitchBlock(5980780305419599872L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(4.0, 4.0, 0.0, 12.0, 12.0, 1.5), null));
        Registries.addBlock("industrial_estop_switch", () -> new BistableSwitchBlock(5980815489791688704L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(5.0, 5.0, 0.0, 11.0, 11.0, 2.5), Auxiliaries.getPixeledAABB(5.0, 5.0, 0.0, 11.0, 11.0, 3.5)));
        Registries.addBlock("industrial_hopper_switch", () -> new BistableSwitchBlock(5980780305419600384L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(3.0, 10.0, 0.0, 13.0, 12.0, 6.7), Auxiliaries.getPixeledAABB(3.0, 10.0, 0.0, 13.0, 12.0, 3.7)));
        Registries.addBlock("industrial_button", () -> new PulseSwitchBlock(5980833082300694528L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(5.0, 5.0, 0.0, 11.0, 11.0, 2.0), null));
        Registries.addBlock("industrial_fenced_button", () -> new PulseSwitchBlock(5980780305742561280L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(5.0, 5.0, 0.0, 11.0, 11.0, 2.0), null));
        Registries.addBlock("industrial_double_pole_button", () -> new PulseSwitchBlock(5980780305742561280L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(4.0, 4.0, 0.0, 12.0, 12.0, 3.0), Auxiliaries.getPixeledAABB(4.0, 4.0, 0.0, 12.0, 12.0, 2.0)));
        Registries.addBlock("industrial_foot_button", () -> new PulseSwitchBlock(5980780305742561280L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(5.0, 3.0, 0.0, 11.0, 7.0, 4.0), null));
        Registries.addBlock("industrial_pull_handle", () -> new PulseSwitchBlock(5980780305742561280L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(4.0, 4.0, 0.0, 12.0, 12.0, 2.0), Auxiliaries.getPixeledAABB(4.0, 4.0, 0.0, 12.0, 12.0, 2.0)));
        Registries.addBlock("industrial_dimmer", () -> new DimmerSwitchBlock(5836665117082648576L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(4.0, 1.0, 0.0, 12.0, 15.0, 2.0), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.01f, 1.9f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.01f, 1.7f)));
        Registries.addBlock("industrial_door_contact_mat", () -> new ContactMatBlock(-7998392937120530432L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(1.0, 0.0, 0.0, 15.0, 1.0, 13.0), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.1f, 1.3f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.1f, 1.2f)));
        Registries.addBlock("industrial_contact_mat", () -> new ContactMatBlock(-7998392937128919040L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 1.0, 16.0), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.1f, 1.3f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.1f, 1.2f)));
        Registries.addBlock("industrial_shock_sensitive_contact_mat", () -> new ContactMatBlock(-7998322568384741376L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 1.0, 16.0), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.1f, 1.3f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.1f, 1.2f)));
        Registries.addBlock("industrial_shock_sensitive_trapdoor", () -> new TrapdoorSwitchBlock(-3238017762254127104L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(0.0, 15.6, 0.0, 16.0, 16.0, 16.0), Auxiliaries.getPixeledAABB(0.0, 2.0, 0.0, 16.0, 1.0, 0.1), new ModResources.BlockSoundEvent(SoundEvents.f_12055_, 0.05f, 3.0f), new ModResources.BlockSoundEvent(SoundEvents.f_12055_, 0.05f, 2.5f)));
        Registries.addBlock("industrial_high_sensitive_trapdoor", () -> new TrapdoorSwitchBlock(-3237877024765771776L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(0.0, 15.6, 0.0, 16.0, 16.0, 16.0), Auxiliaries.getPixeledAABB(0.0, 2.0, 0.0, 16.0, 1.0, 0.1), new ModResources.BlockSoundEvent(SoundEvents.f_12055_, 0.05f, 2.5f), new ModResources.BlockSoundEvent(SoundEvents.f_12055_, 0.05f, 2.0f)));
        Registries.addBlock("industrial_fallthrough_detector", () -> new TrapdoorSwitchBlock(-3386706918701531136L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(0.1, 12.6, 0.1, 15.9, 13.0, 15.9), Auxiliaries.getPixeledAABB(0.1, 12.6, 0.1, 15.9, 13.0, 15.9), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.05f, 2.5f), null));
        Registries.addBlock("industrial_day_timer", () -> new DayTimerSwitchBlock(5836665121378664448L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(4.0, 4.0, 0.0, 12.0, 12.0, 1.5), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.1f, 1.3f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.1f, 1.2f)));
        Registries.addBlock("industrial_interval_timer", () -> new IntervalTimerSwitchBlock(5908722719711559680L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(4.0, 4.0, 0.0, 12.0, 12.0, 1.5), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.1f, 1.3f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.1f, 1.2f)));
        Registries.addBlock("industrial_entity_detector", () -> new EntityDetectorSwitchBlock(5836665134267760640L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(6.0, 6.0, 0.0, 10.0, 10.0, 1.0), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.1f, 1.3f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.1f, 1.2f)));
        Registries.addBlock("industrial_linear_entity_detector", () -> new EntityDetectorSwitchBlock(5836665151447629824L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(6.0, 6.0, 0.0, 10.0, 10.0, 1.0), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.1f, 1.3f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.1f, 1.2f)));
        Registries.addBlock("industrial_light_sensor", () -> new EnvironmentalSensorSwitchBlock(5836665185803173888L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(4.0, 4.0, 0.0, 12.0, 12.0, 1.5), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.1f, 1.3f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.1f, 1.2f)));
        Registries.addBlock("industrial_rain_sensor", () -> new EnvironmentalSensorSwitchBlock(5836665254522650624L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(4.0, 4.0, 0.0, 12.0, 12.0, 1.5), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.1f, 1.3f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.1f, 1.2f)));
        Registries.addBlock("industrial_lightning_sensor", () -> new EnvironmentalSensorSwitchBlock(5836665391961604096L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(4.0, 4.0, 0.0, 12.0, 12.0, 1.5), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.1f, 1.3f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.1f, 1.2f)));
        Registries.addBlock("industrial_comparator_switch", () -> new ComparatorSwitchBlock(5836665117083697152L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(4.0, 10.0, 0.0, 12.0, 15.0, 1.5), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.1f, 1.3f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.1f, 1.2f)));
        Registries.addBlock("industrial_block_detector", () -> new ObserverSwitchBlock(1229483248039718912L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(0.5, 0.5, 0.5, 15.5, 15.5, 15.5), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.2f, 1.3f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.2f, 1.2f)));
        Registries.addBlock("industrial_switchlink_receiver", () -> new LinkReceiverSwitchBlock(5980780305419599872L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(4.0, 4.0, 0.0, 12.0, 12.0, 1.5), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.01f, 1.9f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.01f, 1.7f), false));
        Registries.addBlock("industrial_switchlink_receiver_analog", () -> new LinkReceiverSwitchBlock(5980780305418551296L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(4.0, 4.0, 0.0, 12.0, 12.0, 1.5), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.01f, 1.9f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.01f, 1.7f), true));
        Registries.addBlock("industrial_switchlink_cased_receiver", () -> new LinkReceiverSwitchBlock(220676382012993536L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.01f, 1.9f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.01f, 1.7f), false));
        Registries.addBlock("industrial_switchlink_pulse_receiver", () -> new LinkReceiverSwitchBlock(5980780305725784064L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(4.0, 4.0, 0.0, 12.0, 12.0, 1.5), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.01f, 1.9f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.01f, 1.7f), false));
        Registries.addBlock("industrial_switchlink_cased_pulse_receiver", () -> new LinkReceiverSwitchBlock(220676382319177728L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.01f, 1.9f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.01f, 1.7f), false));
        Registries.addBlock("industrial_switchlink_relay", () -> new LinkSenderSwitchBlock(6269010681569214976L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(4.0, 4.0, 0.0, 12.0, 12.0, 1.5), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.01f, 1.9f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.01f, 1.7f), false));
        Registries.addBlock("industrial_switchlink_relay_analog", () -> new LinkSenderSwitchBlock(6269010681569214976L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(4.0, 4.0, 0.0, 12.0, 12.0, 1.5), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.01f, 1.9f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.01f, 1.7f), true));
        Registries.addBlock("industrial_switchlink_pulse_relay", () -> new LinkSenderSwitchBlock(6269010681875399168L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(4.0, 4.0, 0.0, 12.0, 12.0, 1.5), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.01f, 1.9f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.01f, 1.7f), false));
        Registries.addBlock("industrial_knock_switch", () -> new BistableKnockSwitchBlock(5408823152743804928L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(0.5, 0.5, 0.5, 15.5, 15.5, 15.5), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.2f, 1.3f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.2f, 1.2f)));
        Registries.addBlock("industrial_knock_button", () -> new PulseKnockSwitchBlock(6561744657673613312L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(0.5, 0.5, 0.5, 15.5, 15.5, 15.5), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.2f, 1.3f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.2f, 1.2f)));
        Registries.addBlock("industrial_analog_angular_gauge", () -> new GaugeBlock(0x1000000000000000L, detail.gauge_metallic_block_properties(), Auxiliaries.getPixeledAABB(2.0, 2.0, 0.0, 14.0, 14.0, 1.0)));
        Registries.addBlock("industrial_analog_horizontal_gauge", () -> new GaugeBlock(0x1000000000000000L, detail.gauge_metallic_block_properties(), Auxiliaries.getPixeledAABB(2.0, 4.0, 0.0, 14.0, 12.0, 1.0)));
        Registries.addBlock("industrial_vertical_bar_gauge", () -> new GaugeBlock(0x1000000000000000L, detail.gauge_metallic_block_properties(), Auxiliaries.getPixeledAABB(4.0, 2.0, 0.0, 12.0, 14.0, 1.0)));
        Registries.addBlock("industrial_small_digital_gauge", () -> new GaugeBlock(0x1000000000000000L, detail.gauge_metallic_block_properties(), Auxiliaries.getPixeledAABB(4.0, 5.0, 0.0, 12.0, 11.0, 1.0)));
        Registries.addBlock("industrial_tube_gauge", () -> new GaugeBlock(0x1000000000000000L, detail.gauge_metallic_block_properties(), Auxiliaries.getPixeledAABB(7.0, 4.0, 0.0, 9.0, 12.0, 3.0)));
        Registries.addBlock("industrial_alarm_lamp", () -> new IndicatorBlock(0x1000000000000100L, detail.alarm_lamp_block_properties(), Auxiliaries.getPixeledAABB(6.0, 6.0, 0.0, 10.0, 10.0, 4.0)));
        Registries.addBlock("industrial_alarm_siren", () -> new IndicatorBlock(0x1000000000000100L, detail.indicator_metallic_block_properties(), Auxiliaries.getPixeledAABB(4.0, 6.5, 0.0, 11.5, 9.5, 4.0), new ModResources.BlockSoundEvent(ModResources.ALARM_SIREN_SOUND, 2.0f), null));
        Registries.addBlock("industrial_green_led", () -> new IndicatorBlock(0x1000000000000000L, detail.indicator_metallic_block_properties(), Auxiliaries.getPixeledAABB(6.0, 6.0, 0.0, 10.0, 10.0, 0.5)));
        Registries.addBlock("industrial_yellow_led", () -> new IndicatorBlock(0x1000000000000000L, detail.indicator_metallic_block_properties(), Auxiliaries.getPixeledAABB(6.0, 6.0, 0.0, 10.0, 10.0, 0.5)));
        Registries.addBlock("industrial_red_led", () -> new IndicatorBlock(0x1000000000000000L, detail.indicator_metallic_block_properties(), Auxiliaries.getPixeledAABB(6.0, 6.0, 0.0, 10.0, 10.0, 0.5)));
        Registries.addBlock("industrial_white_led", () -> new IndicatorBlock(0x1000000000000000L, detail.indicator_metallic_block_properties(), Auxiliaries.getPixeledAABB(6.0, 6.0, 0.0, 10.0, 10.0, 0.5)));
        Registries.addBlock("industrial_green_blinking_led", () -> new IndicatorBlock(0x1000000000000100L, detail.indicator_metallic_block_properties(), Auxiliaries.getPixeledAABB(6.0, 6.0, 0.0, 10.0, 10.0, 0.5)));
        Registries.addBlock("industrial_yellow_blinking_led", () -> new IndicatorBlock(0x1000000000000100L, detail.indicator_metallic_block_properties(), Auxiliaries.getPixeledAABB(6.0, 6.0, 0.0, 10.0, 10.0, 0.5)));
        Registries.addBlock("industrial_red_blinking_led", () -> new IndicatorBlock(0x1000000000000100L, detail.indicator_metallic_block_properties(), Auxiliaries.getPixeledAABB(6.0, 6.0, 0.0, 10.0, 10.0, 0.5)));
        Registries.addBlock("industrial_white_blinking_led", () -> new IndicatorBlock(0x1000000000000000L, detail.indicator_metallic_block_properties(), Auxiliaries.getPixeledAABB(6.0, 6.0, 0.0, 10.0, 10.0, 0.5)));
        Registries.addBlock("rustic_lever", () -> new BistableSwitchBlock(5980780305419599872L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(6.0, 5.0, 0.0, 10.3, 15.0, 4.5), Auxiliaries.getPixeledAABB(6.0, 2.0, 0.0, 10.3, 11.0, 4.5)));
        Registries.addBlock("rustic_two_hinge_lever", () -> new BistableSwitchBlock(5980780305419599872L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(2.0, 6.0, 0.0, 14.0, 13.0, 4.5), Auxiliaries.getPixeledAABB(2.0, 4.0, 0.0, 14.0, 10.0, 4.5)));
        Registries.addBlock("rustic_angular_lever", () -> new BistableSwitchBlock(5980780305419599872L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(0.0, 10.0, 0.0, 14.0, 15.0, 4.5), Auxiliaries.getPixeledAABB(6.0, 2.0, 0.0, 14.0, 15.0, 4.5)));
        Registries.addBlock("rustic_nail_lever", () -> new BistableSwitchBlock(5980780305419599872L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(6.0, 7.0, 0.0, 9.0, 10.0, 3.0), null));
        Registries.addBlock("rustic_button", () -> new PulseSwitchBlock(5980833082300694528L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(5.0, 5.0, 0.0, 11.0, 11.0, 2.5), null));
        Registries.addBlock("rustic_small_button", () -> new PulseSwitchBlock(5980833082300694528L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(6.0, 6.0, 0.0, 10.0, 10.0, 2.5), null));
        Registries.addBlock("rustic_spring_reset_chain", () -> new PulseSwitchBlock(5980780305742561280L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(5.0, 3.5, 0.0, 11.0, 15.0, 4.0), null));
        Registries.addBlock("rustic_nail_button", () -> new PulseSwitchBlock(5980780305742561280L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(6.0, 7.0, 0.0, 9.0, 10.0, 3.0), null));
        Registries.addBlock("rustic_door_contact_plate", () -> new ContactMatBlock(-7998392937120530432L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(1.0, 0.0, 0.0, 15.0, 1.0, 12.0), Auxiliaries.getPixeledAABB(1.0, 0.0, 0.0, 15.0, 0.5, 12.0), new ModResources.BlockSoundEvent(SoundEvents.f_12055_, 0.05f, 2.5f), new ModResources.BlockSoundEvent(SoundEvents.f_12055_, 0.05f, 2.0f)));
        Registries.addBlock("rustic_contact_plate", () -> new ContactMatBlock(-7998392937128919040L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 1.0, 16.0), Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 0.5, 16.0), new ModResources.BlockSoundEvent(SoundEvents.f_12055_, 0.05f, 2.5f), new ModResources.BlockSoundEvent(SoundEvents.f_12055_, 0.05f, 2.0f)));
        Registries.addBlock("rustic_shock_sensitive_plate", () -> new ContactMatBlock(-7998322568384741376L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 1.0, 16.0), Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 0.5, 16.0), new ModResources.BlockSoundEvent(SoundEvents.f_12055_, 0.05f, 2.5f), new ModResources.BlockSoundEvent(SoundEvents.f_12055_, 0.05f, 2.0f)));
        Registries.addBlock("rustic_shock_sensitive_trapdoor", () -> new TrapdoorSwitchBlock(-3238017762254127104L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(0.0, 15.6, 0.0, 16.0, 16.0, 16.0), Auxiliaries.getPixeledAABB(0.0, 2.0, 0.0, 16.0, 16.0, 0.1), new ModResources.BlockSoundEvent(SoundEvents.f_12055_, 0.05f, 2.5f), new ModResources.BlockSoundEvent(SoundEvents.f_12055_, 0.05f, 2.0f)));
        Registries.addBlock("rustic_high_sensitive_trapdoor", () -> new TrapdoorSwitchBlock(-3237877024765771776L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(0.0, 15.6, 0.0, 16.0, 16.0, 16.0), Auxiliaries.getPixeledAABB(0.0, 2.0, 0.0, 16.0, 16.0, 0.1), new ModResources.BlockSoundEvent(SoundEvents.f_12055_, 0.05f, 2.5f), new ModResources.BlockSoundEvent(SoundEvents.f_12055_, 0.05f, 2.0f)));
        Registries.addBlock("rustic_fallthrough_detector", () -> new TrapdoorSwitchBlock(-3386706918701531136L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(0.0, 12.6, 0.0, 16.0, 13.0, 16.0), Auxiliaries.getPixeledAABB(0.0, 12.6, 0.0, 16.0, 13.0, 16.0), new ModResources.BlockSoundEvent(SoundEvents.f_12055_, 0.05f, 2.5f), null));
        Registries.addBlock("rustic_semaphore", () -> new IndicatorBlock(0x1000000000000000L, detail.indicator_metallic_block_properties(), Auxiliaries.getPixeledAABB(3.0, 4.0, 0.0, 13.0, 11.0, 1.0), null, null));
        Registries.addBlock("glass_rotary_switch", () -> new BistableSwitchBlock(8286623314633293824L, detail.switch_metallic_faint_light_block_properties(), Auxiliaries.getPixeledAABB(5.5, 5.5, 0.0, 10.5, 10.5, 0.5), null));
        Registries.addBlock("glass_touch_switch", () -> new BistableSwitchBlock(8286623314633293824L, detail.switch_metallic_faint_light_block_properties(), Auxiliaries.getPixeledAABB(5.5, 5.5, 0.0, 10.5, 10.5, 0.5), null));
        Registries.addBlock("glass_button", () -> new PulseSwitchBlock(8286623314956255232L, detail.switch_metallic_faint_light_block_properties(), Auxiliaries.getPixeledAABB(5.5, 5.5, 0.0, 10.5, 10.5, 0.5), null));
        Registries.addBlock("glass_small_button", () -> new PulseSwitchBlock(8286623314956255232L, detail.switch_metallic_faint_light_block_properties(), Auxiliaries.getPixeledAABB(5.5, 5.5, 0.0, 10.5, 10.5, 0.5), null));
        Registries.addBlock("glass_touch_button", () -> new PulseSwitchBlock(8286623314956255232L, detail.switch_metallic_faint_light_block_properties(), Auxiliaries.getPixeledAABB(5.5, 5.5, 0.0, 10.5, 10.5, 0.5), null));
        Registries.addBlock("glass_door_contact_mat", () -> new ContactMatBlock(-5692549927906836480L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 0.25, 16.0), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.0f, 1.3f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.0f, 1.2f)));
        Registries.addBlock("glass_contact_mat", () -> new ContactMatBlock(-5692549927915225088L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 0.25, 16.0), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.0f, 1.3f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.0f, 1.2f)));
        Registries.addBlock("glass_day_timer", () -> new DayTimerSwitchBlock(8286623318668214272L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(5.5, 5.5, 0.0, 10.5, 10.5, 0.1), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.0f, 1.3f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.0f, 1.2f)));
        Registries.addBlock("glass_interval_timer", () -> new IntervalTimerSwitchBlock(8214565728925253632L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(5.5, 5.5, 0.0, 10.5, 10.5, 0.1), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.0f, 1.3f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.0f, 1.2f)));
        Registries.addBlock("glass_entity_detector", () -> new EntityDetectorSwitchBlock(8286623331557310464L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(5.5, 5.5, 0.0, 10.5, 10.5, 0.1), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.0f, 1.3f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.0f, 1.2f)));
        Registries.addBlock("glass_linear_entity_detector", () -> new EntityDetectorSwitchBlock(8286623348737179648L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(5.5, 5.5, 0.0, 10.5, 10.5, 0.1), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.0f, 1.3f), new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.0f, 1.2f)));
        Registries.addBlock("glass_vertical_bar_gauge", () -> new GaugeBlock(0x1000000000000000L, detail.gauge_glass_block_properties(), Auxiliaries.getPixeledAABB(7.0, 3.7, 0.0, 10.0, 12.0, 0.4)));
        Registries.addBlock("oldfancy_bistableswitch1", () -> new BistableSwitchBlock(5980780305419599872L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(6.0, 6.5, 0.0, 10.3, 13.5, 4.5), Auxiliaries.getPixeledAABB(6.0, 3.5, 0.0, 10.3, 10.0, 4.5)));
        Registries.addBlock("oldfancy_bistableswitch2", () -> new BistableSwitchBlock(5980780305419599872L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(2.5, 6.0, 0.0, 9.7, 10.0, 4.5), Auxiliaries.getPixeledAABB(4.5, 3.5, 0.0, 9.2, 10.0, 4.5)));
        Registries.addBlock("oldfancy_button", () -> new PulseSwitchBlock(5980833082300694528L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(6.0, 6.0, 0.0, 10.0, 10.0, 1.5), null));
        Registries.addBlock("oldfancy_spring_reset_chain", () -> new PulseSwitchBlock(5980780305742561280L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(6.5, 4.8, 0.0, 9.5, 13.0, 4.0), Auxiliaries.getPixeledAABB(6.5, 3.8, 0.0, 9.5, 12.0, 4.0)));
        Registries.addBlock("oldfancy_small_button", () -> new PulseSwitchBlock(5980833082300694528L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(7.0, 7.0, 0.0, 9.0, 9.0, 1.5), null));
        Registries.addBlock("yellow_power_plant", () -> new PowerPlantBlock(-7998392937128919040L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(5.0, 0.0, 5.0, 11.0, 9.0, 11.0), null, new ModResources.BlockSoundEvent(SoundEvents.f_11988_, 0.09f, 3.6f), new ModResources.BlockSoundEvent(SoundEvents.f_11988_, 0.04f, 3.0f)));
        Registries.addBlock("red_power_plant", () -> new PowerPlantBlock(-7998392937128919040L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(5.0, 0.0, 5.0, 11.0, 9.0, 11.0), null, new ModResources.BlockSoundEvent(SoundEvents.f_11988_, 0.09f, 3.6f), new ModResources.BlockSoundEvent(SoundEvents.f_11988_, 0.04f, 3.0f)));
        Registries.addBlock("light_switch", () -> new BistableSwitchBlock(5980780305419599872L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(7.0, 6.0, 0.0, 9.0, 10.0, 1.5), null));
        Registries.addBlock("arrow_target", () -> new PulseSwitchBlock(5980833082283917312L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(5.0, 5.0, 0.0, 11.0, 11.0, 1.0), null));
        Registries.addBlock("valve_wheel_switch", () -> new BistableSwitchBlock(5980780305419599872L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(4.0, 4.0, 0.0, 12.0, 12.0, 3.5), null));
        Registries.addBlock("elevator_button", () -> new ElevatorSwitchBlock(5980833082300694528L, detail.switch_metallic_faint_light_block_properties(), Auxiliaries.getPixeledAABB(4.0, 4.0, 0.0, 12.0, 12.0, 1.0), null));
        Registries.addBlock("door_sensor_switch", () -> new DoorSensorSwitchBlock(-3386706919242596352L, detail.switch_metallic_block_properties(), Auxiliaries.getPixeledAABB(5.0, 0.0, 0.0, 11.0, 1.0, 1.5), null, new ModResources.BlockSoundEvent(SoundEvents.f_12088_, 0.05f, 2.5f), null));
        Registries.addBlock("sensitive_glass_block", () -> new SensitiveGlassBlock(detail.light_emitting_sensitive_glass_block_properties()));
        Registries.addBlock("stained_sensitiveglass", () -> new SensitiveGlassBlock(detail.colored_sensitive_glass_block_properties()));
        Registries.addBlockEntityType("te_gauge", AbstractGaugeBlock.GaugeTileEntity::new, AbstractGaugeBlock.class);
        Registries.addBlockEntityType("te_switch", SwitchBlock.SwitchTileEntity::new, SwitchBlock.class);
        Registries.addBlockEntityType("te_contact_switch", ContactSwitchBlock.ContactSwitchTileEntity::new, ContactSwitchBlock.class);
        Registries.addBlockEntityType("te_detector_switch", EntityDetectorSwitchBlock.DetectorSwitchTileEntity::new, EntityDetectorSwitchBlock.class);
        Registries.addBlockEntityType("te_envsensor_switch", EnvironmentalSensorSwitchBlock.EnvironmentalSensorSwitchTileEntity::new, EnvironmentalSensorSwitchBlock.class);
        Registries.addBlockEntityType("te_daytimer_switch", DayTimerSwitchBlock.DayTimerSwitchTileEntity::new, DayTimerSwitchBlock.class);
        Registries.addBlockEntityType("te_intervaltimer_switch", IntervalTimerSwitchBlock.IntervalTimerSwitchTileEntity::new, IntervalTimerSwitchBlock.class);
        Registries.addBlockEntityType("te_comparator_switch", ComparatorSwitchBlock.ComparatorSwitchTileEntity::new, ComparatorSwitchBlock.class);
        Registries.addBlockEntityType("te_observer_switch", ObserverSwitchBlock.ObserverSwitchTileEntity::new, ObserverSwitchBlock.class);
        Registries.addBlockEntityType("te_doorsensor_switch", DoorSensorSwitchBlock.DoorSensorSwitchTileEntity::new, DoorSensorSwitchBlock.class);
    }

    public static void initItems() {
        Registries.addItem("switchlink_pearl", () -> new SwitchLinkPearlItem(detail.default_item_properties()));
    }

    public static Block getBlock(String name) {
        return Registries.getBlock(name);
    }

    public static Item getItem(String name) {
        return Registries.getItem(name);
    }

    public static TagKey<Block> getBlockTagKey(String name) {
        return Registries.getBlockTagKey(name);
    }

    public static TagKey<Item> getItemTagKey(String name) {
        return Registries.getItemTagKey(name);
    }

    public static BlockEntityType<?> getBlockEntityTypeOfBlock(String block_name) {
        return Registries.getBlockEntityTypeOfBlock(block_name);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void processContentClientSide(FMLClientSetupEvent event) {
        for (Block block : Registries.getRegisteredBlocks()) {
            if (!(block instanceof RsBlock)) continue;
            switch (((RsBlock)block).getRenderTypeHint()) {
                case CUTOUT: {
                    ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110463_());
                    break;
                }
                case CUTOUT_MIPPED: {
                    ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110457_());
                    break;
                }
                case TRANSLUCENT: {
                    ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110466_());
                    break;
                }
            }
        }
    }

    private static class detail {
        public static String MODID = "";

        private detail() {
        }

        public static final BlockBehaviour.Properties gauge_metallic_block_properties() {
            return BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76404_).m_60913_(0.5f, 15.0f).m_60918_(SoundType.f_56743_).m_60910_().m_60922_((s, w, p, e) -> false);
        }

        public static final BlockBehaviour.Properties gauge_glass_block_properties() {
            return BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76404_).m_60913_(0.5f, 15.0f).m_60918_(SoundType.f_56743_).m_60955_().m_60922_((s, w, p, e) -> false);
        }

        public static final BlockBehaviour.Properties indicator_metallic_block_properties() {
            return BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76404_).m_60913_(0.5f, 15.0f).m_60918_(SoundType.f_56743_).m_60953_(state -> 3).m_60955_().m_60922_((s, w, p, e) -> false);
        }

        public static final BlockBehaviour.Properties indicator_glass_block_properties() {
            return BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76404_).m_60913_(0.5f, 15.0f).m_60918_(SoundType.f_56743_).m_60953_(state -> 3).m_60955_().m_60922_((s, w, p, e) -> false);
        }

        public static final BlockBehaviour.Properties alarm_lamp_block_properties() {
            return BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76404_).m_60913_(0.5f, 15.0f).m_60918_(SoundType.f_56743_).m_60955_().m_60953_(state -> (Boolean)state.m_61143_((Property)IndicatorBlock.POWERED) != false ? 12 : 2).m_60922_((s, w, p, e) -> false);
        }

        public static final BlockBehaviour.Properties colored_sensitive_glass_block_properties() {
            return BlockBehaviour.Properties.m_60944_((Material)Material.f_76312_, (MaterialColor)MaterialColor.f_76404_).m_60913_(0.35f, 15.0f).m_60918_(SoundType.f_56743_).m_60955_().m_60922_((s, w, p, e) -> false);
        }

        public static final BlockBehaviour.Properties light_emitting_sensitive_glass_block_properties() {
            return BlockBehaviour.Properties.m_60944_((Material)Material.f_76312_, (MaterialColor)MaterialColor.f_76404_).m_60913_(0.35f, 15.0f).m_60918_(SoundType.f_56743_).m_60955_().m_60991_((s, w, p) -> true).m_60953_(state -> (Boolean)state.m_61143_((Property)SensitiveGlassBlock.POWERED) != false ? 15 : 0).m_60922_((s, w, p, e) -> false);
        }

        public static final BlockBehaviour.Properties switch_metallic_block_properties() {
            return detail.gauge_metallic_block_properties();
        }

        public static final BlockBehaviour.Properties switch_glass_block_properties() {
            return detail.gauge_glass_block_properties();
        }

        public static final BlockBehaviour.Properties switch_metallic_faint_light_block_properties() {
            return BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76404_).m_60913_(0.5f, 15.0f).m_60918_(SoundType.f_56743_).m_60953_(state -> 5);
        }

        private static Item.Properties default_item_properties() {
            return new Item.Properties().m_41491_(Registries.getCreativeModeTab());
        }
    }
}

