/*
 * Decompiled with CFR 0.152.
 */
package frankv.jmi.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class FileManager<T> {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Class<T> classOfT;
    private final File file;

    public FileManager(String filePath, Class<T> classOfT) {
        this.file = new File(System.getProperty("user.dir") + filePath);
        this.classOfT = classOfT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T read() {
        try (FileReader fileReader = new FileReader(this.file);){
            Object object = this.gson.fromJson((Reader)fileReader, this.classOfT);
            return (T)object;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void write(T object) {
        try (FileWriter fileWriter = new FileWriter(this.file);){
            this.gson.toJson(object, (Appendable)fileWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public File getFile() {
        return this.file;
    }
}

