/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.registry;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.roguelogix.phosphophyllite.config.ConfigManager;
import net.roguelogix.phosphophyllite.registry.ClientOnly;
import net.roguelogix.phosphophyllite.registry.ContainerSupplier;
import net.roguelogix.phosphophyllite.registry.CreativeTabBlock;
import net.roguelogix.phosphophyllite.registry.IPhosphophylliteOre;
import net.roguelogix.phosphophyllite.registry.IgnoreRegistration;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.registry.PhosphophylliteFluid;
import net.roguelogix.phosphophyllite.registry.RegisterBlock;
import net.roguelogix.phosphophyllite.registry.RegisterConfig;
import net.roguelogix.phosphophyllite.registry.RegisterContainer;
import net.roguelogix.phosphophyllite.registry.RegisterFluid;
import net.roguelogix.phosphophyllite.registry.RegisterItem;
import net.roguelogix.phosphophyllite.registry.RegisterOre;
import net.roguelogix.phosphophyllite.registry.RegisterTile;
import net.roguelogix.phosphophyllite.registry.SideOnly;
import net.roguelogix.phosphophyllite.threading.Event;
import net.roguelogix.phosphophyllite.threading.WorkQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Registry {
    private static final Logger LOGGER = LogManager.getLogger((String)"Phosphophyllite/Registry");
    private final WorkQueue blockRegistrationQueue = new WorkQueue();
    private RegistryEvent.Register<Block> blockRegistryEvent;
    private final WorkQueue itemRegistrationQueue = new WorkQueue();
    private RegistryEvent.Register<Item> itemRegistryEvent;
    private final CreativeModeTab itemGroup;
    private Item itemGroupItem = Items.f_41905_;
    private final WorkQueue fluidRegistrationQueue = new WorkQueue();
    private RegistryEvent.Register<Fluid> fluidRegistryEvent;
    private final WorkQueue containerRegistrationQueue = new WorkQueue();
    private RegistryEvent.Register<MenuType<?>> containerRegistryEvent;
    private final WorkQueue tileRegistrationQueue = new WorkQueue();
    private RegistryEvent.Register<BlockEntityType<?>> tileRegistryEvent;
    private final Map<Class<?>, LinkedList<Block>> tileBlocks = new HashMap();
    private final WorkQueue clientSetupQueue = new WorkQueue();
    private FMLClientSetupEvent clientSetupEvent;
    private final WorkQueue commonSetupQueue = new WorkQueue();
    private FMLCommonSetupEvent commonSetupEvent;
    private final ArrayList<Runnable> biomeLoadingEventHandlers = new ArrayList();
    private BiomeLoadingEvent biomeLoadingEvent;
    private final Map<String, AnnotationHandler> annotationMap = new HashMap<String, AnnotationHandler>();
    private static final Field itemCreativeModeTabField;
    private static final Field tileProducerTYPEField;

    public Registry() {
        this.annotationMap.put(RegisterBlock.class.getName(), this::registerBlockAnnotation);
        this.annotationMap.put(RegisterItem.class.getName(), this::registerItemAnnotation);
        this.annotationMap.put(RegisterFluid.class.getName(), this::registerFluidAnnotation);
        this.annotationMap.put(RegisterContainer.class.getName(), this::registerContainerAnnotation);
        this.annotationMap.put(RegisterTile.class.getName(), this::registerTileAnnotation);
        this.annotationMap.put(RegisterOre.class.getName(), this::registerWorldGenAnnotation);
        String callerClass = new Exception().getStackTrace()[1].getClassName();
        String callerPackage = callerClass.substring(0, callerClass.lastIndexOf("."));
        String modNamespace = callerPackage.substring(callerPackage.lastIndexOf(".") + 1);
        ModFileScanData modFileScanData = FMLLoader.getLoadingModList().getModFileById(modNamespace).getFile().getScanResult();
        this.itemGroup = new CreativeModeTab(modNamespace){

            @Nonnull
            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)Registry.this.itemGroupItem);
            }

            public void m_6151_(@Nonnull NonNullList<ItemStack> items) {
                super.m_6151_(items);
                items.sort((o1, o2) -> o1.m_41611_().getString().compareToIgnoreCase(o2.m_41611_().getString()));
            }
        };
        Registry.handleAnnotationType(modFileScanData, callerPackage, modNamespace, RegisterConfig.class.getName(), this::registerConfigAnnotation);
        Registry.handleAnnotationType(modFileScanData, callerPackage, modNamespace, OnModLoad.class.getName(), this::onModLoadAnnotation);
        for (ModFileScanData.AnnotationData annotation : modFileScanData.getAnnotations()) {
            String className;
            AnnotationHandler handler = this.annotationMap.get(annotation.annotationType().getClassName());
            if (handler == null || !(className = annotation.clazz().getClassName()).startsWith(callerPackage)) continue;
            try {
                SideOnly sideOnly;
                Class<?> clazz = Registry.class.getClassLoader().loadClass(className);
                if (clazz.isAnnotationPresent(ClientOnly.class) && !FMLEnvironment.dist.isClient() || clazz.isAnnotationPresent(SideOnly.class) && (sideOnly = clazz.getAnnotation(SideOnly.class)).value() != FMLEnvironment.dist) continue;
                handler.run(modNamespace, clazz, annotation.memberName());
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable) {}
        }
        IEventBus ModBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModBus.addGenericListener(Block.class, this::blockRegistration);
        ModBus.addGenericListener(Item.class, this::itemRegistration);
        ModBus.addGenericListener(Fluid.class, this::fluidRegistration);
        ModBus.addGenericListener(MenuType.class, this::containerRegistration);
        ModBus.addGenericListener(BlockEntityType.class, this::tileEntityRegistration);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::biomeLoadingEventHandler);
        ModBus.addListener(this::commonSetupEventHandler);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ModBus.addListener(this::clientSetupEventHandler);
        }
    }

    private static void handleAnnotationType(ModFileScanData modFileScanData, String callerPackage, String modNamespace, String name, AnnotationHandler handler) {
        for (ModFileScanData.AnnotationData annotation : modFileScanData.getAnnotations()) {
            String className;
            if (!annotation.annotationType().getClassName().equals(name) || !(className = annotation.clazz().getClassName()).startsWith(callerPackage)) continue;
            try {
                SideOnly sideOnly;
                Class<?> clazz = Registry.class.getClassLoader().loadClass(className);
                if (clazz.isAnnotationPresent(ClientOnly.class) && !FMLEnvironment.dist.isClient() || clazz.isAnnotationPresent(SideOnly.class) && (sideOnly = clazz.getAnnotation(SideOnly.class)).value() != FMLEnvironment.dist) continue;
                handler.run(modNamespace, clazz, annotation.memberName());
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable) {}
        }
    }

    private void blockRegistration(RegistryEvent.Register<Block> event) {
        this.blockRegistryEvent = event;
        this.blockRegistrationQueue.runAll();
        this.blockRegistryEvent = null;
    }

    private void itemRegistration(RegistryEvent.Register<Item> event) {
        this.itemRegistryEvent = event;
        this.itemRegistrationQueue.runAll();
        this.itemRegistryEvent = null;
    }

    private void fluidRegistration(RegistryEvent.Register<Fluid> event) {
        this.fluidRegistryEvent = event;
        this.fluidRegistrationQueue.runAll();
        this.fluidRegistryEvent = null;
    }

    private void containerRegistration(RegistryEvent.Register<MenuType<?>> containerTypeRegistryEvent) {
        this.containerRegistryEvent = containerTypeRegistryEvent;
        this.containerRegistrationQueue.runAll();
        this.containerRegistryEvent = null;
    }

    private void tileEntityRegistration(RegistryEvent.Register<BlockEntityType<?>> tileEntityTypeRegister) {
        this.tileRegistryEvent = tileEntityTypeRegister;
        this.tileRegistrationQueue.runAll();
        this.tileRegistryEvent = null;
    }

    private void clientSetupEventHandler(FMLClientSetupEvent event) {
        this.clientSetupEvent = event;
        this.clientSetupQueue.runAll();
        this.clientSetupEvent = null;
    }

    private void commonSetupEventHandler(FMLCommonSetupEvent event) {
        this.commonSetupEvent = event;
        this.commonSetupQueue.runAll();
        this.commonSetupEvent = null;
    }

    private void biomeLoadingEventHandler(BiomeLoadingEvent event) {
        this.biomeLoadingEvent = event;
        this.biomeLoadingEventHandlers.forEach(Runnable::run);
        this.biomeLoadingEvent = null;
    }

    private void registerBlockAnnotation(String modNamespace, Class<?> blockClazz, String memberName) {
        if (blockClazz.isAnnotationPresent(IgnoreRegistration.class)) {
            return;
        }
        this.blockRegistrationQueue.enqueue(() -> {
            RegisterBlock annotation;
            Block block;
            try {
                Field field = blockClazz.getDeclaredField(memberName);
                if (field.isAnnotationPresent(IgnoreRegistration.class)) {
                    return;
                }
                field.setAccessible(true);
                block = (Block)field.get(null);
                annotation = field.getAnnotation(RegisterBlock.class);
                if (!Modifier.isFinal(field.getModifiers())) {
                    LOGGER.warn("Non-final block instance variable " + memberName + " in " + blockClazz.getSimpleName());
                }
            }
            catch (NoSuchFieldException e) {
                LOGGER.error("Unable to find block field for block " + memberName + " in " + blockClazz.getSimpleName());
                return;
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Unable to access block field for block " + memberName + " in " + blockClazz.getSimpleName());
                return;
            }
            if (block == null) {
                LOGGER.warn("Null block instance variable " + memberName + " in " + blockClazz.getSimpleName());
                return;
            }
            String modid = annotation.modid();
            if (modid.equals("")) {
                modid = modNamespace;
            }
            String name = annotation.name();
            if (modid.equals("")) {
                LOGGER.error("Unable to register block without a name from class " + blockClazz.getSimpleName());
                return;
            }
            if (!Block.class.isAssignableFrom(blockClazz)) {
                LOGGER.error("Attempt to register block from class not extended from Block. " + blockClazz.getSimpleName());
                return;
            }
            String registryName = modid + ":" + name;
            if (annotation.tileEntityClass() != BlockEntity.class) {
                this.tileBlocks.computeIfAbsent(annotation.tileEntityClass(), k -> new LinkedList()).add(block);
            }
            block.setRegistryName(registryName);
            this.blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)block);
            if (FMLEnvironment.dist.isClient()) {
                this.clientSetupQueue.enqueue(() -> {
                    RenderType renderType = null;
                    for (Method declaredMethod : blockClazz.getDeclaredMethods()) {
                        if (!declaredMethod.isAnnotationPresent(RegisterBlock.RenderLayer.class)) continue;
                        if (Modifier.isStatic(declaredMethod.getModifiers())) {
                            LOGGER.error("Cannot call static render layer method " + declaredMethod.getName() + " in " + blockClazz.getSimpleName());
                            continue;
                        }
                        if (!RenderType.class.isAssignableFrom(declaredMethod.getReturnType())) {
                            LOGGER.error("RenderLayer annotated method " + declaredMethod.getName() + " in " + blockClazz.getSimpleName() + " does not return RenderType");
                            continue;
                        }
                        if (declaredMethod.getParameterCount() != 0) {
                            LOGGER.error("RenderLayer annotated method " + declaredMethod.getName() + " in " + blockClazz.getSimpleName() + " requires arguments");
                            continue;
                        }
                        if (renderType != null) {
                            LOGGER.error("Duplicate RenderLayer methods in " + blockClazz.getSimpleName());
                            continue;
                        }
                        declaredMethod.setAccessible(true);
                        try {
                            Object obj = declaredMethod.invoke((Object)block, new Object[0]);
                            renderType = (RenderType)obj;
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            e.printStackTrace();
                            continue;
                        }
                        RenderType finalRenderType = renderType;
                        this.clientSetupEvent.enqueueWork(() -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)finalRenderType));
                    }
                }, new Event[0]);
            }
            if (annotation.registerItem()) {
                boolean creativeTabBlock = blockClazz.isAnnotationPresent(CreativeTabBlock.class);
                this.itemRegistrationQueue.enqueue(() -> {
                    Item item = (Item)new BlockItem(block, new Item.Properties().m_41491_(annotation.creativeTab() ? this.itemGroup : null)).setRegistryName(registryName);
                    this.itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)item);
                    if (creativeTabBlock) {
                        this.itemGroupItem = item;
                    }
                }, new Event[0]);
            }
        }, new Event[0]);
    }

    private void registerItemAnnotation(String modNamespace, Class<?> itemClazz, String memberName) {
        if (itemClazz.isAnnotationPresent(IgnoreRegistration.class)) {
            return;
        }
        this.itemRegistrationQueue.enqueue(() -> {
            RegisterItem annotation;
            Item item;
            try {
                Field field = itemClazz.getDeclaredField(memberName);
                if (field.isAnnotationPresent(IgnoreRegistration.class)) {
                    return;
                }
                field.setAccessible(true);
                item = (Item)field.get(null);
                annotation = field.getAnnotation(RegisterItem.class);
                if (!Modifier.isFinal(field.getModifiers())) {
                    LOGGER.warn("Non-final item instance variable " + memberName + " in " + itemClazz.getSimpleName());
                }
            }
            catch (NoSuchFieldException e) {
                LOGGER.error("Unable to find item field for block " + memberName + " in " + itemClazz.getSimpleName());
                return;
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Unable to access item field for block " + memberName + " in " + itemClazz.getSimpleName());
                return;
            }
            if (item == null) {
                LOGGER.warn("Null item instance variable " + memberName + " in " + itemClazz.getSimpleName());
                return;
            }
            String modid = annotation.modid();
            if (modid.equals("")) {
                modid = modNamespace;
            }
            String name = annotation.name();
            if (modid.equals("")) {
                LOGGER.error("Unable to register item " + memberName + " in " + itemClazz.getSimpleName() + " without a registry name");
                return;
            }
            String registryName = modid + ":" + name;
            if (annotation.creativeTab()) {
                try {
                    itemCreativeModeTabField.set(item, this.itemGroup);
                }
                catch (IllegalAccessException e) {
                    LOGGER.error("Failed to set item category when registering " + registryName);
                    return;
                }
            }
            item.setRegistryName(registryName);
            this.itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)item);
        }, new Event[0]);
    }

    private void registerFluidAnnotation(String modNamespace, Class<?> fluidClazz, String memberName) {
        if (fluidClazz.isAnnotationPresent(IgnoreRegistration.class)) {
            return;
        }
        this.blockRegistrationQueue.enqueue(() -> {
            PhosphophylliteFluid flowingInstance;
            PhosphophylliteFluid stillInstance;
            Constructor constructor;
            assert (fluidClazz.isAnnotationPresent(RegisterFluid.class));
            RegisterFluid annotation = fluidClazz.getAnnotation(RegisterFluid.class);
            String modid = annotation.modid().equals("") ? modNamespace : annotation.modid();
            String name = annotation.name();
            if (modid.equals("")) {
                LOGGER.error("Unable to register fluid without a name");
                return;
            }
            if (!ForgeFlowingFluid.class.isAssignableFrom(fluidClazz)) {
                LOGGER.error("Attempt to register fluid from class not extended from PhosphophylliteFluid");
                return;
            }
            String baseRegistryName = modid + ":" + name;
            PhosphophylliteFluid[] fluids = new PhosphophylliteFluid[2];
            Item[] bucketArray = new Item[1];
            LiquidBlock[] blockArray = new LiquidBlock[1];
            try {
                constructor = fluidClazz.getDeclaredConstructor(ForgeFlowingFluid.Properties.class);
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("Failed to find constructor to create instance of " + fluidClazz.getSimpleName());
                return;
            }
            Supplier<PhosphophylliteFluid> stillSupplier = () -> fluids[0];
            Supplier<PhosphophylliteFluid> flowingSupplier = () -> fluids[1];
            FluidAttributes.Builder attributes = FluidAttributes.builder((ResourceLocation)new ResourceLocation(modid, "fluid/" + name + "_still"), (ResourceLocation)new ResourceLocation(modid, "fluid/" + name + "_flowing"));
            attributes.color(annotation.color());
            ForgeFlowingFluid.Properties properties = new ForgeFlowingFluid.Properties(stillSupplier, flowingSupplier, attributes);
            if (annotation.registerBucket()) {
                properties.bucket(() -> bucketArray[0]);
            }
            properties.block(() -> blockArray[0]);
            try {
                stillInstance = (PhosphophylliteFluid)((Object)((Object)constructor.newInstance(properties)));
                flowingInstance = (PhosphophylliteFluid)((Object)((Object)constructor.newInstance(properties)));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                LOGGER.error("Exception caught when instantiating instance of " + fluidClazz.getSimpleName());
                e.printStackTrace();
                return;
            }
            stillInstance.isSource = true;
            fluids[0] = stillInstance;
            fluids[1] = flowingInstance;
            blockArray[0] = new LiquidBlock((FlowingFluid)stillInstance, BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60910_().m_155956_(100.0f).m_60993_());
            for (Field declaredField : fluidClazz.getDeclaredFields()) {
                if (!declaredField.isAnnotationPresent(RegisterFluid.Instance.class)) continue;
                if (!declaredField.getType().isAssignableFrom(fluidClazz)) {
                    LOGGER.error("Unassignable instance variable " + declaredField.getName() + " in " + fluidClazz.getSimpleName());
                    continue;
                }
                if (!Modifier.isStatic(declaredField.getModifiers())) {
                    LOGGER.error("Cannot set non-static instance variable " + declaredField.getName() + " in " + fluidClazz.getSimpleName());
                    continue;
                }
                declaredField.setAccessible(true);
                try {
                    declaredField.set(null, (Object)stillInstance);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            blockArray[0].setRegistryName(baseRegistryName);
            this.blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)blockArray[0]);
            this.fluidRegistrationQueue.enqueue(() -> {
                PhosphophylliteFluid still = fluids[0];
                PhosphophylliteFluid flowing = fluids[1];
                if (still == null || flowing == null) {
                    return;
                }
                still.setRegistryName(baseRegistryName);
                flowing.setRegistryName(baseRegistryName + "_flowing");
                this.fluidRegistryEvent.getRegistry().register((IForgeRegistryEntry)still);
                this.fluidRegistryEvent.getRegistry().register((IForgeRegistryEntry)flowing);
            }, new Event[0]);
            if (annotation.registerBucket()) {
                this.itemRegistrationQueue.enqueue(() -> {
                    BucketItem bucket = new BucketItem(() -> fluids[0], new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1).m_41491_(this.itemGroup));
                    bucketArray[0] = bucket;
                    bucket.setRegistryName(baseRegistryName + "_bucket");
                    this.itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)bucket);
                }, new Event[0]);
            }
        }, new Event[0]);
    }

    private void registerContainerAnnotation(String modNamespace, Class<?> containerClazz, String memberName) {
        if (containerClazz.isAnnotationPresent(IgnoreRegistration.class)) {
            return;
        }
        assert (containerClazz.isAnnotationPresent(RegisterContainer.class));
        RegisterContainer annotation = containerClazz.getAnnotation(RegisterContainer.class);
        String modid = annotation.modid();
        if (modid.equals("")) {
            modid = modNamespace;
        }
        String name = annotation.name();
        if (modid.equals("")) {
            LOGGER.error("Unable to register container without a name");
            return;
        }
        if (!AbstractContainerMenu.class.isAssignableFrom(containerClazz)) {
            LOGGER.error("Attempt to register container from class not extended from Container");
            return;
        }
        String registryName = modid + ":" + name;
        MenuType[] containerTypeArray = new MenuType[1];
        this.containerRegistrationQueue.enqueue(() -> {
            ContainerSupplier supplier = null;
            for (Field declaredField : containerClazz.getDeclaredFields()) {
                if (!declaredField.isAnnotationPresent(RegisterContainer.Supplier.class)) continue;
                int modifiers = declaredField.getModifiers();
                if (!Modifier.isStatic(modifiers)) {
                    LOGGER.error("Cannot access non-static container supplier " + declaredField.getName() + " in " + containerClazz.getSimpleName());
                    return;
                }
                if (!Modifier.isFinal(modifiers)) {
                    LOGGER.warn("Container supplier " + declaredField.getName() + " not final in" + containerClazz.getSimpleName());
                }
                if (!ContainerSupplier.class.isAssignableFrom(declaredField.getType())) {
                    LOGGER.error("Supplier annotation found on non-ContainerSupplier field " + declaredField.getName() + " in " + containerClazz.getSimpleName());
                    continue;
                }
                if (supplier != null) {
                    LOGGER.error("Duplicate suppliers for container " + containerClazz.getSimpleName());
                    continue;
                }
                declaredField.setAccessible(true);
                try {
                    supplier = (ContainerSupplier)declaredField.get(null);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continue;
                }
                if (supplier != null) continue;
                LOGGER.error("Container supplier field " + declaredField.getName() + " null in " + containerClazz.getSimpleName());
            }
            if (supplier == null) {
                LOGGER.error("No supplier found for container " + containerClazz.getSimpleName());
                return;
            }
            ContainerSupplier finalSupplier = supplier;
            containerTypeArray[0] = IForgeMenuType.create((windowId, playerInventory, data) -> finalSupplier.create(windowId, data.m_130135_(), playerInventory.f_35978_));
            for (Field declaredField : containerClazz.getDeclaredFields()) {
                if (!declaredField.isAnnotationPresent(RegisterContainer.Type.class)) continue;
                if (!declaredField.getType().isAssignableFrom(MenuType.class)) {
                    LOGGER.error("Unassignable type variable " + declaredField.getName() + " in " + containerClazz.getSimpleName());
                    continue;
                }
                if (!Modifier.isStatic(declaredField.getModifiers())) {
                    LOGGER.error("Cannot set non-static type variable " + declaredField.getName() + " in " + containerClazz.getSimpleName());
                    continue;
                }
                declaredField.setAccessible(true);
                try {
                    declaredField.set(null, containerTypeArray[0]);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            MenuType type = containerTypeArray[0];
            if (type == null) {
                return;
            }
            type.setRegistryName(registryName);
            this.containerRegistryEvent.getRegistry().register((IForgeRegistryEntry)type);
        }, new Event[0]);
    }

    private void registerTileAnnotation(String modNamespace, Class<?> declaringClass, String memberName) {
        this.tileRegistrationQueue.enqueue(() -> {
            RegisterTile.Producer producer;
            RegisterTile annotation;
            Field field;
            try {
                field = declaringClass.getDeclaredField(memberName);
                if (!field.isAnnotationPresent(RegisterTile.class)) {
                    LOGGER.error("Schrodinger's annotation on field " + memberName + " in " + declaringClass.getSimpleName());
                    return;
                }
                annotation = field.getAnnotation(RegisterTile.class);
                if (field.isAnnotationPresent(IgnoreRegistration.class)) {
                    return;
                }
                field.setAccessible(true);
                Object producerObject = field.get(null);
                if (producerObject == null) {
                    LOGGER.error("Null supplier for tile field " + memberName + " in " + declaringClass.getSimpleName());
                    return;
                }
                if (producerObject.getClass() != RegisterTile.Producer.class) {
                    LOGGER.error("Attempt to register non-TileProducer BlockEntitySupplier " + memberName + " in " + declaringClass.getSimpleName());
                    return;
                }
                producer = (RegisterTile.Producer)producerObject;
            }
            catch (NoSuchFieldException e) {
                LOGGER.error("Unable to find supplier field for tile " + memberName + " in " + declaringClass.getSimpleName());
                return;
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Unable to access supplier field for tile " + memberName + " in " + declaringClass.getSimpleName());
                return;
            }
            String modid = annotation.modid();
            if (modid.equals("")) {
                modid = modNamespace;
            }
            String name = annotation.value();
            if (modid.equals("")) {
                LOGGER.error("Unable to register tile without a name from " + memberName + " in " + declaringClass.getSimpleName());
                return;
            }
            String registryName = modid + ":" + name;
            Class tileClass = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            LinkedList<Block> blocks = this.tileBlocks.remove(tileClass);
            if (blocks == null) {
                return;
            }
            BlockEntityType type = BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)producer, (Block[])blocks.toArray(new Block[blocks.size()])).m_58966_(null);
            type.setRegistryName(registryName);
            try {
                tileProducerTYPEField.set(producer, type);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Tile entity type unable to be saved for " + memberName + " in " + declaringClass.getSimpleName());
            }
            this.tileRegistryEvent.getRegistry().register((IForgeRegistryEntry)type);
        }, new Event[0]);
    }

    private void registerWorldGenAnnotation(String modNamespace, Class<?> oreClazz, String memberName) {
        this.commonSetupQueue.enqueue(() -> {
            Block oreInstance;
            try {
                Field field = oreClazz.getDeclaredField(memberName);
                if (field.isAnnotationPresent(IgnoreRegistration.class)) {
                    return;
                }
                field.setAccessible(true);
                oreInstance = (Block)field.get(null);
            }
            catch (NoSuchFieldException e) {
                LOGGER.error("Unable to find block field for block " + memberName);
                return;
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Unable to access block field for block " + memberName);
                return;
            }
            ResourceLocation resourceLocation = oreInstance.getRegistryName();
            assert (resourceLocation != null);
            if (!(oreInstance instanceof IPhosphophylliteOre)) {
                LOGGER.error("Attempt to register non-IPhosphophylliteOre block for world generation");
                return;
            }
            IPhosphophylliteOre oreInfo = (IPhosphophylliteOre)oreInstance;
            ArrayList<OreConfiguration.TargetBlockState> targetBlockStates = new ArrayList<OreConfiguration.TargetBlockState>();
            BlockState blockstate = oreInstance.m_49966_();
            if (oreInfo.isNetherOre()) {
                targetBlockStates.add(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195075_, (BlockState)blockstate));
            } else {
                Block deepslateVariant;
                Block stoneVariant = oreInfo.stoneVariant();
                if (stoneVariant != null) {
                    targetBlockStates.add(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)stoneVariant.m_49966_()));
                }
                if ((deepslateVariant = oreInfo.deepslateVariant()) != null) {
                    targetBlockStates.add(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)deepslateVariant.m_49966_()));
                }
            }
            OreConfiguration oreConfiguration = new OreConfiguration((List)ImmutableList.copyOf(targetBlockStates), oreInfo.size());
            ConfiguredFeature configuredFeature = new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)oreConfiguration);
            HashSet<String> spawnBiomes = new HashSet<String>(Arrays.asList(oreInfo.spawnBiomes()));
            this.commonSetupEvent.enqueueWork(() -> (ConfiguredFeature)net.minecraft.core.Registry.m_122965_((net.minecraft.core.Registry)BuiltinRegistries.f_123861_, (ResourceLocation)resourceLocation, (Object)configuredFeature));
            ArrayList<BlockPredicateFilter> placementModifiers = new ArrayList<BlockPredicateFilter>();
            if (!oreInfo.doSpawn()) {
                placementModifiers.add(BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_190435_())));
            }
            VerticalAnchor rangeLower = oreInfo.minLevel() == Integer.MIN_VALUE ? VerticalAnchor.f_158915_ : VerticalAnchor.m_158922_((int)oreInfo.minLevel());
            placementModifiers.addAll(OrePlacements.m_195346_((PlacementModifier)CountPlacement.m_191628_((int)oreInfo.count()), (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)rangeLower, (VerticalAnchor)VerticalAnchor.m_158922_((int)oreInfo.maxLevel()))));
            PlacedFeature placedFeature = new PlacedFeature((Holder)new Holder.Direct((Object)configuredFeature), (List)ImmutableList.copyOf(placementModifiers));
            Holder.Direct placedFeatureHolder = new Holder.Direct((Object)placedFeature);
            this.commonSetupEvent.enqueueWork(() -> (PlacedFeature)net.minecraft.core.Registry.m_122965_((net.minecraft.core.Registry)BuiltinRegistries.f_194653_, (ResourceLocation)resourceLocation, (Object)placedFeature));
            this.biomeLoadingEventHandlers.add(() -> {
                if (this.biomeLoadingEvent.getCategory() == Biome.BiomeCategory.NETHER != oreInfo.isNetherOre()) {
                    return;
                }
                if (spawnBiomes.size() > 0 && !spawnBiomes.contains(Objects.requireNonNull(this.biomeLoadingEvent.getName()).toString())) {
                    return;
                }
                this.biomeLoadingEvent.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_ORES).add(placedFeatureHolder);
            });
        }, new Event[0]);
    }

    private void registerConfigAnnotation(String modNamespace, Class<?> configClazz, String memberName) {
        try {
            Field field = configClazz.getDeclaredField(memberName);
            if (field.isAnnotationPresent(IgnoreRegistration.class)) {
                return;
            }
            ConfigManager.registerConfig(field, modNamespace);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private void onModLoadAnnotation(String modNamespace, Class<?> modLoadClazz, String memberName) {
        try {
            Method method = modLoadClazz.getDeclaredMethod(memberName.substring(0, memberName.indexOf(40)), new Class[0]);
            if (method.isAnnotationPresent(IgnoreRegistration.class)) {
                return;
            }
            if (!Modifier.isStatic(method.getModifiers())) {
                LOGGER.error("Cannot call non-static @OnModLoad method " + method.getName() + " in " + modLoadClazz.getSimpleName());
                return;
            }
            if (method.getParameterCount() != 0) {
                LOGGER.error("Cannot call @OnModLoad method with parameters " + method.getName() + " in " + modLoadClazz.getSimpleName());
                return;
            }
            method.setAccessible(true);
            method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            LOGGER.warn(modLoadClazz.getName());
            e.printStackTrace();
        }
    }

    static {
        Field itemField = null;
        for (Field declaredField : Item.class.getDeclaredFields()) {
            if (!declaredField.getType().equals(CreativeModeTab.class)) continue;
            itemField = declaredField;
        }
        if (itemField == null) {
            throw new IllegalStateException("Unable to find category field in Item.class");
        }
        itemField.setAccessible(true);
        itemCreativeModeTabField = itemField;
        try {
            tileProducerTYPEField = RegisterTile.Producer.class.getDeclaredField("TYPE");
            tileProducerTYPEField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    private static interface AnnotationHandler {
        public void run(String var1, Class<?> var2, String var3);
    }
}

