/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.roguelogix.phosphophyllite.parsers.Element;
import net.roguelogix.phosphophyllite.util.MethodsReturnNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ROBN {
    @Nullable
    public static Element parseROBN(ArrayList<Byte> robn) {
        try {
            Object robnObject = net.roguelogix.phosphophyllite.robn.ROBN.fromROBN(robn);
            if (robnObject instanceof Map) {
                Map map = (Map)robnObject;
                return ROBN.parseROBNMap(map);
            }
            return null;
        }
        catch (ClassCastException | IllegalArgumentException ignored) {
            return null;
        }
    }

    private static Element parseROBNMap(Map<String, Object> map) {
        Element[] val;
        Element.Type type = Element.Type.valueOf((String)map.get("type"));
        String name = (String)map.get("name");
        switch (type) {
            case String: 
            case Number: 
            case Boolean: {
                val = map.get("value");
                if (val instanceof String) break;
                throw new IllegalArgumentException();
            }
            case Array: 
            case Section: {
                int length = (Integer)map.get("length");
                Element[] array = new Element[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = ROBN.parseROBNMap((Map)map.get(Integer.toString(i)));
                }
                val = array;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + type);
            }
        }
        return new Element(type, null, name, val);
    }

    @Nullable
    public static ArrayList<Byte> parseElement(Element element) {
        try {
            return net.roguelogix.phosphophyllite.robn.ROBN.toROBN(ROBN.parseElementInternal(element));
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    private static HashMap<String, Object> parseElementInternal(Element element) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", element.type.toString());
        if (element.name != null) {
            map.put("name", element.name);
        }
        switch (element.type) {
            case String: 
            case Number: 
            case Boolean: {
                map.put("value", element.asString());
                break;
            }
            case Array: 
            case Section: {
                Element[] array = element.asArray();
                map.put("length", array.length);
                for (int i = 0; i < array.length; ++i) {
                    map.put(Integer.toString(i), ROBN.parseElementInternal(array[i]));
                }
                break;
            }
        }
        return map;
    }
}

