/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.multiblock;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.roguelogix.phosphophyllite.Phosphophyllite;
import net.roguelogix.phosphophyllite.debug.IDebuggable;
import net.roguelogix.phosphophyllite.modular.api.TileModule;
import net.roguelogix.phosphophyllite.multiblock.IAssemblyAttemptedTile;
import net.roguelogix.phosphophyllite.multiblock.IMultiblockTile;
import net.roguelogix.phosphophyllite.multiblock.IOnAssemblyTile;
import net.roguelogix.phosphophyllite.multiblock.IOnDisassemblyTile;
import net.roguelogix.phosphophyllite.multiblock.ITickableMultiblockTile;
import net.roguelogix.phosphophyllite.multiblock.MultiblockTileModule;
import net.roguelogix.phosphophyllite.multiblock.ValidationError;
import net.roguelogix.phosphophyllite.multiblock.Validator;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector2i;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3i;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3ic;
import net.roguelogix.phosphophyllite.threading.Event;
import net.roguelogix.phosphophyllite.threading.Queues;
import net.roguelogix.phosphophyllite.util.AStarList;
import net.roguelogix.phosphophyllite.util.ModuleMap;
import net.roguelogix.phosphophyllite.util.Util;

public class MultiblockController<TileType extends BlockEntity, ControllerType extends MultiblockController<TileType, ControllerType>>
implements IDebuggable {
    private MultiblockController<?, ?> mergedInto = null;
    protected final Level world;
    private boolean hasSaveDelegate = false;
    private boolean isMergingControllers = false;
    protected final ModuleMap<MultiblockTileModule<TileType, ControllerType>, TileType> blocks = new ModuleMap((TileModule[])new MultiblockTileModule[0]);
    protected final Set<ITickableMultiblockTile> toTick = new LinkedHashSet<ITickableMultiblockTile>();
    protected final Set<IAssemblyAttemptedTile> assemblyAttemptedTiles = new LinkedHashSet<IAssemblyAttemptedTile>();
    protected final Set<IOnAssemblyTile> onAssemblyTiles = new LinkedHashSet<IOnAssemblyTile>();
    protected final Set<IOnDisassemblyTile> onDisassemblyTiles = new LinkedHashSet<IOnDisassemblyTile>();
    private boolean updateExtremes = true;
    private long updateAssemblyAtTick = Long.MAX_VALUE;
    private long checkForDetachmentsAtTick = Long.MAX_VALUE;
    protected final Set<MultiblockController<?, ?>> controllersToMerge = new LinkedHashSet();
    protected final List<BlockPos> removedBlocks = new LinkedList<BlockPos>();
    private final Vector3i minCoord = new Vector3i();
    private final Vector3i maxCoord = new Vector3i();
    private final Vector3i minExtremeBlocks = new Vector3i();
    private final Vector3i maxExtremeBlocks = new Vector3i();
    protected final boolean pauseOnUnload;
    protected AssemblyState state = AssemblyState.DISASSEMBLED;
    private boolean shouldUpdateNBT = false;
    private CompoundTag cachedNBT = null;
    protected final Validator<IMultiblockTile<?, ?>> tileTypeValidator;
    private Validator<ControllerType> assemblyValidator = c -> true;
    protected boolean isUpdatingState = false;
    protected ValidationError lastValidationError = null;
    long lastTick = -1L;
    private final Long2ObjectLinkedOpenHashMap<BlockState> newStates = new Long2ObjectLinkedOpenHashMap();

    public MultiblockController(@Nonnull Level world, @Nonnull Validator<IMultiblockTile<?, ?>> tileTypeValidator, boolean pauseOnUnload) {
        this.tileTypeValidator = tileTypeValidator;
        this.world = world;
        Phosphophyllite.addController(this);
        this.pauseOnUnload = pauseOnUnload;
    }

    ControllerType self() {
        return (ControllerType)this;
    }

    public Level getWorld() {
        return this.world;
    }

    public Vector3ic minCoord() {
        return this.minCoord;
    }

    public Vector3ic maxCoord() {
        return this.maxCoord;
    }

    @Nullable
    public TileType getTile(Vector3i position) {
        return this.blocks.getTile(position);
    }

    @Nullable
    public TileType getTile(BlockPos position) {
        return this.blocks.getTile(position);
    }

    public boolean containsTile(TileType tile) {
        return this.blocks.containsTile(tile);
    }

    private void updateMinMaxCoordinates() {
        if (this.blocks.isEmpty() || !this.updateExtremes) {
            return;
        }
        this.updateExtremes = false;
        this.minCoord.set(Integer.MAX_VALUE);
        this.maxCoord.set(Integer.MIN_VALUE);
        this.blocks.forEachPos(pos -> {
            if (pos.m_123341_() < this.minCoord.x) {
                this.minCoord.x = pos.m_123341_();
                this.minExtremeBlocks.x = 1;
            } else if (pos.m_123341_() == this.minCoord.x) {
                ++this.minExtremeBlocks.x;
            }
            if (pos.m_123342_() < this.minCoord.y) {
                this.minCoord.y = pos.m_123342_();
                this.minExtremeBlocks.y = 1;
            } else if (pos.m_123342_() == this.minCoord.y) {
                ++this.minExtremeBlocks.y;
            }
            if (pos.m_123343_() < this.minCoord.z) {
                this.minCoord.z = pos.m_123343_();
                this.minExtremeBlocks.z = 1;
            } else if (pos.m_123343_() == this.minCoord.z) {
                ++this.minExtremeBlocks.z;
            }
            if (pos.m_123341_() > this.maxCoord.x) {
                this.maxCoord.x = pos.m_123341_();
                this.maxExtremeBlocks.x = 1;
            } else if (pos.m_123341_() == this.maxCoord.x) {
                ++this.maxExtremeBlocks.x;
            }
            if (pos.m_123342_() > this.maxCoord.y) {
                this.maxCoord.y = pos.m_123342_();
                this.maxExtremeBlocks.y = 1;
            } else if (pos.m_123342_() == this.maxCoord.y) {
                ++this.maxExtremeBlocks.y;
            }
            if (pos.m_123343_() > this.maxCoord.z) {
                this.maxCoord.z = pos.m_123343_();
                this.maxExtremeBlocks.z = 1;
            } else if (pos.m_123343_() == this.maxCoord.z) {
                ++this.maxExtremeBlocks.z;
            }
        });
    }

    final void attemptAttach(@Nonnull MultiblockTileModule<?, ?> toAttachGeneric) {
        if (!this.tileTypeValidator.validate((IMultiblockTile)toAttachGeneric.iface)) {
            return;
        }
        if (this.isUpdatingState) {
            throw new IllegalStateException("Attempt to add block while updating multiblock state");
        }
        MultiblockTileModule<?, ?> toAttachModule = toAttachGeneric;
        BlockEntity toAttachTile = (BlockEntity)toAttachModule.iface;
        if (toAttachModule.controller != null && toAttachModule.controller != this) {
            if (((MultiblockController)toAttachModule.controller).blocks.size() > this.blocks.size()) {
                ((MultiblockController)toAttachModule.controller).controllersToMerge.add((MultiblockController<?, ?>)this.self());
            } else {
                this.controllersToMerge.add((MultiblockController<?, ?>)toAttachModule.controller);
            }
            return;
        }
        if (toAttachModule.controller == this) {
            return;
        }
        if (!this.blocks.addModule(toAttachModule)) {
            toAttachModule.controller = this.self();
            return;
        }
        BlockPos toAttachPos = toAttachTile.m_58899_();
        if (toAttachPos.m_123341_() < this.minCoord.x) {
            this.minCoord.x = toAttachPos.m_123341_();
            this.minExtremeBlocks.x = 1;
        } else if (toAttachPos.m_123341_() == this.minCoord.x) {
            ++this.minExtremeBlocks.x;
        }
        if (toAttachPos.m_123342_() < this.minCoord.y) {
            this.minCoord.y = toAttachPos.m_123342_();
            this.minExtremeBlocks.y = 1;
        } else if (toAttachPos.m_123342_() == this.minCoord.y) {
            ++this.minExtremeBlocks.y;
        }
        if (toAttachPos.m_123343_() < this.minCoord.z) {
            this.minCoord.z = toAttachPos.m_123343_();
            this.minExtremeBlocks.z = 1;
        } else if (toAttachPos.m_123343_() == this.minCoord.z) {
            ++this.minExtremeBlocks.z;
        }
        if (toAttachPos.m_123341_() > this.maxCoord.x) {
            this.maxCoord.x = toAttachPos.m_123341_();
            this.maxExtremeBlocks.x = 1;
        } else if (toAttachPos.m_123341_() == this.maxCoord.x) {
            ++this.maxExtremeBlocks.x;
        }
        if (toAttachPos.m_123342_() > this.maxCoord.y) {
            this.maxCoord.y = toAttachPos.m_123342_();
            this.maxExtremeBlocks.y = 1;
        } else if (toAttachPos.m_123342_() == this.maxCoord.y) {
            ++this.maxExtremeBlocks.y;
        }
        if (toAttachPos.m_123343_() > this.maxCoord.z) {
            this.maxCoord.z = toAttachPos.m_123343_();
            this.maxExtremeBlocks.z = 1;
        } else if (toAttachPos.m_123343_() == this.maxCoord.z) {
            ++this.maxExtremeBlocks.z;
        }
        if (toAttachTile instanceof ITickableMultiblockTile) {
            ITickableMultiblockTile tickableMultiblockTile = (ITickableMultiblockTile)toAttachTile;
            this.toTick.add(tickableMultiblockTile);
        }
        if (toAttachTile instanceof IAssemblyAttemptedTile) {
            IAssemblyAttemptedTile assemblyAttemptedTile = (IAssemblyAttemptedTile)toAttachTile;
            this.assemblyAttemptedTiles.add(assemblyAttemptedTile);
        }
        if (toAttachTile instanceof IOnAssemblyTile) {
            IOnAssemblyTile onAssemblyTile = (IOnAssemblyTile)toAttachTile;
            this.onAssemblyTiles.add(onAssemblyTile);
        }
        if (toAttachTile instanceof IOnDisassemblyTile) {
            IOnDisassemblyTile onDisassemblyTile = (IOnDisassemblyTile)toAttachTile;
            this.onDisassemblyTiles.add(onDisassemblyTile);
        }
        if (toAttachModule.isSaveDelegate) {
            if (this.hasSaveDelegate) {
                toAttachModule.isSaveDelegate = false;
            } else {
                this.hasSaveDelegate = true;
            }
        }
        toAttachModule.controller = this.self();
        if (toAttachModule.preExistingBlock) {
            if (toAttachModule.controllerData != null) {
                this.onBlockWithNBTAttached(toAttachModule.controllerData);
                toAttachModule.controllerData = null;
            }
            if (this.state == AssemblyState.DISASSEMBLED && !this.isMergingControllers) {
                this.state = AssemblyState.PAUSED;
            }
            this.onPartAttached(toAttachTile);
        } else {
            this.onPartPlaced(toAttachTile);
        }
        toAttachModule.updateNeighbors();
        this.updateAssemblyAtTick = Phosphophyllite.tickNumber() + 1L;
    }

    final void detach(@Nonnull MultiblockTileModule<TileType, ControllerType> toDetach) {
        this.detach(toDetach, false);
    }

    final void detach(@Nonnull MultiblockTileModule<TileType, ControllerType> toDetach, boolean onChunkUnload) {
        this.detach(toDetach, onChunkUnload, true);
    }

    final void detach(@Nonnull MultiblockTileModule<TileType, ControllerType> toDetach, boolean onChunkUnload, boolean attemptReattach) {
        this.detach(toDetach, onChunkUnload, attemptReattach, true);
    }

    final void detach(@Nonnull MultiblockTileModule<TileType, ControllerType> toDetachModule, boolean onChunkUnload, boolean attemptReattach, boolean checkForDetachments) {
        if (!this.blocks.removeModule(toDetachModule)) {
            return;
        }
        BlockEntity toDetachTile = (BlockEntity)toDetachModule.iface;
        if (this.isUpdatingState) {
            throw new IllegalStateException("Attempt to remove block while updating multiblock state");
        }
        if (toDetachTile instanceof ITickableMultiblockTile) {
            this.toTick.remove(toDetachTile);
        }
        if (toDetachTile instanceof IAssemblyAttemptedTile) {
            this.assemblyAttemptedTiles.remove(toDetachTile);
        }
        if (toDetachTile instanceof IOnAssemblyTile) {
            this.onAssemblyTiles.remove(toDetachTile);
        }
        if (toDetachTile instanceof IOnDisassemblyTile) {
            this.onDisassemblyTiles.remove(toDetachTile);
        }
        if (onChunkUnload) {
            this.onPartDetached(toDetachTile);
            if (this.pauseOnUnload) {
                this.state = AssemblyState.PAUSED;
                this.updateCachedNBT();
            }
        } else {
            this.onPartBroken(toDetachTile);
        }
        if (attemptReattach) {
            Queues.serverThread.enqueue(toDetachModule::attachToNeighbors, new Event[0]);
        }
        toDetachModule.nullNeighbors();
        toDetachModule.controller = null;
        if (toDetachModule.isSaveDelegate) {
            this.hasSaveDelegate = false;
        }
        if (this.blocks.isEmpty()) {
            Phosphophyllite.removeController(this);
        }
        BlockPos toDetachPos = toDetachTile.m_58899_();
        if (checkForDetachments) {
            this.checkForDetachmentsAtTick = Phosphophyllite.tickNumber() + 2L;
            if (!onChunkUnload) {
                this.checkForDetachmentsAtTick = Long.MIN_VALUE;
            }
            this.removedBlocks.add(toDetachPos);
        }
        if (toDetachPos.m_123341_() == this.minCoord.x) {
            --this.minExtremeBlocks.x;
            if (this.minExtremeBlocks.x == 0) {
                this.updateExtremes = true;
            }
        }
        if (toDetachPos.m_123342_() == this.minCoord.y) {
            --this.minExtremeBlocks.y;
            if (this.minExtremeBlocks.y == 0) {
                this.updateExtremes = true;
            }
        }
        if (toDetachPos.m_123343_() == this.minCoord.z) {
            --this.minExtremeBlocks.z;
            if (this.minExtremeBlocks.z == 0) {
                this.updateExtremes = true;
            }
        }
        if (toDetachPos.m_123341_() == this.maxCoord.x) {
            --this.maxExtremeBlocks.x;
            if (this.maxExtremeBlocks.x == 0) {
                this.updateExtremes = true;
            }
        }
        if (toDetachPos.m_123342_() == this.maxCoord.y) {
            --this.maxExtremeBlocks.y;
            if (this.maxExtremeBlocks.y == 0) {
                this.updateExtremes = true;
            }
        }
        if (toDetachPos.m_123343_() == this.maxCoord.z) {
            --this.maxExtremeBlocks.z;
            if (this.maxExtremeBlocks.z == 0) {
                this.updateExtremes = true;
            }
        }
        this.updateAssemblyAtTick = Phosphophyllite.tickNumber() + 1L;
    }

    public final void update() {
        if (this.lastTick >= Phosphophyllite.tickNumber()) {
            return;
        }
        this.lastTick = Phosphophyllite.tickNumber();
        if (this.blocks.isEmpty()) {
            Phosphophyllite.removeController(this);
            this.checkForDetachmentsAtTick = Long.MAX_VALUE;
        }
        if (this.checkForDetachmentsAtTick <= Phosphophyllite.tickNumber()) {
            AStarList<MultiblockTileModule> aStarList = new AStarList<MultiblockTileModule>(module -> ((BlockEntity)module.iface).m_58899_());
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (BlockPos removedBlock : this.removedBlocks) {
                for (Direction value : Direction.values()) {
                    mutableBlockPos.m_122190_((Vec3i)removedBlock);
                    mutableBlockPos.m_122173_(value);
                    MultiblockTileModule<TileType, ControllerType> module2 = this.blocks.getModule((BlockPos)mutableBlockPos);
                    if (module2 == null || module2.controller != this) continue;
                    aStarList.addTarget(module2);
                }
            }
            this.removedBlocks.clear();
            Direction[] directions = Direction.values();
            while (!aStarList.done()) {
                MultiblockTileModule node = aStarList.nextNode();
                for (int i = 0; i < 6; ++i) {
                    node.lastSavedTick = this.lastTick;
                    MultiblockTileModule module3 = node.getNeighbor(directions[i]);
                    if (module3 == null || module3.controller != this || module3.lastSavedTick == this.lastTick) continue;
                    module3.lastSavedTick = this.lastTick;
                    aStarList.addNode(module3);
                }
            }
            if (!aStarList.foundAll()) {
                LinkedHashSet toOrphan = new LinkedHashSet();
                this.blocks.forEachModule(module -> {
                    if (module.lastSavedTick != this.lastTick) {
                        toOrphan.add(module);
                    }
                });
                if (!toOrphan.isEmpty()) {
                    for (MultiblockTileModule tile : toOrphan) {
                        this.detach(tile, this.state == AssemblyState.PAUSED, true, false);
                    }
                    this.updateAssemblyAtTick = Long.MIN_VALUE;
                }
            }
            this.checkForDetachmentsAtTick = Long.MAX_VALUE;
        }
        while (!this.controllersToMerge.isEmpty()) {
            HashSet newToMerge = new HashSet();
            for (MultiblockController<?, ?> otherController : this.controllersToMerge) {
                otherController.disassembledBlockStates();
                Phosphophyllite.removeController(otherController);
                otherController.controllersToMerge.remove(this.self());
                newToMerge.addAll(otherController.controllersToMerge);
                otherController.controllersToMerge.clear();
                if (otherController.mergedInto != null && otherController.mergedInto != this) {
                    newToMerge.add(otherController.mergedInto);
                    otherController.mergedInto.controllersToMerge.add(this);
                    continue;
                }
                if (otherController.blocks.size() == 0) continue;
                this.onMerge(otherController);
                if (this.cachedNBT == null && otherController.cachedNBT != null) {
                    this.cachedNBT = otherController.cachedNBT;
                    otherController.cachedNBT = null;
                }
                this.isMergingControllers = true;
                otherController.blocks.forEachModule(module -> {
                    module.controller = null;
                    module.preExistingBlock = true;
                    this.attemptAttach((MultiblockTileModule<?, ?>)module);
                });
                this.isMergingControllers = false;
                otherController.blocks.clear();
                this.updateAssemblyAtTick = Long.MIN_VALUE;
                otherController.mergedInto = this;
            }
            this.controllersToMerge.clear();
            this.controllersToMerge.addAll(newToMerge);
        }
        if (this.updateAssemblyAtTick < this.lastTick) {
            this.updateMinMaxCoordinates();
            this.updateAssemblyState();
            this.updateAssemblyAtTick = Long.MAX_VALUE;
        }
        if (this.state == AssemblyState.ASSEMBLED) {
            this.tick();
            this.toTick.forEach(ITickableMultiblockTile::tick);
        } else if (this.state == AssemblyState.DISASSEMBLED) {
            this.disassembledTick();
        }
    }

    public void revalidate() {
        this.updateAssemblyAtTick = Phosphophyllite.tickNumber() + 1L;
    }

    public void suicide() {
        ModuleMap blocks = new ModuleMap((TileModule[])new MultiblockTileModule[0]);
        blocks.addAll(this.blocks);
        blocks.forEachModule(module -> module.onRemoved(true));
        Phosphophyllite.removeController(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAssemblyState() {
        AssemblyState oldState = this.state;
        boolean validated = false;
        this.lastValidationError = null;
        try {
            this.isUpdatingState = true;
            try {
                validated = this.assemblyValidator.validate(this.self());
            }
            catch (ValidationError e) {
                this.lastValidationError = e;
            }
            if (validated) {
                this.state = AssemblyState.ASSEMBLED;
                if (this.cachedNBT != null && oldState != AssemblyState.ASSEMBLED) {
                    this.read(this.cachedNBT.m_128469_("userdata"));
                    this.shouldUpdateNBT = true;
                }
                this.onValidationPassed();
                if (oldState == AssemblyState.PAUSED) {
                    this.onUnpaused();
                } else if (oldState == AssemblyState.DISASSEMBLED) {
                    this.onAssembled();
                }
                this.assembledBlockStates();
                this.onAssemblyTiles.forEach(IOnAssemblyTile::onAssembly);
                if (!this.hasSaveDelegate) {
                    MultiblockTileModule<TileType, ControllerType> module = this.blocks.getOne();
                    assert (module != null);
                    module.isSaveDelegate = true;
                    this.hasSaveDelegate = true;
                }
            } else if (oldState == AssemblyState.ASSEMBLED) {
                this.state = AssemblyState.DISASSEMBLED;
                this.onDisassembled();
                this.disassembledBlockStates();
                this.updateCachedNBT();
                this.onDisassemblyTiles.forEach(IOnDisassemblyTile::onDisassembly);
            }
            this.assemblyAttemptedTiles.forEach(IAssemblyAttemptedTile::onAssemblyAttempted);
        }
        finally {
            this.isUpdatingState = false;
        }
    }

    private void onBlockWithNBTAttached(CompoundTag nbt) {
        if (this.cachedNBT == null) {
            this.readNBT(nbt);
        }
    }

    private void assembledBlockStates() {
        this.newStates.clear();
        int size = this.blocks.size();
        BlockEntity[] tileElements = this.blocks.tileElements();
        MultiblockTileModule[] moduleElements = (MultiblockTileModule[])this.blocks.moduleElements();
        long[] posElements = this.blocks.posElements();
        if (tileElements.length < size || moduleElements.length < size || posElements.length < size) {
            throw new IllegalStateException("Arrays too short");
        }
        for (int i = 0; i < size; ++i) {
            BlockEntity entity = tileElements[i];
            MultiblockTileModule module = moduleElements[i];
            long pos = posElements[i];
            BlockState oldState = entity.m_58900_();
            BlockState newState = module.assembledBlockState(oldState);
            if (newState == oldState) continue;
            this.newStates.put(pos, (Object)newState);
            entity.m_155250_(newState);
        }
        if (!this.newStates.isEmpty()) {
            Util.setBlockStates(this.newStates, this.world);
        }
    }

    private void disassembledBlockStates() {
        this.newStates.clear();
        int size = this.blocks.size();
        BlockEntity[] tileElements = this.blocks.tileElements();
        MultiblockTileModule[] moduleElements = (MultiblockTileModule[])this.blocks.moduleElements();
        long[] posElements = this.blocks.posElements();
        if (tileElements.length < size || moduleElements.length < size || posElements.length < size) {
            throw new IllegalStateException("Arrays too short");
        }
        for (int i = 0; i < size; ++i) {
            BlockEntity entity = tileElements[i];
            MultiblockTileModule module = moduleElements[i];
            long pos = posElements[i];
            BlockState oldState = entity.m_58900_();
            BlockState newState = module.disassembledBlockState(oldState);
            if (newState == oldState) continue;
            this.newStates.put(pos, (Object)newState);
            entity.m_155250_(newState);
        }
        if (!this.newStates.isEmpty()) {
            Util.setBlockStates(this.newStates, this.world);
        }
    }

    final void readNBT(CompoundTag nbt) {
        if (!nbt.m_128456_()) {
            this.cachedNBT = nbt.m_6426_();
            CompoundTag multiblockData = this.cachedNBT.m_128469_("multiblockData");
            if (multiblockData.m_128441_("assemblyState")) {
                AssemblyState nbtState = AssemblyState.valueOf(multiblockData.m_128461_("assemblyState"));
                if (this.state == AssemblyState.DISASSEMBLED && (nbtState == AssemblyState.PAUSED || nbtState == AssemblyState.ASSEMBLED) && this.pauseOnUnload) {
                    this.state = AssemblyState.PAUSED;
                }
            }
        }
    }

    @Nonnull
    final CompoundTag getNBT() {
        if (!this.pauseOnUnload) {
            return new CompoundTag();
        }
        if (this.shouldUpdateNBT) {
            this.shouldUpdateNBT = false;
            this.updateCachedNBT();
        }
        return this.cachedNBT == null ? new CompoundTag() : this.cachedNBT;
    }

    private void updateCachedNBT() {
        this.cachedNBT = new CompoundTag();
        this.cachedNBT.m_128365_("userdata", (Tag)this.write());
        CompoundTag multiblockData = new CompoundTag();
        this.cachedNBT.m_128365_("multiblockData", (Tag)multiblockData);
        multiblockData.m_128405_("controller", this.hashCode());
        multiblockData.m_128359_("assemblyState", this.state.toString());
    }

    protected final void markDirty() {
        this.shouldUpdateNBT = true;
        Util.markRangeDirty(this.world, new Vector2i(this.minCoord.x, this.minCoord.z), new Vector2i(this.maxCoord.x, this.maxCoord.z));
    }

    @Nonnull
    public AssemblyState assemblyState() {
        return this.state;
    }

    @Override
    @Nonnull
    public String getDebugString() {
        return "BlockCount: " + this.blocks.size() + "\nMin " + this.minCoord + "\nMax " + this.maxCoord + "\nController: " + this + "\nLast Error: " + (this.lastValidationError == null ? "N/A" : this.lastValidationError.getTextComponent().getString()) + "\nAssemblyState: " + this.state + "\n";
    }

    protected void setAssemblyValidator(@Nullable Validator<ControllerType> validator) {
        if (validator != null) {
            this.assemblyValidator = validator;
        }
    }

    public void tick() {
    }

    public void disassembledTick() {
    }

    protected void onPartAttached(@Nonnull TileType toAttach) {
    }

    protected void onPartDetached(@Nonnull TileType toDetach) {
    }

    protected void onPartPlaced(@Nonnull TileType placed) {
    }

    protected void onPartBroken(@Nonnull TileType broken) {
    }

    protected void onMerge(@Nonnull ControllerType otherController) {
    }

    protected void onValidationPassed() {
    }

    protected void onAssembled() {
    }

    protected void onDisassembled() {
    }

    protected void onUnpaused() {
    }

    protected void read(@Nonnull CompoundTag compound) {
    }

    @Nonnull
    protected CompoundTag write() {
        return new CompoundTag();
    }

    public static enum AssemblyState {
        ASSEMBLED,
        DISASSEMBLED,
        PAUSED;

    }
}

