/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.multiblock;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.roguelogix.phosphophyllite.modular.api.BlockModule;
import net.roguelogix.phosphophyllite.modular.api.IModularBlock;
import net.roguelogix.phosphophyllite.modular.api.ModuleRegistry;
import net.roguelogix.phosphophyllite.multiblock.IAssemblyStateBlock;
import net.roguelogix.phosphophyllite.multiblock.IMultiblockTile;
import net.roguelogix.phosphophyllite.multiblock.MultiblockController;
import net.roguelogix.phosphophyllite.registry.OnModLoad;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public interface IMultiblockBlock
extends IModularBlock,
EntityBlock {

    public static class Module
    extends BlockModule<IMultiblockBlock> {
        public Module(IModularBlock iface) {
            super(iface);
        }

        @Override
        public InteractionResult onUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
            if (!(!player.m_21205_().m_41619_() || hand != InteractionHand.MAIN_HAND || state.m_61138_((Property)IAssemblyStateBlock.ASSEMBLED) && ((Boolean)state.m_61143_((Property)IAssemblyStateBlock.ASSEMBLED)).booleanValue())) {
                BlockEntity blockEntity;
                if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof IMultiblockTile) {
                    IMultiblockTile tile = (IMultiblockTile)blockEntity;
                    Object controller = tile.nullableController();
                    if (controller != null && ((MultiblockController)controller).lastValidationError != null) {
                        player.m_6352_(((MultiblockController)controller).lastValidationError.getTextComponent(), Util.f_137441_);
                    } else if (controller == null) {
                        player.m_6352_((Component)new TranslatableComponent("multiblock.error.phosphophyllite.null_controller"), Util.f_137441_);
                    } else {
                        player.m_6352_((Component)new TranslatableComponent("multiblock.error.phosphophyllite.unknown"), Util.f_137441_);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            return super.onUse(state, level, pos, player, hand, hitResult);
        }

        @OnModLoad
        static void onModLoad() {
            ModuleRegistry.registerBlockModule(IMultiblockBlock.class, Module::new);
        }
    }
}

