/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.modular.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.roguelogix.phosphophyllite.modular.api.BlockModule;
import net.roguelogix.phosphophyllite.modular.api.IModularBlock;
import net.roguelogix.phosphophyllite.modular.api.ModuleRegistry;
import net.roguelogix.phosphophyllite.registry.OnModLoad;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public interface IConnectedTexture
extends IModularBlock {
    default public boolean connectToBlock(Block block) {
        return block == this.as(Block.class);
    }

    public static final class Module
    extends BlockModule<IConnectedTexture> {
        public static final BooleanProperty TOP_CONNECTED_PROPERTY = BooleanProperty.m_61465_((String)"top_connected");
        public static final BooleanProperty BOTTOM_CONNECTED_PROPERTY = BooleanProperty.m_61465_((String)"bottom_connected");
        public static final BooleanProperty NORTH_CONNECTED_PROPERTY = BooleanProperty.m_61465_((String)"north_connected");
        public static final BooleanProperty SOUTH_CONNECTED_PROPERTY = BooleanProperty.m_61465_((String)"south_connected");
        public static final BooleanProperty EAST_CONNECTED_PROPERTY = BooleanProperty.m_61465_((String)"east_connected");
        public static final BooleanProperty WEST_CONNECTED_PROPERTY = BooleanProperty.m_61465_((String)"west_connected");

        private Module(IConnectedTexture iface) {
            super(iface);
        }

        @Override
        public void buildStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{TOP_CONNECTED_PROPERTY});
            builder.m_61104_(new Property[]{BOTTOM_CONNECTED_PROPERTY});
            builder.m_61104_(new Property[]{NORTH_CONNECTED_PROPERTY});
            builder.m_61104_(new Property[]{SOUTH_CONNECTED_PROPERTY});
            builder.m_61104_(new Property[]{EAST_CONNECTED_PROPERTY});
            builder.m_61104_(new Property[]{WEST_CONNECTED_PROPERTY});
        }

        @Override
        public BlockState buildDefaultState(BlockState state) {
            state = (BlockState)state.m_61124_((Property)TOP_CONNECTED_PROPERTY, (Comparable)Boolean.valueOf(false));
            state = (BlockState)state.m_61124_((Property)BOTTOM_CONNECTED_PROPERTY, (Comparable)Boolean.valueOf(false));
            state = (BlockState)state.m_61124_((Property)NORTH_CONNECTED_PROPERTY, (Comparable)Boolean.valueOf(false));
            state = (BlockState)state.m_61124_((Property)SOUTH_CONNECTED_PROPERTY, (Comparable)Boolean.valueOf(false));
            state = (BlockState)state.m_61124_((Property)EAST_CONNECTED_PROPERTY, (Comparable)Boolean.valueOf(false));
            state = (BlockState)state.m_61124_((Property)WEST_CONNECTED_PROPERTY, (Comparable)Boolean.valueOf(false));
            return state;
        }

        private void updateConnectedTextureState(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state) {
            state = (BlockState)state.m_61124_((Property)TOP_CONNECTED_PROPERTY, (Comparable)Boolean.valueOf(((IConnectedTexture)this.iface).connectToBlock(level.m_8055_(pos.m_142300_(Direction.UP)).m_60734_())));
            state = (BlockState)state.m_61124_((Property)BOTTOM_CONNECTED_PROPERTY, (Comparable)Boolean.valueOf(((IConnectedTexture)this.iface).connectToBlock(level.m_8055_(pos.m_142300_(Direction.DOWN)).m_60734_())));
            state = (BlockState)state.m_61124_((Property)NORTH_CONNECTED_PROPERTY, (Comparable)Boolean.valueOf(((IConnectedTexture)this.iface).connectToBlock(level.m_8055_(pos.m_142300_(Direction.NORTH)).m_60734_())));
            state = (BlockState)state.m_61124_((Property)SOUTH_CONNECTED_PROPERTY, (Comparable)Boolean.valueOf(((IConnectedTexture)this.iface).connectToBlock(level.m_8055_(pos.m_142300_(Direction.SOUTH)).m_60734_())));
            state = (BlockState)state.m_61124_((Property)EAST_CONNECTED_PROPERTY, (Comparable)Boolean.valueOf(((IConnectedTexture)this.iface).connectToBlock(level.m_8055_(pos.m_142300_(Direction.EAST)).m_60734_())));
            state = (BlockState)state.m_61124_((Property)WEST_CONNECTED_PROPERTY, (Comparable)Boolean.valueOf(((IConnectedTexture)this.iface).connectToBlock(level.m_8055_(pos.m_142300_(Direction.WEST)).m_60734_())));
            level.m_7731_(pos, state, 2);
        }

        @Override
        public void onPlaced(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
            this.updateConnectedTextureState(level, pos, state);
        }

        @Override
        public void onNeighborChange(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
            this.updateConnectedTextureState(level, pos, state);
        }

        @OnModLoad
        static void onModLoad() {
            ModuleRegistry.registerBlockModule(IConnectedTexture.class, Module::new);
        }
    }
}

