/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.config;

import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.roguelogix.phosphophyllite.Phosphophyllite;
import net.roguelogix.phosphophyllite.config.ConfigManager;
import net.roguelogix.phosphophyllite.config.ConfigValue;
import net.roguelogix.phosphophyllite.parsers.Element;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ConfigSpec {
    @Nonnull
    public final SpecNode masterNode;

    ConfigSpec(Field field, Object object) {
        field.setAccessible(true);
        SpecObjectNode masterNode = ConfigSpec.buildNodeForObject(object.getClass(), object, field, null, false, false, true);
        if (masterNode == null) {
            throw new IllegalArgumentException("Unable to build root node");
        }
        this.masterNode = masterNode;
    }

    public ConfigSpec(SpecNode masterNode) {
        this.masterNode = masterNode;
    }

    public Element trimAndRegenerateTree(Element tree, boolean enableAdvanced) {
        return this.regenerateElementTree(this.trimElementTree(tree), enableAdvanced);
    }

    @Nullable
    public Element trimElementTree(Element tree) {
        return this.trimElementForNode(tree, this.masterNode);
    }

    @Nullable
    public Element trimElementForNode(Element element, SpecNode node) {
        if (node instanceof SpecClazzNode) {
            SpecClazzNode clazzNode = (SpecClazzNode)node;
            if (element.type != Element.Type.Section) {
                return null;
            }
            ArrayList<Element> trimmedElements = new ArrayList<Element>();
            for (Element subElement : element.asArray()) {
                Element newElement;
                SpecNode subNode = clazzNode.fieldNodes.get(subElement.name);
                if (subNode == null) {
                    subNode = clazzNode.clazzNodes.get(subElement.name);
                }
                if (subNode == null || (newElement = this.trimElementForNode(subElement, subNode)) == null) continue;
                trimmedElements.add(newElement);
            }
            if (trimmedElements.size() == 0) {
                return null;
            }
            return new Element(Element.Type.Section, clazzNode.comment, element.name, trimmedElements.toArray());
        }
        if (node instanceof SpecObjectNode) {
            SpecObjectNode objectNode = (SpecObjectNode)node;
            if (element.type != Element.Type.Section) {
                return null;
            }
            ArrayList<Element> trimmedElements = new ArrayList<Element>();
            for (Element subElement : element.asArray()) {
                Element newElement;
                SpecFieldNode subNode = objectNode.subNodes.get(subElement.name);
                if (subNode == null || (newElement = this.trimElementForNode(subElement, subNode)) == null) continue;
                trimmedElements.add(newElement);
            }
            if (trimmedElements.size() == 0) {
                return null;
            }
            return new Element(Element.Type.Section, objectNode.comment, element.name, trimmedElements.toArray());
        }
        if (node instanceof SpecElementNode) {
            SpecElementNode elementNode = (SpecElementNode)node;
            if (element.type != Element.Type.Section) {
                return null;
            }
            ArrayList<Element> trimmedElements = new ArrayList<Element>();
            for (Element subElement : element.asArray()) {
                Element newElement;
                SpecFieldNode subNode = elementNode.subNodes.get(subElement.name);
                if (subNode == null || (newElement = this.trimElementForNode(subElement, subNode)) == null) continue;
                trimmedElements.add(newElement);
            }
            if (trimmedElements.size() == 0) {
                return null;
            }
            return new Element(Element.Type.Section, elementNode.comment, element.name, trimmedElements.toArray());
        }
        if (node instanceof SpecMapNode) {
            SpecMapNode mapNode = (SpecMapNode)node;
            if (element.type != Element.Type.Section) {
                return null;
            }
            SpecElementNode subNode = mapNode.nodeType;
            ArrayList<Element> trimmedElements = new ArrayList<Element>();
            for (Element subElement : element.asArray()) {
                Element newElement = this.trimElementForNode(subElement, subNode);
                if (newElement == null) continue;
                trimmedElements.add(newElement);
            }
            if (trimmedElements.size() == 0) {
                return null;
            }
            return new Element(Element.Type.Section, mapNode.comment, element.name, trimmedElements.toArray());
        }
        if (node instanceof SpecListNode) {
            SpecListNode listNode = (SpecListNode)node;
            if (element.type != Element.Type.Array) {
                return null;
            }
            SpecElementNode subNode = listNode.subNodeType;
            ArrayList<Element> trimmedElements = new ArrayList<Element>();
            for (Element subElement : element.asArray()) {
                Element newElement = this.trimElementForNode(subElement, subNode);
                if (newElement == null) continue;
                trimmedElements.add(newElement);
            }
            if (trimmedElements.size() == 0) {
                return null;
            }
            return new Element(Element.Type.Array, listNode.comment, element.name, trimmedElements.toArray());
        }
        if (node instanceof SpecStringNode) {
            if (element.type != Element.Type.String && element.type != Element.Type.Number && element.type != Element.Type.Boolean) {
                return null;
            }
            return element;
        }
        if (node instanceof SpecEnumNode) {
            SpecEnumNode enumNode = (SpecEnumNode)node;
            if (element.type != Element.Type.String) {
                return null;
            }
            Enum[] enumVals = (Enum[])enumNode.enumClass.getEnumConstants();
            String[] enumValStrings = new String[enumVals.length];
            for (int i = 0; i < enumVals.length; ++i) {
                enumValStrings[i] = enumVals[i].toString().toLowerCase(Locale.ENGLISH);
            }
            String nameGiven = element.asString().toLowerCase(Locale.ENGLISH);
            Enum givenVal = null;
            block6: for (int i = 0; i < enumValStrings.length; ++i) {
                if (!nameGiven.equals(enumValStrings[i])) continue;
                if (enumNode.allowedValues.isEmpty()) {
                    givenVal = enumVals[i];
                    break;
                }
                for (String allowedValue : enumNode.allowedValues) {
                    if (!nameGiven.equals(allowedValue.toLowerCase(Locale.ENGLISH))) continue;
                    givenVal = enumVals[i];
                    break block6;
                }
                break;
            }
            if (givenVal == null) {
                return null;
            }
            return new Element(Element.Type.String, enumNode.comment, element.name, givenVal.toString());
        }
        if (node instanceof SpecNumberNode) {
            SpecNumberNode numberNode = (SpecNumberNode)node;
            if (element.type != Element.Type.Number) {
                return null;
            }
            double val = element.asDouble();
            if (ConfigSpec.isIntegral(numberNode.field.getType())) {
                long realVal = Math.round(val);
                if ((double)realVal < numberNode.lowerBound || (double)realVal > numberNode.upperBound || (double)realVal <= numberNode.lowerBound && !numberNode.lowerInclusive || (double)realVal >= numberNode.upperBound && !numberNode.upperInclusive) {
                    if ((double)realVal <= numberNode.lowerBound) {
                        realVal = Math.round(numberNode.lowerBound);
                        if (!numberNode.lowerInclusive) {
                            ++realVal;
                        }
                    } else if ((double)realVal >= numberNode.upperBound) {
                        realVal = Math.round(numberNode.upperBound);
                        if (!numberNode.upperInclusive) {
                            --realVal;
                        }
                    }
                }
                val = realVal;
            } else if (val < numberNode.lowerBound || val > numberNode.upperBound || val <= numberNode.lowerBound && !numberNode.lowerInclusive || val >= numberNode.upperBound && !numberNode.upperInclusive) {
                if (val <= numberNode.lowerBound) {
                    val = numberNode.lowerBound;
                    if (!numberNode.lowerInclusive) {
                        val = Math.nextAfter(val, Double.POSITIVE_INFINITY);
                    }
                } else if (val >= numberNode.upperBound) {
                    val = numberNode.upperBound;
                    if (!numberNode.upperInclusive) {
                        val = Math.nextAfter(val, Double.NEGATIVE_INFINITY);
                    }
                }
            }
            return new Element(Element.Type.Number, numberNode.comment, element.name, String.valueOf(val));
        }
        if (node instanceof SpecBooleanNode) {
            boolean newVal;
            SpecBooleanNode booleanNode = (SpecBooleanNode)node;
            if (element.type != Element.Type.String && element.type != Element.Type.Number && element.type != Element.Type.Boolean) {
                return null;
            }
            if (element.type == Element.Type.String || element.type == Element.Type.Boolean) {
                String str = element.asString();
                newVal = Boolean.parseBoolean(str);
            } else {
                newVal = element.asDouble() != 0.0;
            }
            return new Element(Element.Type.Boolean, booleanNode.comment, element.name, String.valueOf(newVal));
        }
        return null;
    }

    public Element regenerateElementTree(@Nullable Element tree, boolean enableAdvanced) {
        try {
            return this.regenerateElementTreeForNode(tree, this.masterNode, null, null, enableAdvanced);
        }
        catch (IllegalAccessException e) {
            ConfigManager.LOGGER.error("Unexpected error caught regenerating config");
            ConfigManager.LOGGER.error(e.toString());
            throw new DefinitionError(e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public Element regenerateElementTreeForNode(@Nullable Element tree, SpecNode node, @Nullable Object object, @Nullable String name, boolean enableAdvanced) throws IllegalAccessException {
        if (tree == null) {
            return this.generateElementForNode(node, object, name, enableAdvanced, false);
        }
        if (node instanceof SpecClazzNode) {
            SpecClazzNode clazzNode = (SpecClazzNode)node;
            if (tree.type != Element.Type.Section) {
                return this.generateElementForNode(node, object, name, enableAdvanced, false);
            }
            ArrayList<Element> subElements = new ArrayList<Element>();
            Element[] elements = tree.asArray();
            block0: for (Map.Entry<String, SpecFieldNode> entry : clazzNode.fieldNodes.entrySet()) {
                for (Element element : elements) {
                    if (!entry.getKey().equals(element.name)) continue;
                    subElements.add(this.regenerateElementTreeForNode(element, entry.getValue(), null, entry.getKey(), enableAdvanced));
                    continue block0;
                }
                if (!enableAdvanced && entry.getValue().advanced || entry.getValue().hidden) continue;
                subElements.add(this.regenerateElementTreeForNode(null, entry.getValue(), null, entry.getKey(), enableAdvanced));
            }
            block2: for (Map.Entry<String, SpecNode> entry : clazzNode.clazzNodes.entrySet()) {
                Element subElement;
                for (Element element : elements) {
                    Element subElement2;
                    if (!entry.getKey().equals(element.name)) continue;
                    if (!enableAdvanced && ((SpecClazzNode)entry.getValue()).advanced || ((SpecClazzNode)entry.getValue()).hidden || (subElement2 = this.regenerateElementTreeForNode(element, entry.getValue(), null, entry.getKey(), enableAdvanced)).asArray().length == 0) continue block2;
                    subElements.add(subElement2);
                    continue block2;
                }
                if (!enableAdvanced && ((SpecClazzNode)entry.getValue()).advanced || ((SpecClazzNode)entry.getValue()).hidden || (subElement = this.regenerateElementTreeForNode(null, entry.getValue(), null, entry.getKey(), enableAdvanced)).asArray().length == 0) continue;
                subElements.add(subElement);
            }
            return new Element(Element.Type.Section, node.comment, name, subElements.toArray());
        }
        if (node instanceof SpecObjectNode) {
            SpecObjectNode objectNode = (SpecObjectNode)node;
            if (tree.type != Element.Type.Section) {
                return this.generateElementForNode(objectNode, object, name, enableAdvanced, false);
            }
            Object nodeObject = objectNode.field.get(object);
            if (nodeObject == null) {
                nodeObject = ConfigSpec.createClassInstance(objectNode.clazz);
                objectNode.field.set(object, nodeObject);
            }
            ArrayList<Element> subElements = new ArrayList<Element>();
            Element[] elements = tree.asArray();
            block4: for (Map.Entry<String, SpecFieldNode> entry : objectNode.subNodes.entrySet()) {
                Element subElement;
                for (Element element : elements) {
                    if (!entry.getKey().equals(element.name)) continue;
                    Element subElement3 = this.regenerateElementTreeForNode(element, entry.getValue(), nodeObject, entry.getKey(), enableAdvanced);
                    if (subElement3.subElemenets() == 0) continue block4;
                    subElements.add(subElement3);
                    continue block4;
                }
                if (!enableAdvanced && entry.getValue().advanced || entry.getValue().hidden || (subElement = this.regenerateElementTreeForNode(null, entry.getValue(), nodeObject, entry.getKey(), enableAdvanced)).subElemenets() == 0) continue;
                subElements.add(subElement);
            }
            return new Element(Element.Type.Section, objectNode.comment, name, subElements.toArray());
        }
        if (node instanceof SpecElementNode) {
            SpecElementNode elementNode = (SpecElementNode)node;
            if (tree.type != Element.Type.Section) {
                return this.generateElementForNode(elementNode, object, name, enableAdvanced, false);
            }
            if (object == null) {
                throw new IllegalArgumentException("Cannot write element node into null object");
            }
            ArrayList<Element> subElements = new ArrayList<Element>();
            Element[] elements = tree.asArray();
            block6: for (Map.Entry<String, SpecFieldNode> entry : elementNode.subNodes.entrySet()) {
                Element subElement;
                for (Element element : elements) {
                    if (!entry.getKey().equals(element.name)) continue;
                    Element subElement4 = this.regenerateElementTreeForNode(element, entry.getValue(), object, entry.getKey(), enableAdvanced);
                    if (subElement4.subElemenets() == 0) continue block6;
                    subElements.add(subElement4);
                    continue block6;
                }
                if (!enableAdvanced && entry.getValue().advanced || entry.getValue().hidden || (subElement = this.regenerateElementTreeForNode(null, entry.getValue(), object, entry.getKey(), enableAdvanced)).subElemenets() == 0) continue;
                subElements.add(subElement);
            }
            return new Element(Element.Type.Section, elementNode.comment, name, subElements.toArray());
        }
        if (node instanceof SpecMapNode) {
            SpecMapNode mapNode = (SpecMapNode)node;
            if (tree.type != Element.Type.Section) {
                return this.generateElementForNode(mapNode, object, name, enableAdvanced, false);
            }
            ArrayList<Element> subElements = new ArrayList<Element>();
            Element[] elements = tree.asArray();
            Object nodeObject = mapNode.field.get(object);
            Map map = (Map)nodeObject;
            for (Element element : elements) {
                Object elementObject = map.get(element.name);
                if (elementObject == null) {
                    elementObject = ConfigSpec.createClassInstance(mapNode.elementClass);
                    map.put(element.name, elementObject);
                }
                subElements.add(this.regenerateElementTreeForNode(element, mapNode.nodeType, elementObject, element.name, enableAdvanced));
            }
            return new Element(Element.Type.Section, mapNode.comment, name, subElements.toArray());
        }
        if (node instanceof SpecListNode) {
            SpecListNode listNode = (SpecListNode)node;
            if (tree.type != Element.Type.Array) {
                return this.generateElementForNode(listNode, object, name, enableAdvanced, false);
            }
            ArrayList<Element> subElements = new ArrayList<Element>();
            Element[] elements = tree.asArray();
            Object nodeObject = listNode.field.get(object);
            List list = (List)nodeObject;
            for (int i = 0; i < elements.length; ++i) {
                Object elementObject;
                if (i < list.size()) {
                    elementObject = list.get(i);
                } else {
                    elementObject = ConfigSpec.createClassInstance(listNode.elementClass);
                    list.add(elementObject);
                }
                subElements.add(this.regenerateElementTreeForNode(elements[i], listNode.subNodeType, elementObject, null, enableAdvanced));
            }
            return new Element(Element.Type.Array, listNode.comment, name, subElements.toArray());
        }
        if (node instanceof SpecEnumNode) {
            void var17_41;
            SpecEnumNode enumNode = (SpecEnumNode)node;
            if (tree.type != Element.Type.String) {
                return this.generateElementForNode(enumNode, object, name, enableAdvanced, false);
            }
            Enum[] enumVals = (Enum[])enumNode.enumClass.getEnumConstants();
            String[] enumValStrings = new String[enumVals.length];
            for (int i = 0; i < enumVals.length; ++i) {
                enumValStrings[i] = enumVals[i].toString().toLowerCase(Locale.ENGLISH);
            }
            String nameGiven = tree.asString().toLowerCase(Locale.ENGLISH);
            Object var17_37 = null;
            block11: for (int i = 0; i < enumValStrings.length; ++i) {
                if (!nameGiven.equals(enumValStrings[i])) continue;
                if (enumNode.allowedValues.isEmpty()) {
                    Enum enum_ = enumVals[i];
                    break;
                }
                for (String allowedValue : enumNode.allowedValues) {
                    if (!nameGiven.equals(allowedValue.toLowerCase(Locale.ENGLISH))) continue;
                    Enum enum_ = enumVals[i];
                    break block11;
                }
                break;
            }
            if (var17_41 == null) {
                return this.generateElementForNode(enumNode, object, name, enableAdvanced, false);
            }
            return tree;
        }
        if (node instanceof SpecStringNode) {
            if (tree.type != Element.Type.String && tree.type != Element.Type.Number && tree.type != Element.Type.Boolean) {
                return this.generateElementForNode(node, object, name, enableAdvanced, false);
            }
            return tree;
        }
        if (node instanceof SpecNumberNode) {
            SpecNumberNode numberNode = (SpecNumberNode)node;
            if (tree.type != Element.Type.Number) {
                return this.generateElementForNode(numberNode, object, name, enableAdvanced, false);
            }
            double val = tree.asDouble();
            if (numberNode.integral) {
                long realVal = Math.round(val);
                if ((double)realVal < numberNode.lowerBound || (double)realVal > numberNode.upperBound || (double)realVal <= numberNode.lowerBound && !numberNode.lowerInclusive || (double)realVal >= numberNode.upperBound && !numberNode.upperInclusive) {
                    if ((double)realVal <= numberNode.lowerBound) {
                        realVal = Math.round(numberNode.lowerBound);
                        if (!numberNode.lowerInclusive) {
                            ++realVal;
                        }
                    } else if ((double)realVal >= numberNode.upperBound) {
                        realVal = Math.round(numberNode.upperBound);
                        if (!numberNode.upperInclusive) {
                            --realVal;
                        }
                    }
                }
                val = realVal;
            } else if (val < numberNode.lowerBound || val > numberNode.upperBound || val <= numberNode.lowerBound && !numberNode.lowerInclusive || val >= numberNode.upperBound && !numberNode.upperInclusive) {
                if (val <= numberNode.lowerBound) {
                    val = numberNode.lowerBound;
                    if (!numberNode.lowerInclusive) {
                        val = Math.nextAfter(val, Double.POSITIVE_INFINITY);
                    }
                } else if (val >= numberNode.upperBound) {
                    val = numberNode.upperBound;
                    if (!numberNode.upperInclusive) {
                        val = Math.nextAfter(val, Double.NEGATIVE_INFINITY);
                    }
                }
            }
            return new Element(Element.Type.Number, numberNode.comment, tree.name, String.valueOf(val));
        }
        if (node instanceof SpecBooleanNode) {
            boolean newVal;
            SpecBooleanNode boolNode = (SpecBooleanNode)node;
            if (tree.type != Element.Type.String && tree.type != Element.Type.Number && tree.type != Element.Type.Boolean) {
                return this.generateElementForNode(boolNode, object, name, enableAdvanced, false);
            }
            if (tree.type == Element.Type.String || tree.type == Element.Type.Boolean) {
                String str = tree.asString();
                newVal = Boolean.parseBoolean(str);
            } else {
                newVal = tree.asDouble() != 0.0;
            }
            return new Element(Element.Type.Boolean, boolNode.comment, tree.name, String.valueOf(newVal));
        }
        throw new DefinitionError("Attempting to regenerate element for unknown node type");
    }

    public Element generateElementTree(boolean enableAdvanced) {
        return this.generateElementTree(enableAdvanced, false);
    }

    public Element generateElementTree(boolean enableAdvanced, boolean fullTree) {
        try {
            return this.generateElementForNode(this.masterNode, null, null, enableAdvanced | fullTree, fullTree);
        }
        catch (IllegalAccessException e) {
            ConfigManager.LOGGER.error("Unexpected error caught reading from config");
            ConfigManager.LOGGER.error(e.toString());
            throw new DefinitionError(e.getMessage());
        }
    }

    public Element generateElementForNode(SpecNode node, @Nullable Object object, @Nullable String name, boolean enableAdvanced, boolean fullTree) throws IllegalAccessException {
        if (node instanceof SpecClazzNode) {
            SpecClazzNode clazzNode = (SpecClazzNode)node;
            ArrayList<Element> subElements = new ArrayList<Element>();
            for (Map.Entry<String, SpecFieldNode> entry : clazzNode.fieldNodes.entrySet()) {
                if (!fullTree && (!enableAdvanced && entry.getValue().advanced || entry.getValue().hidden)) continue;
                subElements.add(this.generateElementForNode(entry.getValue(), null, entry.getKey(), enableAdvanced, fullTree));
            }
            for (Map.Entry<String, SpecNode> entry : clazzNode.clazzNodes.entrySet()) {
                if (!fullTree && (!enableAdvanced && ((SpecClazzNode)entry.getValue()).advanced || ((SpecClazzNode)entry.getValue()).hidden)) continue;
                subElements.add(this.generateElementForNode(entry.getValue(), null, entry.getKey(), enableAdvanced, fullTree));
            }
            return new Element(Element.Type.Section, clazzNode.comment, name, subElements.toArray());
        }
        if (node instanceof SpecObjectNode) {
            SpecObjectNode objectNode = (SpecObjectNode)node;
            Object nodeObject = objectNode.field.get(object);
            ArrayList<Element> subElements = new ArrayList<Element>();
            for (Map.Entry<String, SpecFieldNode> entry : objectNode.subNodes.entrySet()) {
                if (!fullTree && (!enableAdvanced && entry.getValue().advanced || entry.getValue().hidden)) continue;
                subElements.add(this.generateElementForNode(entry.getValue(), nodeObject, entry.getKey(), enableAdvanced, fullTree));
            }
            return new Element(Element.Type.Section, objectNode.comment, name, subElements.toArray());
        }
        if (node instanceof SpecElementNode) {
            SpecElementNode elementNode = (SpecElementNode)node;
            ArrayList<Element> subElements = new ArrayList<Element>();
            for (Map.Entry<String, SpecFieldNode> entry : elementNode.subNodes.entrySet()) {
                if (!fullTree && (!enableAdvanced && entry.getValue().advanced || entry.getValue().hidden)) continue;
                subElements.add(this.generateElementForNode(entry.getValue(), object, entry.getKey(), enableAdvanced, fullTree));
            }
            return new Element(Element.Type.Section, elementNode.comment, name, subElements.toArray());
        }
        if (node instanceof SpecMapNode) {
            SpecMapNode mapNode = (SpecMapNode)node;
            Object nodeObject = mapNode.field.get(object);
            assert (nodeObject instanceof Map);
            Map map = (Map)nodeObject;
            ArrayList<Element> arrayList = new ArrayList<Element>();
            for (Map.Entry entry : map.entrySet()) {
                arrayList.add(this.generateElementForNode(mapNode.nodeType, entry.getValue(), (String)entry.getKey(), enableAdvanced, fullTree));
            }
            return new Element(Element.Type.Section, mapNode.comment, name, arrayList.toArray());
        }
        if (node instanceof SpecListNode) {
            SpecListNode listNode = (SpecListNode)node;
            Object nodeObject = listNode.field.get(object);
            SpecElementNode subNodeType = listNode.subNodeType;
            ArrayList<Element> arrayList = new ArrayList<Element>();
            if (nodeObject instanceof List) {
                List list = (List)nodeObject;
                for (Object o : list) {
                    arrayList.add(this.generateElementForNode(subNodeType, o, null, enableAdvanced, fullTree));
                }
            } else {
                assert (nodeObject.getClass().isArray());
                int length = Array.getLength(nodeObject);
                for (int i = 0; i < length; ++i) {
                    arrayList.add(this.generateElementForNode(subNodeType, Array.get(nodeObject, i), null, enableAdvanced, fullTree));
                }
            }
            return new Element(Element.Type.Array, listNode.comment, name, arrayList.toArray());
        }
        if (node instanceof SpecStringNode) {
            SpecStringNode stringNode = (SpecStringNode)node;
            String val = stringNode.field.get(object).toString();
            return new Element(Element.Type.String, stringNode.comment, name, val);
        }
        if (node instanceof SpecEnumNode) {
            SpecEnumNode enumNode = (SpecEnumNode)node;
            String val = enumNode.field.get(object).toString();
            return new Element(Element.Type.String, enumNode.comment, name, val);
        }
        if (node instanceof SpecNumberNode) {
            SpecNumberNode numberNode = (SpecNumberNode)node;
            Number num = (Number)numberNode.field.get(object);
            return new Element(Element.Type.Number, numberNode.comment, name, String.valueOf(num.doubleValue()));
        }
        if (node instanceof SpecBooleanNode) {
            SpecBooleanNode boolNode = (SpecBooleanNode)node;
            Boolean bool = (Boolean)boolNode.field.get(object);
            return new Element(Element.Type.Boolean, boolNode.comment, name, bool.toString());
        }
        throw new DefinitionError("Attempting to generate element for unknown node type");
    }

    public void writeElementTree(Element tree, boolean isReload) {
        try {
            ConfigSpec.writeElementNode(tree, this.masterNode, null, isReload);
        }
        catch (IllegalAccessException e) {
            ConfigManager.LOGGER.error("Unexpected error caught reading from config");
            e.printStackTrace();
            throw new DefinitionError(e.getMessage());
        }
    }

    public static void writeElementNode(Element element, SpecNode node, @Nullable Object object, boolean isReload) throws IllegalAccessException {
        if (isReload && !node.reloadable) {
            return;
        }
        if (node instanceof SpecClazzNode) {
            Element[] subElements;
            SpecClazzNode clazzNode = (SpecClazzNode)node;
            if (element.type != Element.Type.Section) {
                ConfigManager.LOGGER.info("Invalid config structure given");
                ConfigManager.LOGGER.info("Attempting to write " + element.type + " to a Class");
                return;
            }
            for (Element subElement : subElements = element.asArray()) {
                SpecClazzNode subClazzNode = clazzNode.clazzNodes.get(subElement.name);
                SpecFieldNode fieldNode = clazzNode.fieldNodes.get(subElement.name);
                if (subClazzNode != null) {
                    ConfigSpec.writeElementNode(subElement, subClazzNode, null, isReload);
                    continue;
                }
                if (fieldNode != null) {
                    ConfigSpec.writeElementNode(subElement, fieldNode, null, isReload);
                    continue;
                }
                Phosphophyllite.LOGGER.info("Unknown config option given: " + subElement.name);
            }
            return;
        }
        if (node instanceof SpecObjectNode) {
            Element[] subElements;
            SpecObjectNode objectNode = (SpecObjectNode)node;
            if (element.type != Element.Type.Section) {
                ConfigManager.LOGGER.info("Invalid config structure given");
                ConfigManager.LOGGER.info("Attempting to write " + element.type + " to an Object");
                return;
            }
            Object nodeObject = objectNode.field.get(object);
            boolean existingObject = true;
            if (nodeObject == null) {
                nodeObject = ConfigSpec.createClassInstance(objectNode.clazz);
                existingObject = false;
            }
            for (Element subElement : subElements = element.asArray()) {
                SpecFieldNode subNode = objectNode.subNodes.get(subElement.name);
                if (subNode != null) {
                    ConfigSpec.writeElementNode(subElement, subNode, nodeObject, isReload);
                    continue;
                }
                Phosphophyllite.LOGGER.info("Unknown config option given: " + element.name);
            }
            if (!existingObject) {
                objectNode.field.set(object, nodeObject);
            }
            return;
        }
        if (node instanceof SpecElementNode) {
            Element[] subElements;
            SpecElementNode elementNode = (SpecElementNode)node;
            if (element.type != Element.Type.Section) {
                ConfigManager.LOGGER.info("Invalid config structure given");
                ConfigManager.LOGGER.info("Attempting to write " + element.type + " to an Object");
                return;
            }
            for (Element subElement : subElements = element.asArray()) {
                SpecFieldNode subNode = elementNode.subNodes.get(subElement.name);
                if (subNode != null) {
                    ConfigSpec.writeElementNode(subElement, subNode, object, isReload);
                    continue;
                }
                Phosphophyllite.LOGGER.info("Unknown config option given: " + element.name);
            }
            return;
        }
        if (node instanceof SpecMapNode) {
            Element[] subElements;
            SpecMapNode mapNode = (SpecMapNode)node;
            if (element.type != Element.Type.Section) {
                ConfigManager.LOGGER.info("Invalid config structure given");
                ConfigManager.LOGGER.info("Attempting to write " + element.type + " to a Map");
                return;
            }
            Map map = (Map)ConfigSpec.createClassInstance(mapNode.field.getType());
            for (Element subElement : subElements = element.asArray()) {
                Object newElementObject = ConfigSpec.createClassInstance(mapNode.elementClass);
                map.put(subElement.name, newElementObject);
                ConfigSpec.writeElementNode(subElement, mapNode.nodeType, newElementObject, isReload);
            }
            mapNode.field.set(object, map);
            return;
        }
        if (node instanceof SpecListNode) {
            SpecListNode listNode = (SpecListNode)node;
            if (element.type != Element.Type.Array) {
                ConfigManager.LOGGER.info("Invalid config structure given");
                ConfigManager.LOGGER.info("Attempting to write " + element.type + " to an Array");
                return;
            }
            Element[] subElements = element.asArray();
            if (listNode.field.getType().isArray()) {
                Object array = Array.newInstance(listNode.elementClass, subElements.length);
                for (int i = 0; i < subElements.length; ++i) {
                    Object newElementObject = ConfigSpec.createClassInstance(listNode.elementClass);
                    Element subElement = subElements[i];
                    Array.set(array, i, newElementObject);
                    ConfigSpec.writeElementNode(subElement, listNode.subNodeType, newElementObject, isReload);
                }
                listNode.field.set(object, array);
            } else {
                List list = (List)ConfigSpec.createClassInstance(listNode.field.getType());
                for (Element subElement : subElements) {
                    Object newElementObject = ConfigSpec.createClassInstance(listNode.elementClass);
                    ConfigSpec.writeElementNode(subElement, listNode.subNodeType, newElementObject, isReload);
                    list.add(newElementObject);
                }
                listNode.field.set(object, list);
            }
            return;
        }
        if (node instanceof SpecStringNode) {
            SpecStringNode stringNode = (SpecStringNode)node;
            if (element.type != Element.Type.String && element.type != Element.Type.Number && element.type != Element.Type.Boolean) {
                ConfigManager.LOGGER.info("Invalid config structure given");
                ConfigManager.LOGGER.info("Attempting to write " + element.type + " to a String");
                return;
            }
            stringNode.field.set(object, element.asString());
            return;
        }
        if (node instanceof SpecEnumNode) {
            SpecEnumNode enumNode = (SpecEnumNode)node;
            if (element.type != Element.Type.String) {
                ConfigManager.LOGGER.info("Invalid config structure given");
                ConfigManager.LOGGER.info("Attempting to write " + element.type + " to a Enum");
                return;
            }
            Enum[] enumVals = (Enum[])enumNode.enumClass.getEnumConstants();
            String[] enumValStrings = new String[enumVals.length];
            for (int i = 0; i < enumVals.length; ++i) {
                enumValStrings[i] = enumVals[i].toString().toLowerCase(Locale.ENGLISH);
            }
            String nameGiven = element.asString().toLowerCase(Locale.ENGLISH);
            Enum givenVal = null;
            block7: for (int i = 0; i < enumValStrings.length; ++i) {
                if (!nameGiven.equals(enumValStrings[i])) continue;
                if (enumNode.allowedValues.isEmpty()) {
                    givenVal = enumVals[i];
                    break;
                }
                for (String allowedValue : enumNode.allowedValues) {
                    if (!nameGiven.equals(allowedValue.toLowerCase(Locale.ENGLISH))) continue;
                    givenVal = enumVals[i];
                    break block7;
                }
                break;
            }
            if (givenVal != null) {
                enumNode.field.set(object, givenVal);
            }
            return;
        }
        if (node instanceof SpecNumberNode) {
            SpecNumberNode numberNode = (SpecNumberNode)node;
            if (element.type != Element.Type.Number) {
                ConfigManager.LOGGER.info("Invalid config structure given");
                ConfigManager.LOGGER.info("Attempting to write " + element.type + " to a Number");
                return;
            }
            double val = element.asDouble();
            if (numberNode.integral) {
                long realVal = Math.round(val);
                if ((double)realVal < numberNode.lowerBound || (double)realVal > numberNode.upperBound || (double)realVal <= numberNode.lowerBound && !numberNode.lowerInclusive || (double)realVal >= numberNode.upperBound && !numberNode.upperInclusive) {
                    ConfigManager.LOGGER.warn("Number value " + element.name + " given out of range value " + realVal + ". Valid range is " + (String)(numberNode.lowerInclusive ? "[" : "(" + (Serializable)(numberNode.lowerBound == Double.MIN_VALUE ? "" : Double.valueOf(numberNode.lowerBound))) + "," + (Serializable)(numberNode.upperBound == Double.MAX_VALUE ? "" : Double.valueOf(numberNode.upperBound)) + (numberNode.upperInclusive ? "]" : ")") + ". Clamping to range");
                    if ((double)realVal <= numberNode.lowerBound) {
                        realVal = Math.round(numberNode.lowerBound);
                        if (!numberNode.lowerInclusive) {
                            ++realVal;
                        }
                    } else if ((double)realVal >= numberNode.upperBound) {
                        realVal = Math.round(numberNode.upperBound);
                        if (!numberNode.upperInclusive) {
                            --realVal;
                        }
                    }
                }
                val = realVal;
            } else if (val < numberNode.lowerBound || val > numberNode.upperBound || val <= numberNode.lowerBound && !numberNode.lowerInclusive || val >= numberNode.upperBound && !numberNode.upperInclusive) {
                ConfigManager.LOGGER.warn("Number value " + element.name + " given out of range value " + val + ". Valid range is " + (String)(numberNode.lowerInclusive ? "[" : "(" + (Serializable)(numberNode.lowerBound == Double.MIN_VALUE ? "" : Double.valueOf(numberNode.lowerBound))) + "," + (Serializable)(numberNode.upperBound == Double.MAX_VALUE ? "" : Double.valueOf(numberNode.upperBound)) + (numberNode.upperInclusive ? "]" : ")") + ". Clamping to range");
                if (val <= numberNode.lowerBound) {
                    val = numberNode.lowerBound;
                    if (!numberNode.lowerInclusive) {
                        val = Math.nextAfter(val, Double.POSITIVE_INFINITY);
                    }
                } else if (val >= numberNode.upperBound) {
                    val = numberNode.upperBound;
                    if (!numberNode.upperInclusive) {
                        val = Math.nextAfter(val, Double.NEGATIVE_INFINITY);
                    }
                }
            }
            ConfigSpec.setNumberField(numberNode.field, object, val);
            return;
        }
        if (node instanceof SpecBooleanNode) {
            boolean newVal;
            SpecBooleanNode booleanNode = (SpecBooleanNode)node;
            if (element.type != Element.Type.String && element.type != Element.Type.Number && element.type != Element.Type.Boolean) {
                ConfigManager.LOGGER.info("Invalid config structure given");
                ConfigManager.LOGGER.info("Attempting to write " + element.type + " to a Boolean");
                return;
            }
            if (element.type == Element.Type.String || element.type == Element.Type.Boolean) {
                String str = element.asString();
                newVal = Boolean.parseBoolean(str);
            } else {
                newVal = element.asDouble() != 0.0;
            }
            booleanNode.field.setBoolean(object, newVal);
            return;
        }
        ConfigManager.LOGGER.warn("Invalid config structure given");
        ConfigManager.LOGGER.warn("Attempting to write " + element.type + " to an unknown node type");
    }

    public void writeDefaults() {
        try {
            ConfigSpec.defaultNode(this.masterNode, null);
        }
        catch (IllegalAccessException e) {
            Phosphophyllite.LOGGER.error("Error caught writing defaults to config");
            Phosphophyllite.LOGGER.error(e.toString());
        }
    }

    public static void defaultNode(SpecNode node, @Nullable Object object) throws IllegalAccessException {
        if (node instanceof SpecClazzNode) {
            SpecClazzNode clazzNode = (SpecClazzNode)node;
            for (Map.Entry<String, SpecClazzNode> entry : clazzNode.clazzNodes.entrySet()) {
                ConfigSpec.defaultNode(entry.getValue(), null);
            }
            for (Map.Entry<String, SpecNode> entry : clazzNode.fieldNodes.entrySet()) {
                ConfigSpec.defaultNode(entry.getValue(), null);
            }
        } else if (node instanceof SpecObjectNode) {
            SpecObjectNode objectNode = (SpecObjectNode)node;
            Object newObject = ConfigSpec.createClassInstance(objectNode.clazz);
            for (Map.Entry<String, SpecFieldNode> entry : objectNode.subNodes.entrySet()) {
                ConfigSpec.defaultNode(entry.getValue(), newObject);
            }
            objectNode.field.set(object, newObject);
        } else if (node instanceof SpecElementNode) {
            SpecElementNode elementNode = (SpecElementNode)node;
            if (object == null) {
                return;
            }
            for (Map.Entry<String, SpecFieldNode> entry : elementNode.subNodes.entrySet()) {
                ConfigSpec.defaultNode(entry.getValue(), object);
            }
        } else if (node instanceof SpecMapNode) {
            SpecMapNode mapNode = (SpecMapNode)node;
            LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, SpecElementNode> entry : mapNode.defaultSubNodes.entrySet()) {
                Object obj = ConfigSpec.createClassInstance(mapNode.elementClass);
                ConfigSpec.defaultNode(entry.getValue(), obj);
                newMap.put(entry.getKey(), obj);
            }
            mapNode.field.set(object, newMap);
        } else if (node instanceof SpecListNode) {
            SpecListNode listNode = (SpecListNode)node;
            ArrayList<Object> newList = new ArrayList<Object>();
            for (SpecElementNode defaultSubNode : listNode.defaultSubNodes) {
                Object obj = ConfigSpec.createClassInstance(listNode.elementClass);
                ConfigSpec.defaultNode(defaultSubNode, obj);
                newList.add(obj);
            }
            listNode.field.set(object, newList);
        } else if (node instanceof SpecStringNode) {
            SpecStringNode stringNode = (SpecStringNode)node;
            stringNode.field.set(object, stringNode.defaultString);
        } else if (node instanceof SpecEnumNode) {
            SpecEnumNode enumNode = (SpecEnumNode)node;
            Object enumVal = Enum.valueOf(enumNode.enumClass, enumNode.defaultValue);
            enumNode.field.set(object, enumVal);
        } else if (node instanceof SpecNumberNode) {
            SpecNumberNode numberNode = (SpecNumberNode)node;
            ConfigSpec.setNumberField(numberNode.field, object, numberNode.defaultValue);
        } else if (node instanceof SpecBooleanNode) {
            SpecBooleanNode boolNode = (SpecBooleanNode)node;
            boolNode.field.setBoolean(object, boolNode.defaultValue);
        }
    }

    public static boolean isIntegral(Class<?> numberType) {
        return numberType == Byte.class || numberType == Byte.TYPE || numberType == Short.class || numberType == Short.TYPE || numberType == Integer.class || numberType == Integer.TYPE || numberType == Long.class || numberType == Long.TYPE;
    }

    public static void setNumberField(Field field, @Nullable Object object, double value) throws IllegalAccessException {
        Class<?> numberType = field.getType();
        Number newVal = numberType == Byte.TYPE || numberType == Byte.TYPE ? (Number)((byte)value) : (Number)(numberType == Short.TYPE || numberType == Short.TYPE ? (Number)((short)value) : (Number)(numberType == Integer.TYPE || numberType == Integer.TYPE ? (Number)((int)value) : (Number)(numberType == Long.TYPE || numberType == Long.TYPE ? (Number)((long)value) : (Number)(numberType == Float.TYPE || numberType == Float.TYPE ? (Number)Float.valueOf((float)value) : (Number)(numberType == Double.TYPE || numberType == Double.TYPE ? Double.valueOf(value) : null)))));
        field.set(object, newVal);
    }

    @Nullable
    public static SpecClazzNode buildNodeForClazz(Class<?> clazz, @Nullable String comment, boolean advanced, boolean hidden) {
        String name;
        LinkedHashMap<String, SpecClazzNode> clazzNodes = new LinkedHashMap<String, SpecClazzNode>();
        LinkedHashMap<String, SpecFieldNode> fieldNodes = new LinkedHashMap<String, SpecFieldNode>();
        for (Class<?> clazz2 : clazz.getDeclaredClasses()) {
            SpecClazzNode subNode = ConfigSpec.buildNodeForClazz(clazz2, null, advanced, hidden);
            if (subNode == null) continue;
            name = clazz2.getSimpleName();
            if (clazzNodes.containsKey(name)) {
                throw new DefinitionError("Duplicate config name: " + name);
            }
            clazzNodes.put(name, subNode);
        }
        for (AnnotatedElement annotatedElement : clazz.getDeclaredFields()) {
            SpecFieldNode fieldNode;
            if (!Modifier.isStatic(((Field)annotatedElement).getModifiers()) || (fieldNode = ConfigSpec.buildNodeForField((Field)annotatedElement, null)) == null) continue;
            name = ((Field)annotatedElement).getName();
            if (clazzNodes.containsKey(name)) {
                throw new DefinitionError("Duplicate config name: " + name);
            }
            if (fieldNodes.containsKey(name)) {
                throw new DefinitionError("Duplicate config name: " + name);
            }
            fieldNodes.put(name, fieldNode);
        }
        if (clazzNodes.isEmpty() && fieldNodes.isEmpty()) {
            return null;
        }
        return new SpecClazzNode(clazz, clazzNodes, fieldNodes, comment, advanced, hidden, true);
    }

    @Nullable
    public static SpecObjectNode buildNodeForObject(Class<?> clazz, Object object, Field field, @Nullable String comment, boolean advanced, boolean hidden, boolean reloadable) {
        LinkedHashMap<String, SpecFieldNode> subNodes = new LinkedHashMap<String, SpecFieldNode>();
        for (Field clazzField : clazz.getDeclaredFields()) {
            SpecFieldNode fieldNode;
            if (Modifier.isStatic(clazzField.getModifiers()) || (fieldNode = ConfigSpec.buildNodeForField(clazzField, object)) == null) continue;
            String name = clazzField.getName();
            if (subNodes.containsKey(name)) {
                throw new DefinitionError("Duplicate config name: " + name);
            }
            subNodes.put(name, fieldNode);
        }
        if (subNodes.isEmpty()) {
            return null;
        }
        return new SpecObjectNode(clazz, subNodes, field, comment, advanced, hidden, reloadable);
    }

    @Nullable
    private static SpecElementNode buildNodeForElement(Class<?> clazz, Object object, boolean advanced, boolean hidden, boolean reloadable) {
        LinkedHashMap<String, SpecFieldNode> subNodes = new LinkedHashMap<String, SpecFieldNode>();
        for (Field clazzField : clazz.getDeclaredFields()) {
            SpecFieldNode fieldNode;
            if (Modifier.isStatic(clazzField.getModifiers()) || (fieldNode = ConfigSpec.buildNodeForField(clazzField, object)) == null) continue;
            String name = clazzField.getName();
            if (subNodes.containsKey(name)) {
                throw new DefinitionError("Duplicate config name: " + name);
            }
            subNodes.put(name, fieldNode);
        }
        if (subNodes.isEmpty()) {
            return null;
        }
        return new SpecElementNode(clazz, subNodes, advanced, hidden, reloadable);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static SpecFieldNode buildNodeForField(Field field, @Nullable Object object) {
        void var7_16;
        Object fieldObject;
        if (!field.isAnnotationPresent(ConfigValue.class)) {
            return null;
        }
        field.setAccessible(true);
        Class<?> fieldClass = field.getType();
        if (Modifier.isStatic(field.getModifiers()) == (object == null)) {
            try {
                fieldObject = field.get(object);
            }
            catch (IllegalAccessException e) {
                Phosphophyllite.LOGGER.warn("Illegal Access attempting to get field");
                Phosphophyllite.LOGGER.warn(e.getMessage());
                return null;
            }
        }
        try {
            Constructor<?> constructor = fieldClass.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            fieldObject = constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Phosphophyllite.LOGGER.warn(e.getMessage());
            throw new DefinitionError("Unable to create default instance of field object");
        }
        ConfigValue fieldAnnotation = field.getAnnotation(ConfigValue.class);
        boolean reloadable = fieldAnnotation.reloadable();
        StringBuilder stringBuilder = new StringBuilder(fieldAnnotation.comment());
        if (!fieldAnnotation.range().equals("(,)")) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append("Valid range: ").append(fieldAnnotation.range());
        }
        if (fieldAnnotation.commentDefaultValue() && (fieldClass.isPrimitive() || Number.class.isAssignableFrom(fieldClass) || Boolean.class == fieldClass || String.class == fieldClass || fieldClass.isEnum())) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append("Default: ");
            stringBuilder.append(fieldObject.toString());
        }
        if (fieldClass.isEnum()) {
            String[] allowedValues = fieldAnnotation.allowedValues();
            if (allowedValues.length == 0) {
                Object[] enumFields = fieldClass.getFields();
                allowedValues = new String[enumFields.length];
                for (int i = 0; i < enumFields.length; ++i) {
                    allowedValues[i] = ((Field)enumFields[i]).getName();
                }
            }
            if (stringBuilder.length() != 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append("Allowed Values: ");
            for (String allowedValue : allowedValues) {
                stringBuilder.append(allowedValue);
                stringBuilder.append(", ");
            }
        }
        String comment = stringBuilder.toString();
        boolean advanced = fieldAnnotation.advanced();
        boolean hidden = fieldAnnotation.hidden();
        if (fieldClass.isArray() || List.class == fieldClass || ArrayList.class == fieldClass) {
            Class elementClass;
            ArrayList<SpecElementNode> defaultSubNodes = new ArrayList<SpecElementNode>();
            if (fieldClass.isArray()) {
                elementClass = fieldClass.getComponentType();
                for (int i = 0; i < Array.getLength(fieldObject); ++i) {
                    SpecElementNode subNode;
                    Object element2 = Array.get(fieldObject, 0);
                    if (element2 == null || (subNode = ConfigSpec.buildNodeForElement(elementClass, element2, advanced, hidden, reloadable)) == null) continue;
                    defaultSubNodes.add(subNode);
                }
            } else {
                ParameterizedType type = (ParameterizedType)field.getGenericType();
                Type[] generics = type.getActualTypeArguments();
                elementClass = (Class)generics[0];
                List list = (List)fieldObject;
                list.forEach(element -> {
                    SpecElementNode subNode = ConfigSpec.buildNodeForElement(elementClass, element, advanced, hidden, reloadable);
                    if (subNode != null) {
                        defaultSubNodes.add(subNode);
                    }
                });
            }
            Object defaultObject = ConfigSpec.createClassInstance(elementClass);
            SpecElementNode defaultNode = ConfigSpec.buildNodeForElement(elementClass, defaultObject, advanced, hidden, reloadable);
            if (defaultNode == null) {
                return null;
            }
            SpecListNode specListNode = new SpecListNode(elementClass, defaultNode, defaultSubNodes, field, comment, advanced, hidden, reloadable);
            return var7_16;
        } else if (Map.class == fieldClass || HashMap.class == fieldClass) {
            ParameterizedType type = (ParameterizedType)field.getGenericType();
            Type[] generics = type.getActualTypeArguments();
            if (generics[0] != String.class) {
                throw new RuntimeException("map keys must be strings");
            }
            Class elementClass = (Class)generics[1];
            LinkedHashMap<String, SpecElementNode> defaultSubNodes = new LinkedHashMap<String, SpecElementNode>();
            Object defaultObject = ConfigSpec.createClassInstance(elementClass);
            SpecElementNode defaultNode = ConfigSpec.buildNodeForElement(elementClass, defaultObject, advanced, hidden, reloadable);
            if (defaultNode == null) {
                return null;
            }
            Map map = (Map)fieldObject;
            map.forEach((string, element) -> {
                SpecElementNode newNode = ConfigSpec.buildNodeForElement(elementClass, element, advanced, hidden, reloadable);
                if (newNode != null) {
                    defaultSubNodes.put((String)string, newNode);
                }
            });
            SpecMapNode specMapNode = new SpecMapNode(elementClass, defaultNode, defaultSubNodes, field, comment, advanced, hidden, reloadable);
            return var7_16;
        } else if (String.class == fieldClass) {
            SpecStringNode specStringNode = new SpecStringNode((String)fieldObject, field, comment, hidden, advanced, reloadable);
            return var7_16;
        } else if (fieldClass.isEnum()) {
            SpecEnumNode specEnumNode = new SpecEnumNode(fieldClass, fieldObject.toString(), Arrays.asList(fieldAnnotation.allowedValues()), field, comment, advanced, hidden, reloadable);
            return var7_16;
        } else if (fieldClass.isPrimitive() || Number.class.isAssignableFrom(fieldClass) || Boolean.class == fieldClass) {
            if (fieldClass == Boolean.TYPE || fieldClass == Boolean.class) {
                SpecBooleanNode specBooleanNode = new SpecBooleanNode((Boolean)fieldObject, field, comment, advanced, hidden, reloadable);
                return var7_16;
            } else {
                String range = fieldAnnotation.range();
                if ((range = range.trim()).length() < 3) {
                    throw new DefinitionError("Incomplete range given");
                }
                char lowerInclusiveChar = range.charAt(0);
                char higherInclusiveChar = range.charAt(range.length() - 1);
                boolean lowerInclusive = switch (lowerInclusiveChar) {
                    case '(' -> false;
                    case '[' -> true;
                    default -> throw new DefinitionError("Unknown lower bound inclusivity");
                };
                boolean higherInclusive = switch (higherInclusiveChar) {
                    case ')' -> false;
                    case ']' -> true;
                    default -> throw new DefinitionError("Unknown higher bound inclusivity");
                };
                range = range.substring(1, range.length() - 1).trim();
                String[] bounds = range.split(",");
                if (bounds.length > 2) {
                    throw new DefinitionError("Range cannot have more than two bounds");
                }
                String lowerBoundStr = "";
                String higherBoundStr = "";
                if (bounds.length == 2) {
                    lowerBoundStr = bounds[0].trim();
                    higherBoundStr = bounds[1].trim();
                } else {
                    if (range.length() == 0) {
                        throw new DefinitionError("Incomplete range given");
                    }
                    if (range.length() != 1) {
                        if (bounds.length != 1) {
                            throw new DefinitionError("Incomplete range given");
                        }
                        if (range.charAt(0) == ',') {
                            higherBoundStr = bounds[0];
                        } else {
                            if (range.charAt(range.length() - 1) != ',') throw new DefinitionError("Incomplete range given");
                            lowerBoundStr = bounds[0];
                        }
                    } else if (range.charAt(0) != ',') {
                        throw new DefinitionError("Incomplete range given");
                    }
                }
                double lowerBound = Double.MIN_VALUE;
                if (lowerBoundStr.length() != 0) {
                    lowerBound = Double.parseDouble(lowerBoundStr);
                }
                double higherBound = Double.MAX_VALUE;
                if (higherBoundStr.length() != 0) {
                    higherBound = Double.parseDouble(higherBoundStr);
                }
                if (lowerBound > higherBound) {
                    throw new DefinitionError("Higher bound must be greater or equal to lower bound");
                }
                SpecNumberNode specNumberNode = new SpecNumberNode(ConfigSpec.isIntegral(fieldClass), lowerInclusive, lowerBound, higherInclusive, higherBound, ((Number)fieldObject).doubleValue(), field, comment, advanced, hidden, reloadable);
            }
            return var7_16;
        } else {
            SpecObjectNode specObjectNode = ConfigSpec.buildNodeForObject(fieldClass, fieldObject, field, comment, advanced, hidden, reloadable);
        }
        return var7_16;
    }

    public static Object createClassInstance(Class<?> elementClass) {
        try {
            Constructor<?> constructor = elementClass.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Phosphophyllite.LOGGER.warn(e.getMessage());
            throw new DefinitionError("Unable to create default instance of object");
        }
    }

    public static class SpecObjectNode
    extends SpecFieldNode {
        public final Class<?> clazz;
        public final Map<String, SpecFieldNode> subNodes;

        private SpecObjectNode(Class<?> clazz, Map<String, SpecFieldNode> subNodes, Field field, @Nullable String comment, boolean advanced, boolean hidden, boolean reloadable) {
            super(field, comment, advanced, hidden, reloadable);
            this.clazz = clazz;
            this.subNodes = Collections.unmodifiableMap(subNodes);
        }
    }

    public static abstract class SpecNode {
        @Nullable
        public final String comment;
        public final boolean advanced;
        public final boolean hidden;
        public final boolean reloadable;

        private SpecNode(@Nullable String comment, boolean advanced, boolean hidden, boolean reloadable) {
            this.comment = comment;
            this.advanced = advanced;
            this.hidden = hidden;
            this.reloadable = reloadable;
        }
    }

    public static class SpecClazzNode
    extends SpecNode {
        public final Class<?> clazz;
        public final Map<String, SpecClazzNode> clazzNodes;
        public final Map<String, SpecFieldNode> fieldNodes;

        private SpecClazzNode(Class<?> clazz, Map<String, SpecClazzNode> clazzNodes, Map<String, SpecFieldNode> fieldNodes, @Nullable String comment, boolean advanced, boolean hidden, boolean reloadable) {
            super(comment, advanced, hidden, reloadable);
            this.clazz = clazz;
            this.clazzNodes = Collections.unmodifiableMap(clazzNodes);
            this.fieldNodes = Collections.unmodifiableMap(fieldNodes);
        }
    }

    public static class SpecFieldNode
    extends SpecNode {
        @Nonnull
        public final Field field;

        private SpecFieldNode(Field field, @Nullable String comment, boolean advanced, boolean hidden, boolean reloadable) {
            super(comment, advanced, hidden, reloadable);
            this.field = field;
        }
    }

    public static class SpecElementNode
    extends SpecNode {
        public final Class<?> clazz;
        public final Map<String, SpecFieldNode> subNodes;

        private SpecElementNode(Class<?> clazz, Map<String, SpecFieldNode> subNodes, boolean advanced, boolean hidden, boolean reloadable) {
            super(null, advanced, hidden, reloadable);
            this.clazz = clazz;
            this.subNodes = Collections.unmodifiableMap(subNodes);
        }
    }

    public static class SpecMapNode
    extends SpecFieldNode {
        public final Class<?> elementClass;
        public final SpecElementNode nodeType;
        public final Map<String, SpecElementNode> defaultSubNodes;

        private SpecMapNode(Class<?> elementClass, SpecElementNode nodeType, Map<String, SpecElementNode> defaultSubNodes, Field field, @Nullable String comment, boolean advanced, boolean hidden, boolean reloadable) {
            super(field, comment, advanced, hidden, reloadable);
            this.elementClass = elementClass;
            this.nodeType = nodeType;
            this.defaultSubNodes = Collections.unmodifiableMap(defaultSubNodes);
        }
    }

    public static class SpecListNode
    extends SpecFieldNode {
        public final Class<?> elementClass;
        public final SpecElementNode subNodeType;
        public final List<SpecElementNode> defaultSubNodes;

        private SpecListNode(Class<?> elementClass, SpecElementNode subNodeType, List<SpecElementNode> defaultSubNodes, Field field, @Nullable String comment, boolean advanced, boolean hidden, boolean reloadable) {
            super(field, comment, advanced, hidden, reloadable);
            this.elementClass = elementClass;
            this.subNodeType = subNodeType;
            this.defaultSubNodes = Collections.unmodifiableList(defaultSubNodes);
        }
    }

    public static class SpecStringNode
    extends SpecFieldNode {
        public final String defaultString;

        private SpecStringNode(String defaultString, Field field, @Nullable String comment, boolean advanced, boolean hidden, boolean reloadable) {
            super(field, comment, advanced, hidden, reloadable);
            this.defaultString = defaultString;
        }
    }

    public static class SpecEnumNode
    extends SpecFieldNode {
        public final Class<?> enumClass;
        public final String defaultValue;
        public final List<String> allowedValues;

        private SpecEnumNode(Class<?> enumClass, String defaultValue, List<String> allowedValues, Field field, @Nullable String comment, boolean advanced, boolean hidden, boolean reloadable) {
            super(field, comment, advanced, hidden, reloadable);
            this.enumClass = enumClass;
            this.defaultValue = defaultValue;
            this.allowedValues = Collections.unmodifiableList(allowedValues);
        }
    }

    public static class SpecNumberNode
    extends SpecFieldNode {
        public final boolean integral;
        public final boolean lowerInclusive;
        public final double lowerBound;
        public final boolean upperInclusive;
        public final double upperBound;
        public final double defaultValue;

        private SpecNumberNode(boolean integral, boolean lowerInclusive, double lowerBound, boolean upperInclusive, double upperBound, double defaultValue, Field field, String comment, boolean advanced, boolean hidden, boolean reloadable) {
            super(field, comment, advanced, hidden, reloadable);
            this.integral = integral;
            this.lowerInclusive = lowerInclusive;
            this.lowerBound = lowerBound;
            this.upperInclusive = upperInclusive;
            this.upperBound = upperBound;
            this.defaultValue = defaultValue;
        }
    }

    public static class SpecBooleanNode
    extends SpecFieldNode {
        public final boolean defaultValue;

        private SpecBooleanNode(boolean defaultValue, Field field, String comment, boolean advanced, boolean hidden, boolean reloadable) {
            super(field, comment, advanced, hidden, reloadable);
            this.defaultValue = defaultValue;
        }
    }

    public static class DefinitionError
    extends RuntimeException {
        public DefinitionError(String message) {
            super(message);
        }
    }
}

