/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.config;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.roguelogix.phosphophyllite.config.ConfigFormat;
import net.roguelogix.phosphophyllite.config.ConfigSpec;
import net.roguelogix.phosphophyllite.config.ConfigType;
import net.roguelogix.phosphophyllite.config.ConfigValue;
import net.roguelogix.phosphophyllite.parsers.Element;
import net.roguelogix.phosphophyllite.parsers.JSON5;
import net.roguelogix.phosphophyllite.parsers.TOML;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.registry.RegisterConfig;
import net.roguelogix.phosphophyllite.robn.ROBN;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ConfigManager {
    static final Logger LOGGER = LogManager.getLogger((String)"Phosphophyllite/Config");
    private static final Object2ObjectOpenHashMap<String, ModConfig> modConfigs = new Object2ObjectOpenHashMap();
    private static final ObjectArrayList<ServerPlayer> players = new ObjectArrayList();
    private static final String PROTOCOL_VERSION = "0";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("phosphophyllite", "phosphophyllite/configsync"), () -> "0", "0"::equals, "0"::equals);

    public static void registerConfig(Field field, String modName) {
        if (!field.isAnnotationPresent(RegisterConfig.class)) {
            throw new IllegalArgumentException("Field must be annotated with @RegisterConfig");
        }
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("Base config object must be static");
        }
        RegisterConfig annotation = field.getAnnotation(RegisterConfig.class);
        if (!annotation.name().equals("")) {
            modName = annotation.name();
        }
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER && annotation.type() == ConfigType.CLIENT) {
            return;
        }
        ModConfig config = new ModConfig(field, modName);
        modConfigs.put((Object)config.baseFile.toString(), (Object)config);
        config.load();
    }

    void reloadConfigs() {
        for (ModConfig value : modConfigs.values()) {
            value.reload();
        }
        for (ServerPlayer player : players) {
            ConfigManager.sendConfigToPlayer(player, false);
        }
    }

    @OnModLoad
    private static void onModLoad() {
        INSTANCE.registerMessage(1, ByteArrayPacketMessage.class, ByteArrayPacketMessage::encodePacket, ByteArrayPacketMessage::decodePacket, ConfigManager::packetHandler);
        MinecraftForge.EVENT_BUS.addListener(ConfigManager::onPlayerLogin);
        MinecraftForge.EVENT_BUS.addListener(ConfigManager::onPlayerLogout);
    }

    private static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        MinecraftServer server = e.getPlayer().m_20194_();
        assert (server != null);
        if (!server.m_6982_()) {
            UUID serverUUID = e.getPlayer().m_142081_();
            String localUUID = Minecraft.m_91087_().m_91094_().m_92545_();
            if (serverUUID.toString().equals(localUUID)) {
                for (ModConfig value : modConfigs.values()) {
                    value.reloadSavedTree();
                }
                return;
            }
        }
        ServerPlayer player = (ServerPlayer)e.getPlayer();
        players.add((Object)player);
        ConfigManager.sendConfigToPlayer(player, true);
    }

    private static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent e) {
        ServerPlayer player = (ServerPlayer)e.getPlayer();
        players.remove((Object)player);
    }

    private static void sendConfigToPlayer(ServerPlayer player, boolean initialLogin) {
        Object2ObjectOpenHashMap configs = new Object2ObjectOpenHashMap();
        for (ModConfig modConfig : modConfigs.values()) {
            Element configTree;
            ArrayList<Byte> configROBN;
            if (modConfig.type != ConfigType.COMMON || (configROBN = net.roguelogix.phosphophyllite.parsers.ROBN.parseElement(configTree = modConfig.spec.generateElementTree(true, true))) == null) continue;
            configs.put((Object)modConfig.baseFile.toString(), configROBN);
        }
        ArrayList<Byte> robn = ROBN.toROBN(new Pair((Object)initialLogin, (Object)configs));
        byte[] bytes = new byte[robn.size()];
        for (int i = 0; i < robn.size(); ++i) {
            bytes[i] = robn.get(i);
        }
        INSTANCE.sendTo((Object)new ByteArrayPacketMessage(bytes), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    private static void packetHandler(@Nonnull ByteArrayPacketMessage packet, @Nonnull Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().setPacketHandled(true);
            return;
        }
        ctx.get().enqueueWork(() -> {
            try {
                ArrayList<Byte> buf = new ArrayList<Byte>();
                for (byte aByte : packet.bytes) {
                    buf.add(aByte);
                }
                Pair pair = (Pair)ROBN.fromROBN(buf);
                boolean initialLogin = (Boolean)pair.getFirst();
                Map configs = (Map)pair.getSecond();
                for (Map.Entry entry : configs.entrySet()) {
                    String configName = (String)entry.getKey();
                    ModConfig config = (ModConfig)modConfigs.get((Object)configName);
                    if (config == null) {
                        return;
                    }
                    try {
                        Element elementTree = net.roguelogix.phosphophyllite.parsers.ROBN.parseROBN((ArrayList)entry.getValue());
                        config.loadServerTree(elementTree, initialLogin);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static class ModConfig {
        private final Object configObject;
        private final Class<?> configClazz;
        final RegisterConfig annotation;
        final ConfigType type;
        private final String modName;
        File baseFile;
        File actualFile = null;
        ConfigFormat actualFormat;
        Element savedTree;
        private final ConfigSpec spec;
        private Field enableAdvanced;
        private final HashSet<Method> registrations = new HashSet();
        private final HashSet<Method> preLoads = new HashSet();
        private final HashSet<Method> postLoads = new HashSet();

        ModConfig(Field field, String name) {
            try {
                this.configObject = field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
            this.configClazz = field.getType();
            this.modName = name;
            this.annotation = field.getAnnotation(RegisterConfig.class);
            this.type = this.annotation.type();
            this.spec = new ConfigSpec(field, this.configObject);
            this.baseFile = new File("config/" + this.annotation.folder() + "/" + name + "-" + this.annotation.type().toString().toLowerCase(Locale.US));
            this.loadReflections();
            this.runRegistrations();
        }

        boolean enableAdvanced() {
            if (this.enableAdvanced == null) {
                return false;
            }
            try {
                return this.enableAdvanced.getBoolean(this.configObject);
            }
            catch (IllegalAccessException ignored) {
                return false;
            }
        }

        void loadReflections() {
            for (Field field : this.configClazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(ConfigValue.class) || !field.getAnnotation(ConfigValue.class).enableAdvanced()) continue;
                this.enableAdvanced = field;
                this.enableAdvanced.setAccessible(true);
                Class<?> EAClass = this.enableAdvanced.getType();
                if (EAClass == Boolean.TYPE || EAClass == Boolean.class) break;
                throw new ConfigSpec.DefinitionError("Advanced enable flag must be a boolean");
            }
            for (AccessibleObject accessibleObject : this.configClazz.getDeclaredMethods()) {
                if (((Method)accessibleObject).getReturnType() != Void.TYPE || ((Method)accessibleObject).getParameterCount() != 0 || !Modifier.isStatic(((Method)accessibleObject).getModifiers())) continue;
                if (accessibleObject.isAnnotationPresent(RegisterConfig.Registration.class)) {
                    ((Method)accessibleObject).setAccessible(true);
                    this.registrations.add((Method)accessibleObject);
                }
                if (accessibleObject.isAnnotationPresent(RegisterConfig.PreLoad.class)) {
                    ((Method)accessibleObject).setAccessible(true);
                    this.preLoads.add((Method)accessibleObject);
                }
                if (!accessibleObject.isAnnotationPresent(RegisterConfig.PostLoad.class)) continue;
                ((Method)accessibleObject).setAccessible(true);
                this.postLoads.add((Method)accessibleObject);
            }
        }

        void runPreLoads() {
            for (Method preLoad : this.preLoads) {
                try {
                    preLoad.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }

        void runRegistrations() {
            for (Method load : this.registrations) {
                try {
                    load.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }

        void runPostLoads() {
            for (Method postLoad : this.postLoads) {
                try {
                    postLoad.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }

        public void reload() {
            this.load(true);
        }

        void load() {
            this.load(false);
        }

        private void load(boolean isReload) {
            if (this.actualFile == null) {
                this.findFile();
            }
            if (!this.actualFile.exists()) {
                this.generateFile();
                this.runPreLoads();
                this.runPostLoads();
                return;
            }
            Element tree = this.readFile();
            if (tree == null) {
                LOGGER.error("No config data for " + this.modName + " loaded, leaving defaults");
                this.runPreLoads();
                this.runPostLoads();
                return;
            }
            this.loadElementTree(tree, isReload);
            tree = this.spec.trimAndRegenerateTree(tree, this.enableAdvanced());
            this.writeFile(tree);
        }

        void findFile() {
            File file = null;
            ConfigFormat format = null;
            for (ConfigFormat value : ConfigFormat.values()) {
                File fullFile = new File(this.baseFile + "." + value.toString().toLowerCase(Locale.US));
                if (!fullFile.exists()) continue;
                if (file != null) {
                    if (this.annotation.format() != value) continue;
                    file = fullFile;
                    format = value;
                    continue;
                }
                format = value;
                file = fullFile;
            }
            if (file == null) {
                file = new File(this.baseFile + "." + this.annotation.format().toString().toLowerCase(Locale.US));
                format = this.annotation.format();
            }
            this.actualFile = file;
            this.actualFormat = format;
        }

        void generateFile() {
            this.spec.writeDefaults();
            this.writeFile(this.spec.trimElementTree(this.spec.generateElementTree(false)));
        }

        void writeFile(@Nullable Element tree) {
            if (tree == null) {
                Path path = Paths.get(String.valueOf(this.actualFile), new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
            String str = switch (this.actualFormat) {
                default -> throw new IncompatibleClassChangeError();
                case ConfigFormat.JSON5 -> JSON5.parseElement(tree);
                case ConfigFormat.TOML -> TOML.parseElement(tree);
            };
            try {
                this.actualFile.getParentFile().mkdirs();
                Files.write(Paths.get(String.valueOf(this.actualFile), new String[0]), str.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                LOGGER.error("Failed to write config file for " + this.modName);
                e.printStackTrace();
            }
        }

        @Nullable
        Element readFile() {
            Element element;
            String str;
            try {
                str = new String(Files.readAllBytes(Paths.get(String.valueOf(this.actualFile), new String[0])));
            }
            catch (IOException e) {
                LOGGER.error("Failed to read config file for " + this.modName);
                return null;
            }
            switch (this.actualFormat) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case JSON5: {
                    Element element2 = JSON5.parseString(str);
                    break;
                }
                case TOML: {
                    Element element2 = element = TOML.parseString(str);
                }
            }
            if (element == null) {
                LOGGER.error("Failed to parse config for " + this.modName);
            }
            return element;
        }

        public void reloadSavedTree() {
            if (this.savedTree == null) {
                return;
            }
            this.loadElementTree(this.savedTree, true);
            this.savedTree = null;
        }

        public void loadServerTree(@Nullable Element tree, boolean initialLogin) {
            if (tree == null) {
                return;
            }
            this.savedTree = this.spec.generateElementTree(true, true);
            this.loadElementTree(tree, !initialLogin);
        }

        public void loadElementTree(Element tree, boolean isReload) {
            this.runPreLoads();
            this.spec.writeElementTree(tree, isReload);
            this.runPostLoads();
        }
    }

    private static class ByteArrayPacketMessage {
        public byte[] bytes;

        public ByteArrayPacketMessage() {
        }

        public ByteArrayPacketMessage(@Nonnull byte[] readByteArray) {
            this.bytes = readByteArray;
        }

        private static void encodePacket(@Nonnull ByteArrayPacketMessage packet, @Nonnull FriendlyByteBuf buf) {
            buf.writeBytes(packet.bytes);
        }

        private static ByteArrayPacketMessage decodePacket(@Nonnull FriendlyByteBuf buf) {
            byte[] byteBuf = new byte[buf.readableBytes()];
            buf.readBytes(byteBuf);
            return new ByteArrayPacketMessage(byteBuf);
        }
    }
}

