/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.client.gui;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.EmptyFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderHelper {
    private static ResourceLocation currentResource;
    public static String[] unitPrefixes;

    public static ResourceLocation getBlankTextureResource() {
        return new ResourceLocation("phosphophyllite", "textures/blank.png");
    }

    public static ResourceLocation getCurrentResource() {
        return currentResource;
    }

    public static void clearRenderColor() {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void setRenderColor(int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderHelper.setRenderColor(red, green, blue, alpha);
    }

    public static void setRenderColor(float red, float green, float blue, float alpha) {
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void bindTexture(ResourceLocation resourceLocation) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)resourceLocation);
        currentResource = resourceLocation;
    }

    public static void drawTexture(@Nonnull PoseStack poseStack, int x, int y, int blitOffset, int width, int height, TextureAtlasSprite sprite) {
        GuiComponent.m_93200_((PoseStack)poseStack, (int)x, (int)y, (int)blitOffset, (int)width, (int)height, (TextureAtlasSprite)sprite);
    }

    public static void drawFluid(@Nonnull PoseStack poseStack, int x, int y, int blitOffset, int width, int height, Fluid fluid) {
        ResourceLocation preservedResource = RenderHelper.getCurrentResource();
        RenderHelper.bindTexture(InventoryMenu.f_39692_);
        RenderHelper.setRenderColor(fluid.getAttributes().getColor());
        RenderHelper.drawTexture(poseStack, x, y, blitOffset, width, height, (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluid.getAttributes().getStillTexture()));
        RenderHelper.clearRenderColor();
        RenderHelper.bindTexture(preservedResource);
    }

    public static void drawTextureGrid(@Nonnull PoseStack poseStack, int x, int y, int blitOffset, int width, int height, TextureAtlasSprite sprite, int horizontalRepeat, int verticalRepeat) {
        for (int iX = 0; iX < horizontalRepeat; ++iX) {
            for (int iY = 0; iY < verticalRepeat; ++iY) {
                RenderHelper.drawTexture(poseStack, x + width * iX, y + height * iY, blitOffset, width, height, sprite);
            }
        }
    }

    public static void drawFluidGrid(@Nonnull PoseStack poseStack, int x, int y, int blitOffset, int width, int height, Fluid fluid, int xRepeat, int yRepeat) {
        for (int iX = 0; iX < xRepeat; ++iX) {
            for (int iY = 0; iY < yRepeat; ++iY) {
                RenderHelper.drawFluid(poseStack, x + width * iX, y + height * iY, blitOffset, width, height, fluid);
            }
        }
    }

    public static void drawMaskedFluid(@Nonnull PoseStack poseStack, int x, int y, int blitOffset, int width, int height, int u, int v, Fluid fluid) {
        if (!(fluid instanceof EmptyFluid)) {
            RenderHelper.drawFluid(poseStack, x, y, blitOffset, width, height, fluid);
        }
        GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)u, (float)v, (int)width, (int)height, (int)256, (int)256);
    }

    public static void drawMaskedFluidGrid(@Nonnull PoseStack poseStack, int x, int y, int blitOffset, int width, int height, int u, int v, Fluid fluid, int xRepeat, int yRepeat) {
        for (int iX = 0; iX < xRepeat; ++iX) {
            for (int iY = 0; iY < yRepeat; ++iY) {
                RenderHelper.drawMaskedFluid(poseStack, x + width * iX, y + height * iY, blitOffset, width, height, u, v, fluid);
            }
        }
    }

    public static String formatValue(double value, @Nullable String suffix) {
        return RenderHelper.formatValue(value, suffix, false);
    }

    public static String formatValue(double value, @Nullable String suffix, boolean allowMilliSuffix) {
        return RenderHelper.formatValue(value, 1, suffix, allowMilliSuffix);
    }

    public static String formatValue(double value, int precision, @Nullable String suffix, boolean allowMilliSuffix) {
        PeekingIterator suffixIter = Iterators.peekingIterator(Arrays.stream(unitPrefixes).iterator());
        if (Math.abs(value) < 1.0 && allowMilliSuffix) {
            if (suffix != null) {
                return String.format("%." + precision + "f %s", value * 1000.0, (String)suffixIter.peek() + suffix);
            }
            return String.format("%." + precision + "f", value * 1000.0);
        }
        suffixIter.next();
        if (Math.abs(value) < 1000.0) {
            if (suffix != null) {
                return String.format("%." + precision + "f %s", value, (String)suffixIter.peek() + suffix);
            }
            return String.format("%." + precision + "f", value);
        }
        suffixIter.next();
        while (Math.abs(value) >= 999950.0 && suffixIter.hasNext()) {
            value /= 1000.0;
            suffixIter.next();
        }
        if (suffix != null) {
            return String.format("%." + precision + "f %s", value / 1000.0, (String)suffixIter.peek() + suffix);
        }
        return String.format("%." + precision + "f", value / 1000.0);
    }

    static {
        unitPrefixes = new String[]{"m", "", "Ki", "Me", "Gi", "Te", "Pe", "Ex", "Ze", "Yo", "Ho"};
    }
}

