/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.blocks.whiteholes;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.roguelogix.phosphophyllite.modular.tile.PhosphophylliteTile;
import net.roguelogix.phosphophyllite.registry.RegisterTile;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FluidWhiteHoleTile
extends PhosphophylliteTile
implements IFluidHandler {
    @RegisterTile(value="fluid_white_hole")
    public static final BlockEntityType.BlockEntitySupplier<FluidWhiteHoleTile> SUPPLIER = new RegisterTile.Producer<FluidWhiteHoleTile>(FluidWhiteHoleTile::new);
    FluidStack fluidStack = FluidStack.EMPTY;

    public FluidWhiteHoleTile(BlockEntityType<?> TYPE, BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> capability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.capability(cap, side);
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.fluidStack;
    }

    public int getTankCapacity(int tank) {
        return Integer.MAX_VALUE;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.getFluid() == this.fluidStack.getFluid()) {
            return resource.copy();
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return new FluidStack(this.fluidStack.getFluid(), maxDrain);
    }

    public void setFluid(Fluid fluid) {
        this.fluidStack = new FluidStack(fluid, Integer.MAX_VALUE);
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag compound = super.writeNBT();
        compound.m_128365_("fluidstack", (Tag)this.fluidStack.writeToNBT(new CompoundTag()));
        return compound;
    }

    @Override
    public void readNBT(CompoundTag compound) {
        this.fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)compound.m_128469_("fluidstack"));
        super.readNBT(compound);
    }

    public void tick() {
        assert (this.f_58857_ != null);
        for (Direction direction : Direction.values()) {
            BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(direction));
            if (te == null) continue;
            te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.m_122424_()).ifPresent(c -> c.fill(this.fluidStack.copy(), IFluidHandler.FluidAction.EXECUTE));
        }
    }
}

