/*
 * Decompiled with CFR 0.152.
 */
package cofh.omgourd.event;

import cofh.core.item.KnifeItem;
import cofh.lib.util.Utils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="omgourd")
public class CommonEvents {
    private static final Object2ObjectOpenHashMap<Block, Block> CARVE_PREV_MAP = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<Block, Block> CARVE_NEXT_MAP = new Object2ObjectOpenHashMap();

    private CommonEvents() {
    }

    public static boolean registerPrev(Block block, Block prevBlock) {
        if (block instanceof CarvedPumpkinBlock && prevBlock instanceof CarvedPumpkinBlock) {
            CARVE_PREV_MAP.put((Object)block, (Object)prevBlock);
            return true;
        }
        return false;
    }

    public static boolean registerNext(Block block, Block nextBlock) {
        if (block instanceof CarvedPumpkinBlock && nextBlock instanceof CarvedPumpkinBlock) {
            CARVE_NEXT_MAP.put((Object)block, (Object)nextBlock);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void handlePlayerRightClickEvent(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        Level world = event.getWorld();
        Direction face = event.getFace();
        if (face == null) {
            return;
        }
        Player player = event.getPlayer();
        BlockPos pos = event.getPos();
        Block block = world.m_8055_(pos).m_60734_();
        ItemStack heldStack = player.m_21120_(event.getHand());
        if (heldStack.m_41720_() instanceof ShearsItem || heldStack.m_41720_() instanceof KnifeItem) {
            Block newBlock;
            Block block2 = newBlock = player.m_36341_() ? (Block)CARVE_PREV_MAP.get((Object)block) : (Block)CARVE_NEXT_MAP.get((Object)block);
            if (newBlock != null) {
                if (Utils.isClientWorld((Level)world)) {
                    player.m_6674_(event.getHand());
                } else {
                    Direction newDir = face.m_122434_() == Direction.Axis.Y ? player.m_6350_().m_122424_() : face;
                    world.m_7731_(pos, (BlockState)newBlock.m_49966_().m_61124_((Property)CarvedPumpkinBlock.f_51367_, (Comparable)newDir), 11);
                }
            }
        }
    }
}

