/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.mekanism.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientStackJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.rhino.mod.util.JsonUtils;
import javax.annotation.Nullable;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.creator.IChemicalStackIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;

public abstract class MekanismRecipeJS
extends RecipeJS {
    public JsonElement serializeIngredientStack(IngredientStackJS in) {
        JsonObject json = new JsonObject();
        json.add("ingredient", in.ingredient.toJson());
        if (in.getCount() > 1) {
            json.addProperty("amount", (Number)in.getCount());
        }
        return json;
    }

    public static ChemicalStackIngredient.GasStackIngredient parseGasIngredient(@Nullable Object o) {
        return (ChemicalStackIngredient.GasStackIngredient)MekanismRecipeJS.parseChemicalIngredient(o, "gas", 1000, IngredientCreatorAccess.gas());
    }

    public static ChemicalStackIngredient.InfusionStackIngredient parseInfusionIngredient(@Nullable Object o) {
        return (ChemicalStackIngredient.InfusionStackIngredient)MekanismRecipeJS.parseChemicalIngredient(o, "infuse_type", 10, IngredientCreatorAccess.infusion());
    }

    private static <C extends Chemical<C>, S extends ChemicalStack<C>, I extends ChemicalStackIngredient<C, S>> I parseChemicalIngredient(@Nullable Object o, String jsonKey, int defaultAmount, IChemicalStackIngredientCreator<C, S, I> creator) {
        return (I)((ChemicalStackIngredient)creator.deserialize(MekanismRecipeJS.wrapChemical(JsonUtils.of((Object)o), jsonKey, defaultAmount)));
    }

    private static JsonElement wrapChemical(JsonElement json, String jsonKey, int defaultAmount) {
        if (json.isJsonPrimitive()) {
            String string = json.getAsString().trim();
            int amount = defaultAmount;
            int spaceIndex = string.indexOf(32);
            if (spaceIndex >= 2 && string.indexOf(120) == spaceIndex - 1) {
                amount = Integer.parseInt(string.substring(0, spaceIndex - 1));
                string = string.substring(spaceIndex + 1);
            }
            JsonObject output = new JsonObject();
            if (string.startsWith("#")) {
                output.addProperty("tag", string.substring(1));
            } else {
                output.addProperty(jsonKey, string);
            }
            output.addProperty("amount", (Number)amount);
            return output;
        }
        if (json.isJsonObject()) {
            JsonObject output = json.getAsJsonObject();
            if (!output.has("amount")) {
                output.addProperty("amount", (Number)defaultAmount);
            }
            return output;
        }
        if (json.isJsonArray()) {
            JsonArray output = new JsonArray();
            for (JsonElement element : json.getAsJsonArray()) {
                output.add(MekanismRecipeJS.wrapChemical(element, jsonKey, defaultAmount));
            }
            return output;
        }
        throw new IllegalArgumentException("Invalid chemical ingredient: " + json);
    }

    public static GasStack parseGasResult(@Nullable Object o) {
        if (o instanceof JsonObject) {
            JsonObject json = (JsonObject)o;
            return SerializerHelper.deserializeGas((JsonObject)json);
        }
        if (o instanceof CharSequence) {
            JsonObject json = new JsonObject();
            json.addProperty("gas", o.toString());
            json.addProperty("amount", (Number)1000);
            return SerializerHelper.deserializeGas((JsonObject)json);
        }
        JsonObject json = MapJS.of((Object)o).toJson();
        if (!json.has("amount")) {
            json.addProperty("amount", (Number)1000);
        }
        return SerializerHelper.deserializeGas((JsonObject)json);
    }

    public static JsonElement parseChemicalStack(@Nullable Object o) {
        JsonObject json = new JsonObject();
        json.add("output", (JsonElement)MapJS.json((Object)o));
        return SerializerHelper.serializeBoxedChemicalStack((BoxedChemicalStack)BoxedChemicalStack.box((ChemicalStack)SerializerHelper.getBoxedChemicalStack((JsonObject)json, (String)"output")));
    }

    public static JsonObject serializeGasResult(GasStack stack) {
        return SerializerHelper.serializeGasStack((GasStack)stack);
    }

    public IngredientJS convertReplacedInput(int index, IngredientJS oldIngredient, IngredientJS newIngredient) {
        return newIngredient.asIngredientStack();
    }
}

