/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.parry;

import java.util.function.BiConsumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import us.drullk.parry.ParryConfig;
import us.drullk.parry.ParryEnchantment;

@Mod(value="parry")
@Mod.EventBusSubscriber(modid="parry")
public class ShieldParry {
    public static final String MODID = "parry";
    public static final TagKey<EntityType<?>> PROJECTILES_DISABLED_FOR_PARRYING = TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)ShieldParry.modId("projectiles_parrying_disabled"));

    public ShieldParry() {
        Pair pairConfigSpec = new ForgeConfigSpec.Builder().configure(ParryConfig::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)pairConfigSpec.getRight());
        ParryConfig.INSTANCE = (ParryConfig)pairConfigSpec.getLeft();
    }

    private static <T extends Projectile> boolean parryProjectile(T projectile, LivingEntity entityBlocking, boolean takeOwnership, BiConsumer<Vec3, T> trajectoryChange) {
        if (!projectile.m_6095_().m_204039_(PROJECTILES_DISABLED_FOR_PARRYING) && entityBlocking.m_21254_() && entityBlocking.m_21211_().m_41779_() - entityBlocking.m_21212_() <= ShieldParry.applyTimerBonus((Integer)ParryConfig.INSTANCE.shieldParryTicks.get(), entityBlocking.m_21211_(), (Double)ParryConfig.INSTANCE.shieldEnchantmentMultiplier.get())) {
            if (takeOwnership) {
                projectile.m_5602_((Entity)entityBlocking);
                projectile.f_37246_ = true;
            }
            trajectoryChange.accept(entityBlocking.m_20154_(), (Vec3)projectile);
            return true;
        }
        return false;
    }

    private static boolean dispatchShieldParry(Projectile projectile, EntityHitResult entityHitResult, boolean takeOwnership, BiConsumer<Vec3, Projectile> trajectoryChange) {
        LivingEntity livingEntity;
        Entity entity;
        return !projectile.f_19853_.m_5776_() && (entity = entityHitResult.m_82443_()) instanceof LivingEntity && ShieldParry.parryProjectile(projectile, livingEntity = (LivingEntity)entity, takeOwnership, trajectoryChange);
    }

    @SubscribeEvent
    public static void parryThisCasual(ProjectileImpactEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Projectile) {
            EntityHitResult entityHitResult;
            Projectile projectile = (Projectile)entity;
            entity = event.getRayTraceResult();
            if (entity instanceof EntityHitResult && ShieldParry.dispatchShieldParry(projectile, entityHitResult = (EntityHitResult)entity, !(event.getEntity() instanceof FishingHook), (reboundAngle, rebounding) -> {
                rebounding.m_6686_(reboundAngle.f_82479_, reboundAngle.f_82480_, reboundAngle.f_82481_, 1.1f, 0.1f);
                if (rebounding instanceof AbstractHurtingProjectile) {
                    AbstractHurtingProjectile damagingProjectile = (AbstractHurtingProjectile)rebounding;
                    damagingProjectile.f_36813_ = reboundAngle.f_82479_ * 0.1;
                    damagingProjectile.f_36814_ = reboundAngle.f_82480_ * 0.1;
                    damagingProjectile.f_36815_ = reboundAngle.f_82481_ * 0.1;
                }
            })) {
                event.setCanceled(true);
            }
        }
    }

    private static int applyTimerBonus(int base, ItemStack stack, double multiplier) {
        return (int)((double)base + (double)(base * EnchantmentHelper.m_44843_((Enchantment)ParryEnchantment.reboundEnchantment, (ItemStack)stack)) * multiplier);
    }

    public static ResourceLocation modId(String name) {
        return new ResourceLocation(MODID, name);
    }
}

