/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.parry;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import us.drullk.parry.ParryConfig;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ParryEnchantment {
    static Enchantment reboundEnchantment;
    private static final String enchantmentName = "rebound";
    private static EnchantmentCategory enchantmentTypeShield;

    @SubscribeEvent
    public static void registerEnchantment(RegistryEvent.Register<Enchantment> event) {
        enchantmentTypeShield = EnchantmentCategory.create((String)"shield", input -> input instanceof ShieldItem || input != null && input.canPerformAction(new ItemStack((ItemLike)input, 1), ToolActions.SHIELD_BLOCK));
        reboundEnchantment = (Enchantment)new EnchantmentRebound(Enchantment.Rarity.COMMON).setRegistryName(new ResourceLocation("parry", enchantmentName));
        event.getRegistry().register((IForgeRegistryEntry)reboundEnchantment);
    }

    private static class EnchantmentRebound
    extends Enchantment {
        EnchantmentRebound(Enchantment.Rarity rarityIn) {
            super(rarityIn, enchantmentTypeShield, new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND});
        }

        public boolean canApplyAtEnchantingTable(ItemStack stack) {
            return stack.m_41720_() instanceof ShieldItem || stack.canPerformAction(ToolActions.SHIELD_BLOCK);
        }

        public int m_6586_() {
            return (Integer)ParryConfig.INSTANCE.parryEnchantmentMaxLevel.get();
        }

        public boolean m_6591_() {
            return (Boolean)ParryConfig.INSTANCE.treasureEnchantment.get();
        }
    }
}

