/*
 * Decompiled with CFR 0.152.
 */
package com.kreezcraft.badwithernocookiereloaded;

import com.kreezcraft.badwithernocookiereloaded.BWNCR_Config;
import com.kreezcraft.badwithernocookiereloaded.BadWitherNoCookie;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SoundEventHandler {
    final boolean debugMode;

    public SoundEventHandler() {
        this.debugMode = (Boolean)BWNCR_Config.GENERAL.debugMode.get();
    }

    private void debugMsg(String msg) {
        if (this.debugMode) {
            BadWitherNoCookie.LOGGER.info(msg);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public void onEvent(PlaySoundEvent event) {
        this.debugMsg("Intercepted " + event.getName());
        if ((event.getName().equals("entity.wither.spawn") || event.getName().equalsIgnoreCase("entity.wither.death")) && ((Boolean)BWNCR_Config.GENERAL.silenceWither.get()).booleanValue()) {
            this.debugMsg("Silencing the wither's death.");
            event.setSound(null);
        }
        if ((event.getName().equalsIgnoreCase("entity.wandering_trader.ambient") || event.getName().equalsIgnoreCase("entity.llama.ambient")) && ((Boolean)BWNCR_Config.GENERAL.silenceTrader.get()).booleanValue()) {
            this.debugMsg("Silencing wandering trader and llama ambient sounds.");
            event.setSound(null);
        }
        if (event.getName().equals("entity.ender_dragon.death") && ((Boolean)BWNCR_Config.GENERAL.silenceDragon.get()).booleanValue()) {
            this.debugMsg("Silencing the ender dragon death");
            event.setSound(null);
        }
        if (event.getName().equals("entity.lightning.thunder") && ((Boolean)BWNCR_Config.GENERAL.silenceLightning.get()).booleanValue()) {
            this.debugMsg("Silencing thunder");
            event.setSound(null);
        }
        if (!((List)BWNCR_Config.GENERAL.silenceUs.get()).isEmpty()) {
            for (String soundName : (List)BWNCR_Config.GENERAL.silenceUs.get()) {
                if (!event.getName().equals(soundName)) continue;
                this.debugMsg("Silencing " + soundName);
                event.setSound(null);
            }
        }
        if (BadWitherNoCookie.whatWasThat.booleanValue()) {
            if (BadWitherNoCookie.player == null) {
                BadWitherNoCookie.LOGGER.info((Object)new TextComponent(ChatFormatting.AQUA + "Sound is " + ChatFormatting.RED + event.getName()));
            } else {
                BadWitherNoCookie.player.m_6352_((Component)new TextComponent(ChatFormatting.AQUA + "Sound is " + ChatFormatting.RED + event.getName()), Util.f_137441_);
            }
        }
    }
}

