/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.FlatElevatedSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.FlatInnerSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;

public final class VerticalHalfStairsSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            return switch (type) {
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> VerticalHalfStairsSkipPredicate.testAgainstVerticalHalfStairs(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> VerticalHalfStairsSkipPredicate.testAgainstVerticalStairs(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> VerticalHalfStairsSkipPredicate.testAgainstVerticalDoubleStairs(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_SLAB -> VerticalHalfStairsSkipPredicate.testAgainstSlab(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLAB -> VerticalHalfStairsSkipPredicate.testAgainstDoubleSlab(level, pos, dir, top, side);
                case BlockType.FRAMED_SLAB_EDGE -> VerticalHalfStairsSkipPredicate.testAgainstSlabEdge(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_SLAB_CORNER -> VerticalHalfStairsSkipPredicate.testAgainstSlabCorner(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_STAIRS -> VerticalHalfStairsSkipPredicate.testAgainstStairs(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> VerticalHalfStairsSkipPredicate.testAgainstDoubleStairs(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> VerticalHalfStairsSkipPredicate.testAgainstHalfStairs(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB -> VerticalHalfStairsSkipPredicate.testAgainstSlopeSlab(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> VerticalHalfStairsSkipPredicate.testAgainstElevatedSlopeSlab(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_SLAB -> VerticalHalfStairsSkipPredicate.testAgainstDoubleSlopeSlab(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB -> VerticalHalfStairsSkipPredicate.testAgainstInverseDoubleSlopeSlab(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB -> VerticalHalfStairsSkipPredicate.testAgainstElevatedDoubleSlopeSlab(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> VerticalHalfStairsSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> VerticalHalfStairsSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER -> VerticalHalfStairsSkipPredicate.testAgainstFlatDoubleSlopeSlabCorner(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER -> VerticalHalfStairsSkipPredicate.testAgainstFlatInverseDoubleSlopeSlabCorner(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_DOUBLE_SLOPE_SLAB_CORNER -> VerticalHalfStairsSkipPredicate.testAgainstFlatElevatedDoubleSlopeSlabCorner(level, pos, dir, top, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstVerticalHalfStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (side == Direction.UP && top || side == Direction.DOWN && !top) {
            if (adjTop == top || adjDir != dir) {
                return false;
            }
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (side == dir.m_122424_() && adjDir == dir.m_122428_() || side == dir.m_122427_() && adjDir == dir.m_122427_()) {
            return adjTop == top && SideSkipPredicate.compareState(level, pos, side);
        }
        if (side == dir && adjDir == dir.m_122428_() || side == dir.m_122428_() && adjDir == dir.m_122427_()) {
            return adjTop == top && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (side == Direction.DOWN && !top && !adjType.isTop() || side == Direction.UP && top && !adjType.isBottom()) {
            return adjDir == dir && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstVerticalDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (side == Direction.DOWN && !top || side == Direction.UP && top) {
            return adjDir == dir && SideSkipPredicate.compareState(level, pos, side, side, dir);
        }
        return false;
    }

    private static boolean testAgainstSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!VerticalHalfStairsSkipPredicate.isSlabSide(dir, side)) {
            return false;
        }
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return adjTop == top && SideSkipPredicate.compareState(level, pos, side);
    }

    private static boolean testAgainstDoubleSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, Direction side) {
        if (side == dir || side == dir.m_122428_()) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
        }
        return false;
    }

    private static boolean testAgainstSlabEdge(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (Utils.isY(side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop != top) {
            return false;
        }
        if (VerticalHalfStairsSkipPredicate.isSlabSide(dir, side) && adjDir == side.m_122424_()) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (side == dir.m_122427_() && adjDir == dir || side == dir.m_122424_() && adjDir == dir.m_122428_()) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == top && adjDir == dir && (side == dir.m_122424_() || side == dir.m_122427_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        boolean adjTop = adjState.m_61143_((Property)StairBlock.f_56842_) == Half.TOP;
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)StairBlock.f_56843_);
        if (adjTop != top) {
            return false;
        }
        if (side == Direction.UP && top || side == Direction.DOWN && !top ? adjDir == dir && adjShape == StairsShape.INNER_LEFT || adjDir == dir.m_122428_() && adjShape == StairsShape.INNER_RIGHT : StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.m_122424_()) && VerticalHalfStairsSkipPredicate.isSlabSide(dir, side)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!VerticalHalfStairsSkipPredicate.isSlabSide(dir, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        return adjDir == side && SideSkipPredicate.compareState(level, pos, side, side, top ? Direction.UP : Direction.DOWN);
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (adjTop != top || adjDir != side) {
            return false;
        }
        if (adjRight && adjDir == dir.m_122424_() || !adjRight && adjDir == dir.m_122427_()) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!VerticalHalfStairsSkipPredicate.isSlabSide(dir, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTop == top && adjDir == side.m_122424_()) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstElevatedSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!VerticalHalfStairsSkipPredicate.isSlabSide(dir, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == top && adjDir == side) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!VerticalHalfStairsSkipPredicate.isSlabSide(dir, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTop == top && (adjDir == side || adjDir == side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!VerticalHalfStairsSkipPredicate.isSlabSide(dir, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (!top && adjDir == side || top && adjDir == side.m_122424_()) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstElevatedDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!VerticalHalfStairsSkipPredicate.isSlabSide(dir, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (adjDir == side) {
            Direction camoDir = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoDir, camoDir);
        }
        return false;
    }

    private static boolean testAgainstFlatInnerSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!VerticalHalfStairsSkipPredicate.isSlabSide(dir, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTopHalf == top && FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(adjDir, side.m_122424_())) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, adjDir);
        }
        return false;
    }

    private static boolean testAgainstFlatElevatedSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!VerticalHalfStairsSkipPredicate.isSlabSide(dir, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == top && FlatElevatedSlopeSlabCornerSkipPredicate.isSlabSide(adjDir, side.m_122424_())) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!VerticalHalfStairsSkipPredicate.isSlabSide(dir, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTopHalf == top && FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(adjDir, side.m_122424_())) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, adjDir);
        }
        return false;
    }

    private static boolean testAgainstFlatInverseDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!VerticalHalfStairsSkipPredicate.isSlabSide(dir, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == top && FlatInnerSlopeSlabCornerSkipPredicate.isInverseSlabSide(adjDir, side.m_122424_())) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
        }
        return false;
    }

    private static boolean testAgainstFlatElevatedDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!VerticalHalfStairsSkipPredicate.isSlabSide(dir, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (FlatInnerSlopeSlabCornerSkipPredicate.isInverseSlabSide(adjDir, side.m_122424_())) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
        }
        return false;
    }

    public static boolean isSlabSide(Direction dir, Direction side) {
        return side == dir || side == dir.m_122428_();
    }
}

