/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.FlatElevatedSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.FlatExtendedSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.FlatInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.FlatInnerSlopeSlabCornerSkipPredicate;

public final class StairsSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        if (SideSkipPredicate.CTM.test(level, pos, state, adjState, side)) {
            return true;
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
            StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
            boolean top = state.m_61143_((Property)StairBlock.f_56842_) == Half.TOP;
            return switch (type) {
                case BlockType.FRAMED_STAIRS -> StairsSkipPredicate.testAgainstStairs(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> StairsSkipPredicate.testAgainstDoubleStairs(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_SLAB -> StairsSkipPredicate.testAgainstSlab(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLAB -> StairsSkipPredicate.testAgainstDoubleSlab(level, pos, dir, shape, top, side);
                case BlockType.FRAMED_SLAB_EDGE -> StairsSkipPredicate.testAgainstEdge(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_PANEL -> StairsSkipPredicate.testAgainstPanel(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_PANEL -> StairsSkipPredicate.testAgainstDoublePanel(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> StairsSkipPredicate.testAgainstPillar(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_SLAB_CORNER -> StairsSkipPredicate.testAgainstCorner(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> StairsSkipPredicate.testAgainstVerticalStairs(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> StairsSkipPredicate.testAgainstHalfStairs(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB -> StairsSkipPredicate.testAgainstSlopeSlab(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> StairsSkipPredicate.testAgainstElevatedSlopeSlab(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_SLAB -> StairsSkipPredicate.testAgainstDoubleSlopeSlab(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB -> StairsSkipPredicate.testAgainstInverseDoubleSlopeSlab(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB -> StairsSkipPredicate.testAgainstElevatedDoubleSlopeSlab(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> StairsSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> StairsSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER -> StairsSkipPredicate.testAgainstFlatDoubleSlopeSlabCorner(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER -> StairsSkipPredicate.testAgainstFlatInverseDoubleSlopeSlabCorner(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_DOUBLE_SLOPE_SLAB_CORNER -> StairsSkipPredicate.testAgainstFlatElevatedDoubleSlopeSlabCorner(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> StairsSkipPredicate.testAgainstVerticalHalfStairs(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> StairsSkipPredicate.testAgainstSlopePanel(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> StairsSkipPredicate.testAgainstExtendedSlopePanel(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> StairsSkipPredicate.testAgainstDoubleSlopePanel(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> StairsSkipPredicate.testAgainstInverseDoubleSlopePanel(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL -> StairsSkipPredicate.testAgainstExtendedDoubleSlopePanel(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> StairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> StairsSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER -> StairsSkipPredicate.testAgainstFlatDoubleSlopePanelCorner(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER -> StairsSkipPredicate.testAgainstFlatInverseDoubleSlopePanelCorner(level, pos, dir, shape, top, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER -> StairsSkipPredicate.testAgainstFlatExtendedDoubleSlopePanelCorner(level, pos, dir, shape, top, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)StairBlock.f_56843_);
        boolean bl = adjTop = adjState.m_61143_((Property)StairBlock.f_56842_) == Half.TOP;
        if (Utils.isY(side) && adjDir == dir && adjShape == shape && adjTop != top) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        if (adjTop != top) {
            return false;
        }
        if (StairsSkipPredicate.isStairSide(shape, dir, side) && StairsSkipPredicate.isStairSide(adjShape, adjDir, side.m_122424_()) && (StairsSkipPredicate.isStairDirection(shape, dir, adjShape, adjDir, side.m_122427_()) || StairsSkipPredicate.isStairDirection(shape, dir, adjShape, adjDir, side.m_122428_()))) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        if (StairsSkipPredicate.isSlabSide(shape, dir, side) && StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (StairsSkipPredicate.isStairSide(shape, dir, side) && StairsSkipPredicate.isStairSide(StairsShape.STRAIGHT, adjDir, side.m_122424_()) && StairsSkipPredicate.isStairDirection(shape, dir, adjDir.m_122424_())) {
            return adjTop == top && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (StairsSkipPredicate.isSlabSide(shape, dir, side) && adjDir == dir.m_122424_()) {
            return SideSkipPredicate.compareState(level, pos, side, dir, top ? Direction.UP : Direction.DOWN);
        }
        if (Utils.isY(side) && (adjDir == dir || adjDir == dir.m_122424_()) && shape == StairsShape.STRAIGHT && adjTop != top) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstSlab(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (top != adjTop || !StairsSkipPredicate.isSlabSide(shape, dir, side)) {
            return false;
        }
        return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
    }

    private static boolean testAgainstDoubleSlab(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, Direction side) {
        if (!StairsSkipPredicate.isSlabSide(shape, dir, side)) {
            return false;
        }
        return SideSkipPredicate.compareState(level, pos, side, dir, top ? Direction.UP : Direction.DOWN);
    }

    private static boolean testAgainstEdge(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (top != adjTop) {
            return false;
        }
        if (adjDir == side.m_122424_()) {
            if (!StairsSkipPredicate.isSlabSide(shape, dir, side)) {
                return false;
            }
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        if (top && side == Direction.DOWN || !top && side == Direction.UP) {
            if (shape != StairsShape.STRAIGHT) {
                return false;
            }
            return dir == adjDir && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.STRAIGHT) {
            return false;
        }
        if (top && side != Direction.DOWN || !top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        return dir == adjDir && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.STRAIGHT) {
            return false;
        }
        if (top && side != Direction.DOWN || !top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_NE);
        if (dir == adjDir || dir.m_122424_() == adjDir) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstPillar(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.OUTER_LEFT && shape != StairsShape.OUTER_RIGHT) {
            return false;
        }
        if (top && side != Direction.DOWN || !top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (shape == StairsShape.OUTER_LEFT && dir == adjDir || shape == StairsShape.OUTER_RIGHT && dir.m_122427_() == adjDir) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstCorner(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.OUTER_LEFT && shape != StairsShape.OUTER_RIGHT) {
            return false;
        }
        if (top && side != Direction.DOWN || !top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (shape == StairsShape.OUTER_LEFT && dir == adjDir || shape == StairsShape.OUTER_RIGHT && dir.m_122427_() == adjDir) {
            return adjTop == top && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (adjType == StairsType.VERTICAL ? (side == Direction.DOWN && top || side == Direction.UP && !top) && (shape == StairsShape.INNER_LEFT && adjDir == dir || shape == StairsShape.INNER_RIGHT && adjDir == dir.m_122427_()) : adjType.isTop() != top && (side == dir.m_122427_() && adjDir == dir || side == dir.m_122428_() && adjDir == dir.m_122427_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (!StairsSkipPredicate.isStairSide(shape, dir, side) || !StairsSkipPredicate.isStairDirection(shape, dir, adjDir.m_122424_()) || top != adjTop) {
            return false;
        }
        Direction adjStairFace = adjRight ? adjDir.m_122427_() : adjDir.m_122428_();
        return adjStairFace == side.m_122424_() && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
    }

    private static boolean testAgainstSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (!StairsSkipPredicate.isSlabSide(shape, dir, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        return adjDir == side.m_122424_() && adjTopHalf == top && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
    }

    private static boolean testAgainstElevatedSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (!StairsSkipPredicate.isSlabSide(shape, dir, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return adjDir == side && adjTop == top && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
    }

    private static boolean testAgainstDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (!StairsSkipPredicate.isSlabSide(shape, dir, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjDir != side && adjDir != side.m_122424_()) {
            return false;
        }
        return adjTopHalf == top && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (!StairsSkipPredicate.isSlabSide(shape, dir, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        return (adjDir == side && !top || adjDir == side.m_122424_() && top) && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
    }

    private static boolean testAgainstElevatedDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (!StairsSkipPredicate.isSlabSide(shape, dir, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        return adjDir == side && SideSkipPredicate.compareState(level, pos, side, dir, top ? Direction.UP : Direction.DOWN);
    }

    private static boolean testAgainstFlatInnerSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (!StairsSkipPredicate.isSlabSide(shape, dir, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTopHalf != top || !FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(adjDir, side.m_122424_())) {
            return false;
        }
        Direction camoSide = top ? Direction.UP : Direction.DOWN;
        return SideSkipPredicate.compareState(level, pos, side, camoSide, adjDir);
    }

    private static boolean testAgainstFlatElevatedSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (!StairsSkipPredicate.isSlabSide(shape, dir, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == top && FlatElevatedSlopeSlabCornerSkipPredicate.isSlabSide(adjDir, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (!StairsSkipPredicate.isSlabSide(shape, dir, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTopHalf == top && FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(adjDir, side.m_122424_())) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, adjDir);
        }
        return false;
    }

    private static boolean testAgainstFlatInverseDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (!StairsSkipPredicate.isSlabSide(shape, dir, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == top && FlatInnerSlopeSlabCornerSkipPredicate.isInverseSlabSide(adjDir, side.m_122424_())) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
        }
        return false;
    }

    private static boolean testAgainstFlatElevatedDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (!StairsSkipPredicate.isSlabSide(shape, dir, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (FlatInnerSlopeSlabCornerSkipPredicate.isInverseSlabSide(adjDir, side.m_122424_())) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
        }
        return false;
    }

    private static boolean testAgainstVerticalHalfStairs(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop != top) {
            return false;
        }
        if ((side == Direction.DOWN && top || side == Direction.UP && !top) && (shape == StairsShape.INNER_LEFT && adjDir == dir || shape == StairsShape.INNER_RIGHT && adjDir == dir.m_122427_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        if (StairsSkipPredicate.isSlabSide(shape, dir, side) && (adjDir == side.m_122424_() || adjDir == side.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstSlopePanel(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.STRAIGHT || !top && side != Direction.UP || top && side != Direction.DOWN) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (!adjRot.isVertical() || adjRot == HorizontalRotation.DOWN != top) {
            return false;
        }
        if (adjDir == dir && !adjFront || adjDir == dir.m_122424_() && adjFront) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.STRAIGHT || !top && side != Direction.UP || top && side != Direction.DOWN) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir == dir && (!top && adjRot == HorizontalRotation.DOWN || top && adjRot == HorizontalRotation.UP)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.STRAIGHT || !top && side != Direction.UP || top && side != Direction.DOWN) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (!adjRot.isVertical()) {
            return false;
        }
        if (adjDir == dir && !adjFront || adjDir == dir.m_122424_() && adjFront) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        boolean sameOrientation;
        if (shape != StairsShape.STRAIGHT || !top && side != Direction.UP || top && side != Direction.DOWN) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (!adjRot.isVertical()) {
            return false;
        }
        boolean bl = sameOrientation = top == (adjRot == HorizontalRotation.UP);
        if (adjDir == dir && sameOrientation || adjDir == dir.m_122424_() && !sameOrientation) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstExtendedDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.STRAIGHT || !top && side != Direction.UP || top && side != Direction.DOWN) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (!adjRot.isVertical()) {
            return false;
        }
        if (adjDir.m_122434_() == dir.m_122434_() && top == (adjRot == HorizontalRotation.UP)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstFlatInnerSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.STRAIGHT || top && side != Direction.DOWN || !top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (!FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_())) {
            return false;
        }
        if (!adjFront && adjDir == dir || adjFront && adjDir == dir.m_122424_()) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.STRAIGHT || top && side != Direction.DOWN || !top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir == dir && FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.STRAIGHT || top && side != Direction.DOWN || !top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (!FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_())) {
            return false;
        }
        if (!adjFront && adjDir == dir || adjFront && adjDir == dir.m_122424_()) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstFlatInverseDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.STRAIGHT || top && side != Direction.DOWN || !top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir == dir && FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.STRAIGHT || top && side != Direction.DOWN || !top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir.m_122434_() == dir.m_122434_() && FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    public static boolean isStairSide(StairsShape shape, Direction dir, Direction side) {
        if (shape == StairsShape.STRAIGHT) {
            return side == dir.m_122427_() || side == dir.m_122428_();
        }
        if (shape == StairsShape.INNER_LEFT) {
            return side == dir.m_122424_() || side == dir.m_122427_();
        }
        if (shape == StairsShape.INNER_RIGHT) {
            return side == dir.m_122424_() || side == dir.m_122428_();
        }
        if (shape == StairsShape.OUTER_LEFT) {
            return side == dir || side == dir.m_122428_();
        }
        if (shape == StairsShape.OUTER_RIGHT) {
            return side == dir || side == dir.m_122427_();
        }
        return false;
    }

    public static boolean isStairDirection(StairsShape shape, Direction dir, StairsShape adjShape, Direction adjDir, Direction side) {
        return StairsSkipPredicate.isStairDirection(shape, dir, side) && StairsSkipPredicate.isStairDirection(adjShape, adjDir, side);
    }

    public static boolean isStairDirection(StairsShape shape, Direction dir, Direction side) {
        return switch (shape) {
            default -> throw new IncompatibleClassChangeError();
            case StairsShape.STRAIGHT -> {
                if (side == dir.m_122424_()) {
                    yield true;
                }
                yield false;
            }
            case StairsShape.INNER_LEFT, StairsShape.OUTER_LEFT -> {
                if (side == dir.m_122424_() || side == dir.m_122427_()) {
                    yield true;
                }
                yield false;
            }
            case StairsShape.INNER_RIGHT, StairsShape.OUTER_RIGHT -> side == dir.m_122424_() || side == dir.m_122428_();
        };
    }

    public static boolean isSlabSide(StairsShape shape, Direction dir, Direction side) {
        if (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT) {
            return false;
        }
        if (shape == StairsShape.STRAIGHT) {
            return side == dir.m_122424_();
        }
        if (shape == StairsShape.OUTER_LEFT) {
            return side == dir.m_122424_() || side == dir.m_122427_();
        }
        if (shape == StairsShape.OUTER_RIGHT) {
            return side == dir.m_122424_() || side == dir.m_122428_();
        }
        return false;
    }
}

