/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.skippreds.FlatElevatedSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.FlatInnerSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;

public final class SlopeSlabSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        if (SideSkipPredicate.CTM.test(level, pos, state, adjState, side)) {
            return true;
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            boolean topHalf = (Boolean)state.m_61143_((Property)PropertyHolder.TOP_HALF);
            return switch (type) {
                case BlockType.FRAMED_SLOPE_SLAB -> SlopeSlabSkipPredicate.testAgainstSlopeSlab(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> SlopeSlabSkipPredicate.testAgainstElevatedSlopeSlab(level, pos, dir, topHalf, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_SLAB -> SlopeSlabSkipPredicate.testAgainstDoubleSlopeSlab(level, pos, dir, topHalf, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB -> SlopeSlabSkipPredicate.testAgainstInverseDoubleSlopeSlab(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB -> SlopeSlabSkipPredicate.testAgainstElevatedDoubleSlopeSlab(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_SLOPE_SLAB_CORNER -> SlopeSlabSkipPredicate.testAgainstFlatSlopeSlabCorner(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> SlopeSlabSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> SlopeSlabSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(level, pos, dir, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER -> SlopeSlabSkipPredicate.testAgainstFlatDoubleSlopeSlabCorner(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER -> SlopeSlabSkipPredicate.testAgainstFlatInverseDoubleSlopeSlabCorner(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_DOUBLE_SLOPE_SLAB_CORNER -> SlopeSlabSkipPredicate.testAgainstFlatElevatedDoubleSlopeSlabCorner(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_INNER_DOUBLE_SLOPE_SLAB_CORNER -> SlopeSlabSkipPredicate.testAgainstFlatElevatedInnerDoubleSlopeSlabCorner(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_SLAB -> SlopeSlabSkipPredicate.testAgainstSlab(level, pos, dir, topHalf, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLAB -> SlopeSlabSkipPredicate.testAgainstDoubleSlab(level, pos, dir, topHalf, side);
                case BlockType.FRAMED_SLAB_EDGE -> SlopeSlabSkipPredicate.testAgainstSlabEdge(level, pos, dir, topHalf, adjState, side);
                case BlockType.FRAMED_STAIRS -> SlopeSlabSkipPredicate.testAgainstStairs(level, pos, dir, topHalf, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> SlopeSlabSkipPredicate.testAgainstDoubleStairs(level, pos, dir, topHalf, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> SlopeSlabSkipPredicate.testAgainstVerticalHalfStairs(level, pos, dir, topHalf, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTopHalf != topHalf) {
            return false;
        }
        if (side == dir.m_122427_() || side == dir.m_122428_()) {
            return adjDir == dir && adjTop == top && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (side == dir) {
            return adjDir == dir.m_122424_() && SideSkipPredicate.compareState(level, pos, side, dir, dir.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstElevatedSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return side == dir && adjDir == dir && adjTop == topHalf && SideSkipPredicate.compareState(level, pos, side, dir, dir);
    }

    private static boolean testAgainstDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTopHalf != topHalf) {
            return false;
        }
        if (side == dir.m_122427_() || side == dir.m_122428_()) {
            return (adjDir == dir || adjDir == dir.m_122424_()) && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (side == dir) {
            return (adjDir == dir || adjDir == dir.m_122424_()) && SideSkipPredicate.compareState(level, pos, side, dir, dir.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (side == dir.m_122427_() || side == dir.m_122428_()) {
            return (adjDir == dir && topHalf && !top || adjDir == dir.m_122424_() && !topHalf && top) && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (side == dir && (adjDir == dir && !topHalf || adjDir == dir.m_122424_() && topHalf)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstElevatedDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (side.m_122434_() == dir.m_122427_().m_122434_() && adjDir == dir.m_122424_() && top != adjTop && topHalf != adjTop) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (side == dir && adjDir == dir) {
            return SideSkipPredicate.compareState(level, pos, side, dir, topHalf ? Direction.UP : Direction.DOWN);
        }
        return false;
    }

    private static boolean testAgainstFlatSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTop != top || adjTopHalf != topHalf) {
            return false;
        }
        if (side == dir.m_122427_() && adjDir == dir || side == dir.m_122428_() && adjDir == dir.m_122427_()) {
            return SideSkipPredicate.compareState(level, pos, side, dir, adjDir);
        }
        return false;
    }

    private static boolean testAgainstFlatInnerSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTopHalf != topHalf) {
            return false;
        }
        if (FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(adjDir, side.m_122424_()) && side == dir) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (adjTop != top) {
            return false;
        }
        if (side == dir.m_122428_() && adjDir == dir || side == dir.m_122427_() && adjDir == dir.m_122427_()) {
            return SideSkipPredicate.compareState(level, pos, side, dir, adjDir);
        }
        return false;
    }

    private static boolean testAgainstFlatElevatedSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == topHalf && side == dir && FlatElevatedSlopeSlabCornerSkipPredicate.isSlabSide(adjDir, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        boolean sameTop;
        if (Utils.isY(side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTopHalf != topHalf) {
            return false;
        }
        if (FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(adjDir, side.m_122424_()) && side == dir) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        boolean bl = sameTop = adjTop == top;
        if (side == dir.m_122428_() && (sameTop && adjDir == dir || !sameTop && adjDir == dir.m_122428_())) {
            Direction camoSide = sameTop ? adjDir : side.m_122424_();
            return SideSkipPredicate.compareState(level, pos, side, dir, camoSide);
        }
        if (side == dir.m_122427_() && (sameTop && adjDir == dir.m_122427_() || !sameTop && adjDir == dir.m_122424_())) {
            Direction camoSide = sameTop ? adjDir : side.m_122424_();
            return SideSkipPredicate.compareState(level, pos, side, dir, camoSide);
        }
        return false;
    }

    private static boolean testAgainstFlatInverseDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        if (Utils.isY(side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == topHalf && FlatInnerSlopeSlabCornerSkipPredicate.isInverseSlabSide(adjDir, side.m_122424_()) && side == dir) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (adjTop == topHalf && adjTop != top && (side == dir.m_122427_() && adjDir == dir.m_122428_() || side == dir.m_122428_() && adjDir == dir.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (adjTop == top && adjTop != topHalf && (side == dir.m_122427_() && adjDir == dir || side == dir.m_122428_() && adjDir == dir.m_122427_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstFlatElevatedDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (side == dir && FlatInnerSlopeSlabCornerSkipPredicate.isInverseSlabSide(adjDir, side.m_122424_())) {
            Direction camoSide = topHalf ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, dir, camoSide);
        }
        if (adjTop != topHalf && adjTop != top && (side == dir.m_122427_() && adjDir == dir.m_122428_() || side == dir.m_122428_() && adjDir == dir.m_122424_())) {
            Direction camoSide = topHalf ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, dir, camoSide);
        }
        return false;
    }

    private static boolean testAgainstFlatElevatedInnerDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop != topHalf && adjTop != top && (side == dir.m_122427_() && adjDir == dir.m_122424_() || side == dir.m_122428_() && adjDir == dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstSlab(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return side == dir && adjTop == topHalf && SideSkipPredicate.compareState(level, pos, side, dir, dir);
    }

    private static boolean testAgainstDoubleSlab(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, Direction side) {
        return side == dir && SideSkipPredicate.compareState(level, pos, side, dir, topHalf ? Direction.UP : Direction.DOWN);
    }

    private static boolean testAgainstSlabEdge(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return side == dir && adjDir == dir.m_122424_() && adjTop == topHalf && SideSkipPredicate.compareState(level, pos, side, dir, dir);
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        boolean bl = adjTop = adjState.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        if (topHalf == adjTop && StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.m_122424_())) {
            return side == dir && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        if (adjDir == dir && side == dir) {
            return SideSkipPredicate.compareState(level, pos, side, dir, topHalf ? Direction.UP : Direction.DOWN);
        }
        return false;
    }

    private static boolean testAgainstVerticalHalfStairs(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop != topHalf || side != dir) {
            return false;
        }
        if (adjDir == dir.m_122424_() || adjDir == dir.m_122428_()) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }
}

