/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.FlatExtendedSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.FlatInnerSlopePanelCornerSkipPredicate;

public final class SlopePanelSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        Direction rotDir = rot.withFacing(dir);
        boolean front = (Boolean)state.m_61143_((Property)PropertyHolder.FRONT);
        if (side == dir) {
            return !front && SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_SLOPE_PANEL -> SlopePanelSkipPredicate.testAgainstSlopePanel(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> SlopePanelSkipPredicate.testAgainstExtendedSlopePanel(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> SlopePanelSkipPredicate.testAgainstDoubleSlopePanel(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> SlopePanelSkipPredicate.testAgainstInverseDoubleSlopePanel(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL -> SlopePanelSkipPredicate.testAgainstExtendedDoubleSlopePanel(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_FLAT_SLOPE_PANEL_CORNER -> SlopePanelSkipPredicate.testAgainstFlatSlopePanelCorner(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> SlopePanelSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> SlopePanelSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(level, pos, dir, rotDir, front, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER -> SlopePanelSkipPredicate.testAgainstFlatDoubleSlopePanelCorner(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER -> SlopePanelSkipPredicate.testAgainstFlatInverseDoubleSlopePanelCorner(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER -> SlopePanelSkipPredicate.testAgainstFlatExtendedDoubleSlopePanelCorner(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_INNER_DOUBLE_SLOPE_PANEL_CORNER -> SlopePanelSkipPredicate.testAgainstFlatExtendedInnerSlopePanelCorner(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> SlopePanelSkipPredicate.testAgainstSlabEdge(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_PANEL -> SlopePanelSkipPredicate.testAgainstPanel(level, pos, dir, rotDir, front, adjState, side);
                case BlockType.FRAMED_DOUBLE_PANEL -> SlopePanelSkipPredicate.testAgainstDoublePanel(level, pos, dir, rotDir, front, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> SlopePanelSkipPredicate.testAgainstCornerPillar(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_STAIRS -> SlopePanelSkipPredicate.testAgainstStairs(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> SlopePanelSkipPredicate.testAgainstDoubleStairs(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> SlopePanelSkipPredicate.testAgainstVerticalStairs(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> SlopePanelSkipPredicate.testAgainstVerticalDoubleStairs(level, pos, dir, rot, rotDir, front, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> SlopePanelSkipPredicate.testAgainstHalfStairs(level, pos, dir, rot, rotDir, front, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstSlopePanel(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (side == rotDir.m_122424_()) {
            if (adjRot == rot && adjDir == dir.m_122424_() && adjFront != front) {
                return SideSkipPredicate.compareState(level, pos, side);
            }
            if (adjRot == rot.getOpposite() && adjDir == dir && adjFront == front) {
                return SideSkipPredicate.compareState(level, pos, side);
            }
        } else if (side.m_122434_() != rotDir.m_122434_() && side.m_122434_() != dir.m_122434_()) {
            Direction camoDir = rotDir.m_122424_();
            return adjDir == dir && adjFront == front && adjRot == rot && SideSkipPredicate.compareState(level, pos, side, camoDir, camoDir);
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (side != rotDir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjRot == rot && (adjDir == dir && !front || adjDir == dir.m_122424_() && front)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (side == rotDir.m_122424_() && (adjRot == rot || adjRot == rot.getOpposite()) && (adjDir == dir && adjFront == front || adjDir == dir.m_122424_() && adjFront != front)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (side.m_122434_() != dir.m_122434_() && side.m_122434_() != rotDir.m_122434_()) {
            Direction camoDir = rotDir.m_122424_();
            if (adjDir == dir && adjFront == front && rot.isSameDir(dir, adjRot, adjDir)) {
                return SideSkipPredicate.compareState(level, pos, side, camoDir, camoDir);
            }
            if (adjDir == dir.m_122424_() && adjFront != front && rot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
                return SideSkipPredicate.compareState(level, pos, side, camoDir, camoDir);
            }
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (side != rotDir.m_122424_() && (side.m_122434_() == dir.m_122434_() || side.m_122434_() == rotDir.m_122434_())) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (side == rotDir.m_122424_()) {
            if (adjDir.m_122434_() == dir.m_122434_() && (adjRot == rot && !front || adjRot == rot.getOpposite() && front)) {
                return SideSkipPredicate.compareState(level, pos, side);
            }
        } else if (front && side.m_122434_() != dir.m_122434_() && side.m_122434_() != rotDir.m_122434_()) {
            Direction camoDir = rotDir.m_122424_();
            if (adjDir == dir && rot.isSameDir(dir, adjRot, adjDir)) {
                return SideSkipPredicate.compareState(level, pos, side, camoDir, camoDir);
            }
            if (adjDir == dir.m_122424_() && rot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
                return SideSkipPredicate.compareState(level, pos, side, camoDir, camoDir);
            }
        }
        return false;
    }

    private static boolean testAgainstExtendedDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (adjDir.m_122434_() != dir.m_122434_()) {
            return false;
        }
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (side == rotDir.m_122424_()) {
            Direction camoDir = front ? dir.m_122424_() : dir;
            return (adjRot == rot || adjRot == rot.getOpposite()) && SideSkipPredicate.compareState(level, pos, side, side, camoDir);
        }
        if (!front && side.m_122434_() != rotDir.m_122434_() && side.m_122434_() != dir.m_122434_()) {
            Direction camoDir = rotDir.m_122424_();
            return adjDir == dir.m_122424_() && rot.isSameDir(dir, adjRot.getOpposite(), adjDir) && SideSkipPredicate.compareState(level, pos, side, camoDir, camoDir);
        }
        return false;
    }

    private static boolean testAgainstFlatSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir != dir || adjFront != front) {
            return false;
        }
        if (side == rot.rotate(Rotation.CLOCKWISE_90).withFacing(dir) && adjRot == rot.rotate(Rotation.CLOCKWISE_90)) {
            Direction camoSide = rotDir.m_122424_();
            return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
        }
        if (side == rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir) && adjRot == rot) {
            Direction camoSide = rotDir.m_122424_();
            return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
        }
        return false;
    }

    private static boolean testAgainstFlatInnerSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (side == rotDir.m_122424_() && FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_()) && (adjDir == dir && adjFront == front || adjDir == dir.m_122424_() && adjFront != front)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (adjDir != dir || adjFront != front) {
            return false;
        }
        if (side == rot.rotate(Rotation.CLOCKWISE_90).withFacing(dir) && adjRot == rot) {
            Direction camoSide = rotDir.m_122424_();
            return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
        }
        if (side == rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir) && adjRot == rot.rotate(Rotation.CLOCKWISE_90)) {
            Direction camoSide = rotDir.m_122424_();
            return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        HorizontalRotation adjRot;
        if (side != rotDir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION)), side.m_122424_())) {
            return (adjDir == dir && !front || adjDir == dir.m_122424_() && front) && SideSkipPredicate.compareState(level, pos, side, side, adjDir);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (side == rotDir.m_122424_() && FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_()) && (adjDir == dir && adjFront == front || adjDir == dir.m_122424_() && adjFront != front)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (side == rot.rotate(Rotation.CLOCKWISE_90).withFacing(dir)) {
            if (adjDir == dir && adjFront == front && adjRot == rot) {
                Direction camoSide = rotDir.m_122424_();
                return SideSkipPredicate.compareState(level, pos, side, camoSide, adjDir);
            }
            if (adjDir == dir.m_122424_() && adjFront != front && rot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
                Direction camoSide = rotDir.m_122424_();
                return SideSkipPredicate.compareState(level, pos, side, camoSide, adjDir.m_122424_());
            }
        } else if (side == rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir)) {
            if (adjDir == dir && adjFront == front && adjRot == rot.rotate(Rotation.CLOCKWISE_90)) {
                Direction camoSide = rotDir.m_122424_();
                return SideSkipPredicate.compareState(level, pos, side, camoSide, adjDir);
            }
            if (adjDir == dir.m_122424_() && adjFront != front && rot.rotate(Rotation.CLOCKWISE_90).isSameDir(dir, adjRot, adjDir)) {
                Direction camoSide = rotDir.m_122424_();
                return SideSkipPredicate.compareState(level, pos, side, camoSide, adjDir.m_122424_());
            }
        }
        return false;
    }

    private static boolean testAgainstFlatInverseDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (side == rotDir.m_122424_() && FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_()) && (adjDir == dir && !front || adjDir == dir.m_122424_() && front)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (!front) {
            return false;
        }
        if (side == rot.rotate(Rotation.CLOCKWISE_90).withFacing(dir)) {
            if (adjDir == dir && rot.isSameDir(dir, adjRot.rotate(Rotation.CLOCKWISE_90), adjDir)) {
                return SideSkipPredicate.compareState(level, pos, side, rotDir.m_122424_(), adjDir.m_122424_());
            }
            if (adjDir == dir.m_122424_() && rot.isSameDir(dir, adjRot.rotate(Rotation.COUNTERCLOCKWISE_90), adjDir)) {
                return SideSkipPredicate.compareState(level, pos, side, rotDir.m_122424_(), adjDir);
            }
        } else if (side == rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir)) {
            if (adjDir == dir && rot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
                return SideSkipPredicate.compareState(level, pos, side, rotDir.m_122424_(), adjDir.m_122424_());
            }
            if (adjDir == dir.m_122424_() && rot.isSameDir(dir, adjRot, adjDir)) {
                return SideSkipPredicate.compareState(level, pos, side, rotDir.m_122424_(), adjDir);
            }
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        HorizontalRotation adjRot;
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION)), side.m_122424_()) && adjDir.m_122434_() == dir.m_122434_()) {
            Direction camoSide = front ? dir.m_122424_() : dir;
            return side == rotDir.m_122424_() && SideSkipPredicate.compareState(level, pos, side, side, camoSide);
        }
        if (adjDir != dir.m_122424_() || front) {
            return false;
        }
        if (side == rot.rotate(Rotation.CLOCKWISE_90).withFacing(dir) && rot.isSameDir(dir, adjRot.rotate(Rotation.CLOCKWISE_90), adjDir)) {
            return SideSkipPredicate.compareState(level, pos, side, rotDir.m_122424_(), adjDir.m_122424_());
        }
        if (side == rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir) && rot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
            return SideSkipPredicate.compareState(level, pos, side, rotDir.m_122424_(), adjDir.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedInnerSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir != dir.m_122424_() || front) {
            return false;
        }
        if (side == rot.rotate(Rotation.CLOCKWISE_90).withFacing(dir) && rot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
            return SideSkipPredicate.compareState(level, pos, side, rotDir.m_122424_(), adjDir.m_122424_());
        }
        if (side == rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir) && rot.isSameDir(dir, adjRot.rotate(Rotation.CLOCKWISE_90), adjDir)) {
            return SideSkipPredicate.compareState(level, pos, side, rotDir.m_122424_(), adjDir.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstSlabEdge(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (!rot.isVertical() || side != rotDir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == (rot == HorizontalRotation.UP) && (adjDir == dir && !front || adjDir == dir.m_122424_() && front)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, Direction dir, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (side != rotDir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (adjDir == dir && !front || adjDir == dir.m_122424_() && front) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, Direction dir, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (side != rotDir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_NE);
        return (adjDir == dir || adjDir == dir.m_122424_()) && SideSkipPredicate.compareState(level, pos, side, side, front ? dir.m_122424_() : dir);
    }

    private static boolean testAgainstCornerPillar(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (rot.isVertical() || side != rotDir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (!front && (adjDir == dir || adjDir == dir.m_122427_()) || front && (adjDir == dir.m_122424_() || adjDir == dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        boolean adjTop;
        if (!rot.isVertical() || side != rotDir.m_122424_()) {
            return false;
        }
        if (adjState.m_61143_((Property)StairBlock.f_56843_) != StairsShape.STRAIGHT) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        boolean bl = adjTop = adjState.m_61143_((Property)StairBlock.f_56842_) == Half.TOP;
        if (!front && adjDir == dir || front && adjDir == dir.m_122424_()) {
            return adjTop == (rot == HorizontalRotation.DOWN) && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (!rot.isVertical() || side != rotDir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if ((adjDir == dir || adjDir == dir.m_122424_()) && adjTop == (rot == HorizontalRotation.DOWN)) {
            return SideSkipPredicate.compareState(level, pos, side, side, front ? dir.m_122424_() : dir);
        }
        return false;
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (rot.isVertical() || side != rotDir.m_122424_()) {
            return false;
        }
        if (adjState.m_61143_(PropertyHolder.STAIRS_TYPE) != StairsType.VERTICAL) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (!front && (adjDir == dir && rot == HorizontalRotation.RIGHT || adjDir == dir.m_122427_() && rot == HorizontalRotation.LEFT)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (front && (adjDir == dir.m_122424_() && rot == HorizontalRotation.LEFT || adjDir == dir.m_122428_() && rot == HorizontalRotation.RIGHT)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstVerticalDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (rot.isVertical() || side != rotDir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (!front && (adjDir == dir && rot == HorizontalRotation.RIGHT || adjDir == dir.m_122427_() && rot == HorizontalRotation.LEFT)) {
            return SideSkipPredicate.compareState(level, pos, side, side, adjDir);
        }
        if (front && (adjDir == dir.m_122424_() && rot == HorizontalRotation.LEFT || adjDir == dir.m_122428_() && rot == HorizontalRotation.RIGHT)) {
            return SideSkipPredicate.compareState(level, pos, side, side, adjDir);
        }
        if (front && (adjDir == dir || adjDir == dir.m_122427_()) || !front && (adjDir == dir.m_122424_() || adjDir == dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side, side, adjDir.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (side != rotDir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (rot.isVertical()) {
            if ((Boolean)adjState.m_61143_((Property)FramedProperties.TOP) != (rot == HorizontalRotation.UP)) {
                return false;
            }
            if (!adjRight && (adjDir == dir.m_122427_() && !front || adjDir == dir.m_122428_() && front)) {
                return SideSkipPredicate.compareState(level, pos, side);
            }
            if (adjRight && (adjDir == dir.m_122428_() && !front || adjDir == dir.m_122427_() && front)) {
                return SideSkipPredicate.compareState(level, pos, side);
            }
        } else if (adjDir == side.m_122424_()) {
            if (!adjRight && (adjDir == dir.m_122427_() && !front || adjDir == dir.m_122428_() && front)) {
                return SideSkipPredicate.compareState(level, pos, side);
            }
            if (adjRight && (adjDir == dir.m_122428_() && !front || adjDir == dir.m_122427_() && front)) {
                return SideSkipPredicate.compareState(level, pos, side);
            }
        }
        return false;
    }
}

