/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.skippreds.FlatElevatedSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.FlatInnerSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;

public final class SlabSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        if (Utils.isY(side)) {
            return SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            return switch (type) {
                case BlockType.FRAMED_SLAB -> SlabSkipPredicate.testAgainstSlab(level, pos, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLAB -> SlabSkipPredicate.testAgainstDoubleSlab(level, pos, top, side);
                case BlockType.FRAMED_SLAB_EDGE -> SlabSkipPredicate.testAgainstEdge(level, pos, top, adjState, side);
                case BlockType.FRAMED_STAIRS -> SlabSkipPredicate.testAgainstStairs(level, pos, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> SlabSkipPredicate.testAgainstDoubleStairs(level, pos, top, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB -> SlabSkipPredicate.testAgainstSlopeSlab(level, pos, top, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> SlabSkipPredicate.testAgainstElevatedSlopeSlab(level, pos, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_SLAB -> SlabSkipPredicate.testAgainstDoubleSlopeSlab(level, pos, top, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB -> SlabSkipPredicate.testAgainstInverseDoubleSlopeSlab(level, pos, top, adjState, side);
                case BlockType.FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB -> SlabSkipPredicate.testAgainstElevatedDoubleSlopeSlab(level, pos, top, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> SlabSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> SlabSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(level, pos, top, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER -> SlabSkipPredicate.testAgainstFlatDoubleSlopeSlabCorner(level, pos, top, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER -> SlabSkipPredicate.testAgainstFlatInverseDoubleSlopeSlabCorner(level, pos, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_DOUBLE_SLOPE_SLAB_CORNER -> SlabSkipPredicate.testAgainstFlatElevatedDoubleSlopeSlabCorner(level, pos, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> SlabSkipPredicate.testAgainstVerticalHalfStairs(level, pos, top, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstSlab(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        if (top != (Boolean)adjState.m_61143_((Property)FramedProperties.TOP)) {
            return false;
        }
        Direction camoSide = top ? Direction.UP : Direction.DOWN;
        return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
    }

    private static boolean testAgainstDoubleSlab(BlockGetter level, BlockPos pos, boolean top, Direction side) {
        Direction face = top ? Direction.UP : Direction.DOWN;
        return SideSkipPredicate.compareState(level, pos, side, face, face);
    }

    private static boolean testAgainstEdge(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        if (top != (Boolean)adjState.m_61143_((Property)FramedProperties.TOP)) {
            return false;
        }
        if (adjState.m_61143_((Property)FramedProperties.FACING_HOR) != side.m_122424_()) {
            return false;
        }
        Direction camoSide = top ? Direction.UP : Direction.DOWN;
        return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        boolean bl = adjTop = adjState.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        if (top == adjTop && StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        Direction face = top ? Direction.UP : Direction.DOWN;
        return adjDir == side && SideSkipPredicate.compareState(level, pos, side, face, face);
    }

    private static boolean testAgainstSlopeSlab(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (Utils.isY(side)) {
            return false;
        }
        Direction camoSide = top ? Direction.UP : Direction.DOWN;
        return adjDir == side.m_122424_() && adjTopHalf == top && SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
    }

    private static boolean testAgainstElevatedSlopeSlab(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (Utils.isY(side)) {
            return false;
        }
        Direction camoSide = top ? Direction.UP : Direction.DOWN;
        return adjDir == side && adjTop == top && SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
    }

    private static boolean testAgainstDoubleSlopeSlab(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (Utils.isY(side)) {
            return false;
        }
        Direction camoSide = top ? Direction.UP : Direction.DOWN;
        return (adjDir == side || adjDir == side.m_122424_()) && adjTopHalf == top && SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (Utils.isY(side)) {
            return false;
        }
        Direction camoSide = top ? Direction.UP : Direction.DOWN;
        return (adjDir == side && !top || adjDir == side.m_122424_() && top) && SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
    }

    private static boolean testAgainstElevatedDoubleSlopeSlab(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (!Utils.isY(side) && adjDir == side) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
        }
        return false;
    }

    private static boolean testAgainstFlatInnerSlopeSlabCorner(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTopHalf == top && FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(adjDir, side.m_122424_())) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, adjDir);
        }
        return false;
    }

    private static boolean testAgainstFlatElevatedSlopeSlabCorner(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == top && FlatElevatedSlopeSlabCornerSkipPredicate.isSlabSide(adjDir, side.m_122424_())) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTopHalf == top && FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(adjDir, side.m_122424_())) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstFlatInverseDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == top && FlatInnerSlopeSlabCornerSkipPredicate.isInverseSlabSide(adjDir, side.m_122424_())) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
        }
        return false;
    }

    private static boolean testAgainstFlatElevatedDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (FlatInnerSlopeSlabCornerSkipPredicate.isInverseSlabSide(adjDir, side.m_122424_())) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
        }
        return false;
    }

    private static boolean testAgainstVerticalHalfStairs(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (Utils.isY(side)) {
            return false;
        }
        if (adjTop == top && (adjDir == side.m_122424_() || adjDir == side.m_122428_())) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
        }
        return false;
    }
}

