/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.FlatElevatedSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.FlatExtendedSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.FlatInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.FlatInnerSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;

public final class SlabEdgeSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            return switch (type) {
                case BlockType.FRAMED_SLAB_EDGE -> SlabEdgeSkipPredicate.testAgainstEdge(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_SLAB -> SlabEdgeSkipPredicate.testAgainstSlab(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLAB -> SlabEdgeSkipPredicate.testAgainstDoubleSlab(level, pos, dir, top, side);
                case BlockType.FRAMED_SLAB_CORNER -> SlabEdgeSkipPredicate.testAgainstCorner(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_PANEL -> SlabEdgeSkipPredicate.testAgainstPanel(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_PANEL -> SlabEdgeSkipPredicate.testAgainstDoublePanel(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_STAIRS -> SlabEdgeSkipPredicate.testAgainstStairs(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> SlabEdgeSkipPredicate.testAgainstDoubleStairs(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> SlabEdgeSkipPredicate.testAgainstVerticalStairs(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> SlabEdgeSkipPredicate.testAgainstHalfStairs(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB -> SlabEdgeSkipPredicate.testAgainstSlopeSlab(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> SlabEdgeSkipPredicate.testAgainstElevatedSlopeSlab(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_SLAB -> SlabEdgeSkipPredicate.testAgainstDoubleSlopeSlab(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB -> SlabEdgeSkipPredicate.testAgainstInverseDoubleSlopeSlab(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB -> SlabEdgeSkipPredicate.testAgainstElevatedDoubleSlopeSlab(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> SlabEdgeSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> SlabEdgeSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER -> SlabEdgeSkipPredicate.testAgainstFlatDoubleSlopeSlabCorner(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER -> SlabEdgeSkipPredicate.testAgainstFlatInverseDoubleSlopeSlabCorner(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_DOUBLE_SLOPE_SLAB_CORNER -> SlabEdgeSkipPredicate.testAgainstFlatElevatedDoubleSlopeSlabCorner(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> SlabEdgeSkipPredicate.testAgainstVerticalHalfStairs(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> SlabEdgeSkipPredicate.testAgainstSlopePanel(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> SlabEdgeSkipPredicate.testAgainstExtendedSlopePanel(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> SlabEdgeSkipPredicate.testAgainstDoubleSlopePanel(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> SlabEdgeSkipPredicate.testAgainstInverseDoubleSlopePanel(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL -> SlabEdgeSkipPredicate.testAgainstExtendedDoubleSlopePanel(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> SlabEdgeSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> SlabEdgeSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER -> SlabEdgeSkipPredicate.testAgainstFlatDoubleSlopePanelCorner(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER -> SlabEdgeSkipPredicate.testAgainstFlatInverseDoubleSlopePanelCorner(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER -> SlabEdgeSkipPredicate.testAgainstFlatExtendedDoubleSlopePanelCorner(level, pos, dir, top, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstEdge(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (side == dir && adjDir == side.m_122424_()) {
            return top == adjTop && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        if (side == dir.m_122427_() || side == dir.m_122428_()) {
            return dir == adjDir && top == adjTop && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        if (Utils.isY(side) && dir == adjDir) {
            return top != adjTop && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (side != dir || top != (Boolean)adjState.m_61143_((Property)FramedProperties.TOP)) {
            return false;
        }
        return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
    }

    private static boolean testAgainstDoubleSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, Direction side) {
        if (side != dir) {
            return false;
        }
        return SideSkipPredicate.compareState(level, pos, side, dir, top ? Direction.UP : Direction.DOWN);
    }

    private static boolean testAgainstCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (side == dir.m_122427_() && adjDir == dir || side == dir.m_122428_() && adjDir == dir.m_122427_()) {
            return top == adjTop && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!Utils.isY(side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (dir != adjDir) {
            return false;
        }
        if (side == Direction.UP && top || side == Direction.DOWN && !top) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!Utils.isY(side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_NE);
        if (dir != adjDir && dir != adjDir.m_122424_()) {
            return false;
        }
        if (side == Direction.UP && top || side == Direction.DOWN && !top) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        boolean bl = adjTop = adjState.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        if (top && side == Direction.UP || !top && side == Direction.DOWN) {
            if (adjShape != StairsShape.STRAIGHT || dir != adjDir) {
                return false;
            }
            return top == adjTop && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        if (top == adjTop && side == dir && StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if ((top && side == Direction.UP || !top && side == Direction.DOWN) && (adjDir == dir || adjDir == dir.m_122424_())) {
            return top == adjTop && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (side == dir && adjDir == dir) {
            return SideSkipPredicate.compareState(level, pos, side, dir, top ? Direction.UP : Direction.DOWN);
        }
        if (side == dir.m_122427_() || side == dir.m_122428_()) {
            return adjDir == dir.m_122424_() && top != adjTop && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (adjType == StairsType.VERTICAL) {
            return false;
        }
        if (side == dir.m_122428_() && adjDir == dir || side == dir.m_122427_() && adjDir == dir.m_122427_()) {
            return top != adjType.isTop() && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (adjRight && adjDir == dir.m_122428_() || !adjRight && adjDir == dir.m_122427_()) {
            if (Utils.isY(side) && side == Direction.DOWN == adjTop && adjTop != top) {
                return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
            }
            return side == adjDir && adjTop == top && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (side != dir) {
            return false;
        }
        return adjDir == dir.m_122424_() && adjTopHalf == top && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
    }

    private static boolean testAgainstElevatedSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (side != dir) {
            return false;
        }
        return adjDir == dir && adjTop == top && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
    }

    private static boolean testAgainstDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (side != dir) {
            return false;
        }
        return (adjDir == dir || adjDir == dir.m_122424_()) && adjTopHalf == top && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (side != dir) {
            return false;
        }
        return (adjDir == dir && !top || adjDir == dir.m_122424_() && top) && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
    }

    private static boolean testAgainstElevatedDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (side != dir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        return adjDir == dir && SideSkipPredicate.compareState(level, pos, side, dir, top ? Direction.UP : Direction.DOWN);
    }

    private static boolean testAgainstFlatInnerSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTopHalf == top && side == dir && FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(adjDir, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, adjDir);
        }
        return false;
    }

    private static boolean testAgainstFlatElevatedSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (side != dir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == top && FlatElevatedSlopeSlabCornerSkipPredicate.isSlabSide(adjDir, side.m_122424_())) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (side != dir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTopHalf == top && FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(adjDir, side.m_122424_())) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstFlatInverseDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (side != dir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == top && FlatInnerSlopeSlabCornerSkipPredicate.isInverseSlabSide(adjDir, side.m_122424_())) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
        }
        return false;
    }

    private static boolean testAgainstFlatElevatedDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (side != dir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (FlatInnerSlopeSlabCornerSkipPredicate.isInverseSlabSide(adjDir, side.m_122424_())) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
        }
        return false;
    }

    private static boolean testAgainstVerticalHalfStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (Utils.isY(side) || side == dir.m_122424_() || adjTop != top) {
            return false;
        }
        if (side == dir && (adjDir == side.m_122424_() || adjDir == side.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        if (side == dir.m_122427_() && adjDir == dir.m_122427_() || side == dir.m_122428_() && adjDir == dir) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstSlopePanel(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (!adjRot.isVertical() || side != adjRot.withFacing(adjDir)) {
            return false;
        }
        if (top == (adjRot == HorizontalRotation.UP) && (adjDir == dir && !adjFront || adjDir == dir.m_122424_() && adjFront)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!Utils.isY(side) || !top && side != Direction.DOWN || top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return adjDir == dir && top == (adjRot == HorizontalRotation.DOWN) && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
    }

    private static boolean testAgainstDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (!adjRot.isVertical() || side.m_122434_() != adjRot.withFacing(adjDir).m_122434_()) {
            return false;
        }
        if (top == (side == Direction.UP) && (adjDir == dir && !adjFront || adjDir == dir.m_122424_() && adjFront)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjUp;
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (!adjRot.isVertical() || side.m_122434_() != adjRot.withFacing(adjDir).m_122434_()) {
            return false;
        }
        boolean bl = adjUp = adjRot == HorizontalRotation.UP;
        if (!adjUp && (!top && adjDir == dir.m_122424_() || top && adjDir == dir)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        if (adjUp && (!top && adjDir == dir || top && adjDir == dir.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstExtendedDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!Utils.isY(side) || !top && side != Direction.DOWN || top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir.m_122434_() == dir.m_122434_() && top == (adjRot == HorizontalRotation.DOWN)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstFlatInnerSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!top && side != Direction.DOWN || top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir == dir && adjFront || adjDir == dir.m_122424_() && !adjFront) {
            return false;
        }
        if (FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!top && side != Direction.DOWN || top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir == dir && FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!top && side != Direction.DOWN || top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_()) && (adjDir == dir && !adjFront || adjDir == dir.m_122424_() && adjFront)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstFlatInverseDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!top && side != Direction.DOWN || top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir == dir && FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!top && side != Direction.DOWN || top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir.m_122434_() == dir.m_122434_() && FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }
}

