/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.StairsType;

public final class SlabCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            return switch (type) {
                case BlockType.FRAMED_SLAB_CORNER -> SlabCornerSkipPredicate.testAgainstCorner(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> SlabCornerSkipPredicate.testAgainstEdge(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> SlabCornerSkipPredicate.testAgainstPillar(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_STAIRS -> SlabCornerSkipPredicate.testAgainstStairs(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> SlabCornerSkipPredicate.testAgainstDoubleStairs(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> SlabCornerSkipPredicate.testAgainstVerticalStairs(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> SlabCornerSkipPredicate.testAgainstVerticalDoubleStairs(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> SlabCornerSkipPredicate.testAgainstHalfStairs(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> SlabCornerSkipPredicate.testAgainstVerticalHalfStairs(level, pos, dir, top, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (side == dir && adjDir == dir.m_122428_() || side == dir.m_122428_() && adjDir == dir.m_122427_()) {
            return top == adjTop && SideSkipPredicate.compareState(level, pos, side);
        }
        if (side == Direction.DOWN && !top && adjTop || side == Direction.UP && top && !adjTop) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstEdge(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (side == dir && adjDir == dir.m_122428_() || side == dir.m_122428_() && adjDir == dir) {
            return top == adjTop && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstPillar(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (top && side == Direction.UP || !top && side == Direction.DOWN) {
            return dir == adjDir && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjTop;
        if (!Utils.isY(side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        boolean bl = adjTop = adjState.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        if (top != adjTop) {
            return false;
        }
        if (adjShape == StairsShape.OUTER_LEFT) {
            return dir == adjDir && SideSkipPredicate.compareState(level, pos, side);
        }
        if (adjShape == StairsShape.OUTER_RIGHT) {
            return dir.m_122428_() == adjDir && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (Utils.isY(side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (side == dir && adjDir == dir.m_122427_() || side == dir.m_122428_() && adjDir == dir.m_122424_()) {
            return top != adjTop && SideSkipPredicate.compareState(level, pos, side, side, adjDir.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (adjType.isTop() == top || dir != adjDir) {
            return false;
        }
        if (Utils.isY(side) || side == dir || side == dir.m_122428_()) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstVerticalDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (adjDir != dir.m_122424_()) {
            return false;
        }
        if (top && side == Direction.UP || !top && side == Direction.DOWN) {
            return SideSkipPredicate.compareState(level, pos, side, side, dir);
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (adjTop != top) {
            return false;
        }
        if (adjRight && adjDir != dir.m_122428_() || !adjRight && adjDir != dir) {
            return false;
        }
        if (adjRight && side == dir.m_122428_() || !adjRight && side == dir || Utils.isY(side) && side == Direction.UP == adjTop) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstVerticalHalfStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjDir != dir || adjTop != top) {
            return false;
        }
        return (side == dir || side == dir.m_122428_()) && SideSkipPredicate.compareState(level, pos, side);
    }
}

