/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public final class FlatSlopeSlabCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        boolean topHalf;
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        if (top == (topHalf = ((Boolean)state.m_61143_((Property)PropertyHolder.TOP_HALF)).booleanValue()) && (topHalf && side == Direction.UP || !topHalf && side == Direction.DOWN)) {
            return SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            return switch (blockType) {
                case BlockType.FRAMED_FLAT_SLOPE_SLAB_CORNER -> FlatSlopeSlabCornerSkipPredicate.testAgainstFlatSlopeSlabCorner(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> FlatSlopeSlabCornerSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB -> FlatSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_SLAB -> FlatSlopeSlabCornerSkipPredicate.testAgainstDoubleSlopeSlab(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB -> FlatSlopeSlabCornerSkipPredicate.testAgainstInverseDoubleSlopeSlab(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB -> FlatSlopeSlabCornerSkipPredicate.testAgainstElevatedDoubleSlopeSlab(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER -> FlatSlopeSlabCornerSkipPredicate.testAgainstFlatDoubleSlopeSlabCorner(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER -> FlatSlopeSlabCornerSkipPredicate.testAgainstFlatInverseDoubleSlopeSlabCorner(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_DOUBLE_SLOPE_SLAB_CORNER -> FlatSlopeSlabCornerSkipPredicate.testAgainstFlatElevatedDoubleSlopeSlabCorner(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_INNER_DOUBLE_SLOPE_SLAB_CORNER -> FlatSlopeSlabCornerSkipPredicate.testAgainstFlatElevatedInnerDoubleSlopeSlabCorner(level, pos, dir, top, topHalf, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstFlatSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTop != top || adjTopHalf != topHalf) {
            return false;
        }
        if (side == dir && adjDir == dir.m_122428_() || side == dir.m_122428_() && adjDir == dir.m_122427_()) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstFlatInnerSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTop != top || adjTopHalf != topHalf) {
            return false;
        }
        if (adjDir == dir && (side == dir || side == dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTop != top || adjTopHalf != topHalf) {
            return false;
        }
        if (side == dir && adjDir == dir.m_122428_() || side == dir.m_122428_() && adjDir == dir) {
            return SideSkipPredicate.compareState(level, pos, side, side, adjDir);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTopHalf != topHalf) {
            return false;
        }
        if (side == dir && (top && adjDir == dir.m_122427_() || !top && adjDir == dir.m_122428_())) {
            Direction camoSide = top ? adjDir.m_122424_() : adjDir;
            return SideSkipPredicate.compareState(level, pos, side, side, camoSide);
        }
        if (side == dir.m_122428_() && (top && adjDir == dir.m_122424_() || !top && adjDir == dir)) {
            Direction camoSide = top ? adjDir.m_122424_() : adjDir;
            return SideSkipPredicate.compareState(level, pos, side, side, camoSide);
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        if (top == topHalf) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (side == dir && (top && adjDir == dir.m_122427_() || !top && adjDir == dir.m_122428_())) {
            Direction camoSide = top ? adjDir.m_122424_() : adjDir;
            return SideSkipPredicate.compareState(level, pos, side, side, camoSide);
        }
        if (side == dir.m_122428_() && (top && adjDir == dir.m_122424_() || !top && adjDir == dir)) {
            Direction camoSide = top ? adjDir.m_122424_() : adjDir;
            return SideSkipPredicate.compareState(level, pos, side, side, camoSide);
        }
        return false;
    }

    private static boolean testAgainstElevatedDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (top != topHalf || adjTop == topHalf) {
            return false;
        }
        if (side == dir && adjDir == dir.m_122427_() || side == dir.m_122428_() && adjDir == dir.m_122424_()) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, side, camoSide);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        boolean sameTop;
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTopHalf != topHalf) {
            return false;
        }
        boolean bl = sameTop = adjTop == top;
        if (side == dir && (sameTop && adjDir == dir || !sameTop && adjDir == dir.m_122427_())) {
            Direction camoSide = sameTop ? adjDir : side.m_122424_();
            return SideSkipPredicate.compareState(level, pos, side, dir, camoSide);
        }
        if (side == dir.m_122428_() && (sameTop && adjDir == dir || !sameTop && adjDir == dir.m_122428_())) {
            Direction camoSide = sameTop ? adjDir : side.m_122424_();
            return SideSkipPredicate.compareState(level, pos, side, dir, camoSide);
        }
        return false;
    }

    private static boolean testAgainstFlatInverseDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == topHalf && adjTop != top && adjDir == dir.m_122424_() && (side == dir.m_122428_() || side == dir)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, adjDir.m_122424_());
        }
        if (adjTop == top && adjTop != topHalf && (side == dir && adjDir == dir.m_122428_() || side == dir.m_122428_() && adjDir == dir.m_122427_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, adjDir);
        }
        return false;
    }

    private static boolean testAgainstFlatElevatedDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop != top && adjTop != topHalf && adjDir == dir.m_122424_() && (side == dir || side == dir.m_122428_())) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, dir, camoSide);
        }
        return false;
    }

    private static boolean testAgainstFlatElevatedInnerDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == top || adjTop == topHalf) {
            return false;
        }
        if (side == dir && adjDir == dir.m_122427_() || side == dir.m_122428_() && adjDir == dir.m_122428_()) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, dir, camoSide);
        }
        return false;
    }
}

