/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public final class FlatSlopePanelCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean front = (Boolean)state.m_61143_((Property)PropertyHolder.FRONT);
        if (side == dir) {
            return !front && SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        HorizontalRotation perpRot = rot.rotate(Rotation.COUNTERCLOCKWISE_90);
        Direction rotDir = rot.withFacing(dir);
        Direction perpRotDir = perpRot.withFacing(dir);
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_FLAT_SLOPE_PANEL_CORNER -> FlatSlopePanelCornerSkipPredicate.testAgainstFlatSlopePanelCorner(level, pos, dir, front, rot, perpRot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> FlatSlopePanelCornerSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, dir, front, rot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER -> FlatSlopePanelCornerSkipPredicate.testAgainstFlatDoubleSlopePanelCorner(level, pos, dir, front, rot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER -> FlatSlopePanelCornerSkipPredicate.testAgainstFlatInverseDoubleSlopePanelCorner(level, pos, dir, front, perpRot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER -> FlatSlopePanelCornerSkipPredicate.testAgainstFlatExtendedDoubleSlopePanelCorner(level, pos, dir, front, perpRot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_INNER_DOUBLE_SLOPE_PANEL_CORNER -> FlatSlopePanelCornerSkipPredicate.testAgainstFlatExtendedInnerDoubleSlopePanelCorner(level, pos, dir, front, rot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> FlatSlopePanelCornerSkipPredicate.testAgainstSlopePanel(level, pos, dir, front, rot, perpRot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> FlatSlopePanelCornerSkipPredicate.testAgainstDoubleSlopePanel(level, pos, dir, front, rot, perpRot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> FlatSlopePanelCornerSkipPredicate.testAgainstInverseDoubleSlopePanel(level, pos, dir, front, rot, perpRot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL -> FlatSlopePanelCornerSkipPredicate.testAgainstExtendedDoubleSlopePanel(level, pos, dir, front, rot, rotDir, perpRotDir, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstFlatSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, HorizontalRotation perpRot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir != dir || adjFront != front) {
            return false;
        }
        if (side == rotDir.m_122424_() && adjRot == perpRot) {
            return SideSkipPredicate.compareState(level, pos, side, rotDir.m_122424_(), rotDir);
        }
        if (side == perpRotDir.m_122424_() && adjRot == rot.rotate(Rotation.CLOCKWISE_90)) {
            return SideSkipPredicate.compareState(level, pos, side, perpRotDir.m_122424_(), perpRotDir);
        }
        return false;
    }

    private static boolean testAgainstFlatInnerSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir == dir && adjFront == front && adjRot == rot && (side == rotDir.m_122424_() || side == perpRotDir.m_122424_())) {
            Direction camoSide = side == rotDir.m_122424_() ? rotDir.m_122424_() : perpRotDir.m_122424_();
            return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (side != rotDir.m_122424_() && side != perpRotDir.m_122424_()) {
            return false;
        }
        if (adjDir == dir && adjFront == front && adjRot == rot) {
            Direction camoSide = side == rotDir.m_122424_() ? rotDir.m_122424_() : perpRotDir.m_122424_();
            return SideSkipPredicate.compareState(level, pos, side, camoSide, adjDir);
        }
        if (adjDir == dir.m_122424_() && adjFront != front) {
            if (side == rotDir.m_122424_() && rot.isSameDir(dir, adjRot, adjDir)) {
                return SideSkipPredicate.compareState(level, pos, side, side, adjDir.m_122424_());
            }
            if (side == perpRotDir.m_122424_() && rot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
                return SideSkipPredicate.compareState(level, pos, side, side, adjDir.m_122424_());
            }
        }
        return false;
    }

    private static boolean testAgainstFlatInverseDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation perpRot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        if (side != rotDir.m_122424_() && side != perpRotDir.m_122424_() || !front) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir == dir.m_122424_() && perpRot.isSameDir(dir, adjRot, adjDir)) {
            return SideSkipPredicate.compareState(level, pos, side, side, adjDir);
        }
        if (adjDir == dir) {
            if (side == rotDir.m_122424_() && perpRot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
                return SideSkipPredicate.compareState(level, pos, side, side, adjDir.m_122424_());
            }
            if (side == perpRotDir.m_122424_() && perpRot.isSameDir(dir, adjRot, adjDir)) {
                return SideSkipPredicate.compareState(level, pos, side, side, adjDir.m_122424_());
            }
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation perpRot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        if (side != rotDir.m_122424_() && side != perpRotDir.m_122424_() || front) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir == dir.m_122424_() && perpRot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
            return SideSkipPredicate.compareState(level, pos, side, side, adjDir.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedInnerDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        if (side != rotDir.m_122424_() && side != perpRotDir.m_122424_() || front) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir != dir.m_122424_()) {
            return false;
        }
        if (side == rotDir.m_122424_() && rot.isSameDir(dir, adjRot, adjDir)) {
            return SideSkipPredicate.compareState(level, pos, side, side, adjDir.m_122424_());
        }
        if (side == perpRotDir.m_122424_() && rot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
            return SideSkipPredicate.compareState(level, pos, side, side, adjDir.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstSlopePanel(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, HorizontalRotation perpRot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir != dir || adjFront != front) {
            return false;
        }
        if (side == rotDir.m_122424_() && adjRot == perpRot) {
            return SideSkipPredicate.compareState(level, pos, side, rotDir.m_122424_(), adjRot.withFacing(adjDir));
        }
        if (side == perpRotDir.m_122424_() && adjRot == rot) {
            return SideSkipPredicate.compareState(level, pos, side, perpRotDir.m_122424_(), adjRot.withFacing(adjDir));
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, HorizontalRotation perpRot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (side == rotDir.m_122424_()) {
            if (adjDir == dir && adjFront == front && perpRot.isSameDir(dir, adjRot, adjDir)) {
                Direction camoSide = adjRot.withFacing(adjDir).m_122424_();
                return SideSkipPredicate.compareState(level, pos, side, rotDir.m_122424_(), camoSide);
            }
            if (adjDir == dir.m_122424_() && adjFront != front && perpRot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
                Direction camoSide = adjRot.getOpposite().withFacing(adjDir).m_122424_();
                return SideSkipPredicate.compareState(level, pos, side, rotDir.m_122424_(), camoSide);
            }
        } else if (side == perpRotDir.m_122424_()) {
            if (adjDir == dir && adjFront == front && rot.isSameDir(dir, adjRot, adjDir)) {
                Direction camoSide = adjRot.withFacing(adjDir).m_122424_();
                return SideSkipPredicate.compareState(level, pos, side, perpRotDir.m_122424_(), camoSide);
            }
            if (adjDir == dir.m_122424_() && adjFront != front && rot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
                Direction camoSide = adjRot.getOpposite().withFacing(adjDir).m_122424_();
                return SideSkipPredicate.compareState(level, pos, side, perpRotDir.m_122424_(), camoSide);
            }
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, HorizontalRotation perpRot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        if (!front) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (side == rotDir.m_122424_()) {
            if (adjDir == dir && perpRot.isSameDir(dir, adjRot, adjDir)) {
                Direction camoSide = adjRot.withFacing(adjDir).m_122424_();
                return SideSkipPredicate.compareState(level, pos, side, rotDir, camoSide);
            }
            if (adjDir == dir.m_122424_() && perpRot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
                Direction camoSide = adjRot.withFacing(adjDir);
                return SideSkipPredicate.compareState(level, pos, side, rotDir, camoSide);
            }
        } else if (side == perpRotDir.m_122424_()) {
            if (adjDir == dir && rot.isSameDir(dir, adjRot, adjDir)) {
                Direction camoSide = adjRot.withFacing(adjDir).m_122424_();
                return SideSkipPredicate.compareState(level, pos, side, rotDir, camoSide);
            }
            if (adjDir == dir.m_122424_() && rot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
                Direction camoSide = adjRot.withFacing(adjDir);
                return SideSkipPredicate.compareState(level, pos, side, rotDir, camoSide);
            }
        }
        return false;
    }

    private static boolean testAgainstExtendedDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        if (front) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir != dir.m_122424_()) {
            return false;
        }
        if (side == rotDir.m_122424_() && rot.rotate(Rotation.CLOCKWISE_90).isSameDir(dir, adjRot, adjDir)) {
            return SideSkipPredicate.compareState(level, pos, side, perpRotDir, dir);
        }
        if (side == perpRotDir.m_122424_() && rot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
            return SideSkipPredicate.compareState(level, pos, side, rotDir, dir);
        }
        return false;
    }
}

