/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.skippreds.FlatElevatedSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.VerticalHalfStairsSkipPredicate;

public final class FlatInnerSlopeSlabCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        boolean topHalf;
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        if (top == (topHalf = ((Boolean)state.m_61143_((Property)PropertyHolder.TOP_HALF)).booleanValue()) && (topHalf && side == Direction.UP || !topHalf && side == Direction.DOWN)) {
            return SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            return switch (blockType) {
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatSlopeSlabCorner(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstElevatedSlopeSlab(level, pos, dir, topHalf, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstDoubleSlopeSlab(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstInverseDoubleSlopeSlab(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstElevatedDoubleSlopeSlab(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(level, pos, dir, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatDoubleSlopeSlabCorner(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatInverseDoubleSlopeSlabCorner(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_DOUBLE_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatElevatedDoubleSlopeSlabCorner(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_INNER_DOUBLE_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatElevatedInnerDoubleSlopeSlabCorner(level, pos, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlab(level, pos, dir, topHalf, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstDoubleSlab(level, pos, dir, topHalf, side);
                case BlockType.FRAMED_SLAB_EDGE -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlabEdge(level, pos, dir, topHalf, adjState, side);
                case BlockType.FRAMED_STAIRS -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstStairs(level, pos, dir, topHalf, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstDoubleStairs(level, pos, dir, topHalf, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstVerticalHalfStairs(level, pos, dir, topHalf, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstFlatInnerSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTopHalf != topHalf) {
            return false;
        }
        if (FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(dir, side) && FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(adjDir, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir.m_122424_());
        }
        if (adjTop != top) {
            return false;
        }
        if (side == dir.m_122424_() && adjDir == dir.m_122428_() || side == dir.m_122427_() && adjDir == dir.m_122427_()) {
            return SideSkipPredicate.compareState(level, pos, side, dir, adjDir);
        }
        return false;
    }

    private static boolean testAgainstFlatSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTop != top || adjTopHalf != topHalf) {
            return false;
        }
        if (adjDir == dir && (side == dir.m_122424_() || side == dir.m_122427_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTopHalf != topHalf) {
            return false;
        }
        if (FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(dir, side) && adjDir == side.m_122424_()) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (adjTop != top) {
            return false;
        }
        if (side == dir.m_122424_() && adjDir == dir.m_122428_() || side == dir.m_122427_() && adjDir == dir) {
            return SideSkipPredicate.compareState(level, pos, side, dir, adjDir);
        }
        return false;
    }

    private static boolean testAgainstElevatedSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop != topHalf) {
            return false;
        }
        if (FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(dir, side) && adjDir == side) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTopHalf != topHalf) {
            return false;
        }
        if (FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(dir, side) && (adjDir == side || adjDir == side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (side == dir.m_122424_() && (top && adjDir == dir.m_122427_() || !top && adjDir == dir.m_122428_())) {
            Direction camoDir = top ? adjDir.m_122424_() : adjDir;
            return SideSkipPredicate.compareState(level, pos, side, dir, camoDir);
        }
        if (side == dir.m_122427_() && (top && adjDir == dir.m_122424_() || !top && adjDir == dir)) {
            Direction camoDir = top ? adjDir.m_122424_() : adjDir;
            return SideSkipPredicate.compareState(level, pos, side, dir, camoDir);
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(dir, side) && (topHalf && adjDir == side.m_122424_() || !topHalf && adjDir == side)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (top == topHalf) {
            return false;
        }
        if (side == dir.m_122424_() && (top && adjDir == dir.m_122427_() || !top && adjDir == dir.m_122428_())) {
            Direction camoSide = top ? adjDir.m_122424_() : adjDir;
            return SideSkipPredicate.compareState(level, pos, side, dir, camoSide);
        }
        if (side == dir.m_122427_() && (top && adjDir == dir.m_122424_() || !top && adjDir == dir)) {
            Direction camoSide = top ? adjDir.m_122424_() : adjDir;
            return SideSkipPredicate.compareState(level, pos, side, dir, camoSide);
        }
        return false;
    }

    private static boolean testAgainstElevatedDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(dir, side) && adjDir == side) {
            Direction camoSide = topHalf ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, dir, camoSide);
        }
        if (topHalf != top || adjTop == top) {
            return false;
        }
        if (side == dir.m_122424_() && adjDir == dir.m_122427_() || side == dir.m_122427_() && adjDir == dir.m_122424_()) {
            Direction camoSide = topHalf ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, dir, camoSide);
        }
        return false;
    }

    private static boolean testAgainstFlatElevatedSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == topHalf && FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(dir, side) && FlatElevatedSlopeSlabCornerSkipPredicate.isSlabSide(adjDir, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        boolean sameTop;
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTopHalf != topHalf) {
            return false;
        }
        if (FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(dir, side) && FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(adjDir, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        boolean bl = sameTop = adjTop == top;
        if (sameTop && (side == dir.m_122427_() && adjDir == dir.m_122427_() || side == dir.m_122424_() && adjDir == dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, adjDir);
        }
        if (!(sameTop || adjDir != dir.m_122424_() || side != dir.m_122427_() && side != dir.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstFlatInverseDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == topHalf && FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(dir, side) && FlatInnerSlopeSlabCornerSkipPredicate.isInverseSlabSide(adjDir, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, adjDir.m_122424_());
        }
        if (adjTop == topHalf && adjTop != top && (side == dir.m_122427_() && adjDir == dir.m_122428_() || side == dir.m_122424_() && adjDir == dir.m_122427_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, adjDir.m_122424_());
        }
        if (adjTop == top && adjTop != topHalf && adjDir == dir && (side == dir.m_122427_() || side == dir.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, adjDir);
        }
        return false;
    }

    private static boolean testAgainstFlatElevatedDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(dir, side) && FlatInnerSlopeSlabCornerSkipPredicate.isInverseSlabSide(adjDir, side.m_122424_())) {
            Direction camoSide = topHalf ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, dir, camoSide);
        }
        if (adjTop == top || adjTop == topHalf) {
            return false;
        }
        if (side == dir.m_122427_() && adjDir == dir.m_122428_() || side == dir.m_122424_() && adjDir == dir.m_122427_()) {
            Direction camoSide = topHalf ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, dir, camoSide);
        }
        return false;
    }

    private static boolean testAgainstFlatElevatedInnerDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop != top && adjTop != topHalf && adjDir == dir.m_122424_() && (side == dir.m_122427_() || side == dir.m_122424_())) {
            Direction camoSide = topHalf ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, dir, camoSide);
        }
        return false;
    }

    private static boolean testAgainstSlab(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (topHalf != adjTop || !FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(dir, side)) {
            return false;
        }
        return SideSkipPredicate.compareState(level, pos, side);
    }

    private static boolean testAgainstDoubleSlab(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, Direction side) {
        if (!FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(dir, side)) {
            return false;
        }
        Direction camoSide = topHalf ? Direction.UP : Direction.DOWN;
        return SideSkipPredicate.compareState(level, pos, side, dir, camoSide);
    }

    private static boolean testAgainstSlabEdge(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == topHalf && FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(dir, side) && adjDir == side.m_122424_()) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)StairBlock.f_56843_);
        boolean bl = adjTop = adjState.m_61143_((Property)StairBlock.f_56842_) == Half.TOP;
        if (topHalf == adjTop && FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(dir, side) && StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        if (FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(dir, side) && adjDir == side) {
            Direction camoSide = topHalf ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, dir, camoSide);
        }
        return false;
    }

    private static boolean testAgainstVerticalHalfStairs(BlockGetter level, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == topHalf && FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(dir, side) && VerticalHalfStairsSkipPredicate.isSlabSide(adjDir, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    public static boolean isSlabSide(Direction dir, Direction side) {
        return side == dir || side == dir.m_122428_();
    }

    public static boolean isInverseSlabSide(Direction dir, Direction side) {
        return FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(dir.m_122424_(), side);
    }
}

