/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.FlatExtendedSlopePanelCornerSkipPredicate;

public final class FlatInnerSlopePanelCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean front = (Boolean)state.m_61143_((Property)PropertyHolder.FRONT);
        if (side == dir) {
            return !front && SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        HorizontalRotation perpRot = rot.rotate(Rotation.COUNTERCLOCKWISE_90);
        Direction rotDir = rot.withFacing(dir);
        Direction perpRotDir = perpRot.withFacing(dir);
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> FlatInnerSlopePanelCornerSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, dir, front, rot, perpRot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_FLAT_SLOPE_PANEL_CORNER -> FlatInnerSlopePanelCornerSkipPredicate.testAgainstFlatSlopePanelCorner(level, pos, dir, front, rot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> FlatInnerSlopePanelCornerSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(level, pos, dir, front, rot, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER -> FlatInnerSlopePanelCornerSkipPredicate.testAgainstFlatDoubleSlopePanelCorner(level, pos, dir, front, rot, perpRot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER -> FlatInnerSlopePanelCornerSkipPredicate.testAgainstFlatInverseDoubleSlopePanelCorner(level, pos, dir, front, rot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER -> FlatInnerSlopePanelCornerSkipPredicate.testAgainstFlatExtendedDoubleSlopePanelCorner(level, pos, dir, front, rot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_INNER_DOUBLE_SLOPE_PANEL_CORNER -> FlatInnerSlopePanelCornerSkipPredicate.testAgainstFlatExtendedInnerDoubleSlopePanelCorner(level, pos, dir, front, perpRot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> FlatInnerSlopePanelCornerSkipPredicate.testAgainstSlopePanel(level, pos, dir, front, rot, perpRot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> FlatInnerSlopePanelCornerSkipPredicate.testAgainstExtendedSlopePanel(level, pos, dir, front, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> FlatInnerSlopePanelCornerSkipPredicate.testAgainstDoubleSlopePanel(level, pos, dir, front, rot, perpRot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> FlatInnerSlopePanelCornerSkipPredicate.testAgainstInverseDoubleSlopePanel(level, pos, dir, front, rot, perpRot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL -> FlatInnerSlopePanelCornerSkipPredicate.testAgainstExtendedDoubleSlopePanel(level, pos, dir, front, rot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> FlatInnerSlopePanelCornerSkipPredicate.testAgainstSlabEdge(level, pos, dir, front, rot, adjState, side);
                case BlockType.FRAMED_PANEL -> FlatInnerSlopePanelCornerSkipPredicate.testAgainstPanel(level, pos, dir, front, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_PANEL -> FlatInnerSlopePanelCornerSkipPredicate.testAgainstDoublePanel(level, pos, dir, front, rot, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> FlatInnerSlopePanelCornerSkipPredicate.testAgainstCornerPillar(level, pos, dir, front, rot, adjState, side);
                case BlockType.FRAMED_STAIRS -> FlatInnerSlopePanelCornerSkipPredicate.testAgainstStairs(level, pos, dir, front, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> FlatInnerSlopePanelCornerSkipPredicate.testAgainstDoubleStairs(level, pos, dir, front, rot, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> FlatInnerSlopePanelCornerSkipPredicate.testAgainstVerticalStairs(level, pos, dir, front, rot, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> FlatInnerSlopePanelCornerSkipPredicate.testAgainstVerticalDoubleStairs(level, pos, dir, front, rot, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> FlatInnerSlopePanelCornerSkipPredicate.testAgainstHalfStairs(level, pos, dir, front, rot, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstFlatInnerSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, HorizontalRotation perpRot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side) && FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_())) {
            if (adjDir == dir && adjFront == front || adjDir == dir.m_122424_() && adjFront != front) {
                return SideSkipPredicate.compareState(level, pos, side);
            }
            return false;
        }
        if (adjDir != dir || adjFront != front) {
            return false;
        }
        if (side == rotDir && adjRot == perpRot || side == perpRotDir && adjRot == rot.rotate(Rotation.CLOCKWISE_90)) {
            return SideSkipPredicate.compareState(level, pos, side, side.m_122424_(), side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstFlatSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir == dir && adjFront == front && adjRot == rot && (side == rotDir || side == perpRotDir)) {
            return SideSkipPredicate.compareState(level, pos, side, side.m_122424_(), side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, BlockState adjState, Direction side) {
        HorizontalRotation adjRot;
        if (!FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION)), side.m_122424_()) && (adjDir == dir && !front || adjDir == dir.m_122424_() && front)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, HorizontalRotation perpRot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side) && FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_())) {
            if (adjDir == dir && adjFront == front || adjDir == dir.m_122424_() && adjFront != front) {
                return SideSkipPredicate.compareState(level, pos, side);
            }
            return false;
        }
        if (side == rotDir) {
            if (adjDir == dir && adjFront == front && adjRot == perpRot) {
                return SideSkipPredicate.compareState(level, pos, side, rotDir.m_122424_(), adjDir);
            }
            if (adjDir == dir.m_122424_() && adjFront != front && perpRot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
                return SideSkipPredicate.compareState(level, pos, side, rotDir.m_122424_(), adjDir.m_122424_());
            }
        } else if (side == perpRotDir) {
            if (adjDir == dir && adjFront == front && adjRot == rot.rotate(Rotation.CLOCKWISE_90)) {
                return SideSkipPredicate.compareState(level, pos, side, perpRotDir.m_122424_(), adjDir);
            }
            if (adjDir == dir.m_122424_() && adjFront != front && perpRot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
                return SideSkipPredicate.compareState(level, pos, side, perpRotDir.m_122424_(), adjDir.m_122424_());
            }
        }
        return false;
    }

    private static boolean testAgainstFlatInverseDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side) && FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_())) {
            if (adjDir == dir && !front || adjDir == dir.m_122424_() && front) {
                return SideSkipPredicate.compareState(level, pos, side);
            }
            return false;
        }
        if (!front || side != rotDir && side != perpRotDir) {
            return false;
        }
        if (adjDir == dir && rot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
            return SideSkipPredicate.compareState(level, pos, side, side.m_122424_(), adjDir.m_122424_());
        }
        if (adjDir == dir.m_122424_()) {
            if (side == rotDir && rot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
                return SideSkipPredicate.compareState(level, pos, side, rotDir.m_122424_(), adjDir);
            }
            if (side == perpRotDir && rot.isSameDir(dir, adjRot, adjDir)) {
                return SideSkipPredicate.compareState(level, pos, side, perpRotDir.m_122424_(), adjDir);
            }
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        HorizontalRotation adjRot;
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION)), side.m_122424_()) && FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            Direction camoSide = front ? dir.m_122424_() : dir;
            return adjDir.m_122434_() == dir.m_122434_() && SideSkipPredicate.compareState(level, pos, side, side, camoSide);
        }
        if (adjDir != dir.m_122424_() || front) {
            return false;
        }
        if (side == rotDir && rot.isSameDir(dir, adjRot, adjDir)) {
            return SideSkipPredicate.compareState(level, pos, side, side, adjDir.m_122424_());
        }
        if (side == perpRotDir && rot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
            return SideSkipPredicate.compareState(level, pos, side, side, adjDir.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedInnerDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation perpRot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        if (side != rotDir && side != perpRotDir || front) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir == dir.m_122424_() && perpRot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
            return SideSkipPredicate.compareState(level, pos, side, side, adjDir.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstSlopePanel(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, HorizontalRotation perpRot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side) && side == adjRot.withFacing(adjDir)) {
            if (adjDir == dir && adjFront == front || adjDir == dir.m_122424_() && adjFront != front) {
                return SideSkipPredicate.compareState(level, pos, side);
            }
            return false;
        }
        if (adjDir != dir || adjFront != front) {
            return false;
        }
        if (side == rotDir && adjRot == perpRot || side == perpRotDir && adjRot == rot) {
            return SideSkipPredicate.compareState(level, pos, side, side.m_122424_(), side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side) && adjRot.withFacing(adjDir) == side.m_122424_() && (adjDir == dir && !front || adjDir == dir.m_122424_() && front)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, HorizontalRotation perpRot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        Direction adjRotDir = adjRot.withFacing(adjDir);
        if (FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side) && (side == adjRotDir || side == adjRotDir.m_122424_()) && (adjDir == dir && adjFront == front || adjDir == dir.m_122424_() && adjFront != front)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (side == rotDir) {
            if (adjDir == dir && adjFront == front && perpRot.isSameDir(dir, adjRot, adjDir)) {
                Direction camoSide = adjRot.withFacing(adjDir).m_122424_();
                return SideSkipPredicate.compareState(level, pos, side, rotDir.m_122424_(), camoSide);
            }
            if (adjDir == dir.m_122424_() && adjFront != front && perpRot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
                Direction camoSide = adjRot.getOpposite().withFacing(adjDir).m_122424_();
                return SideSkipPredicate.compareState(level, pos, side, rotDir.m_122424_(), camoSide);
            }
        } else if (side == perpRotDir) {
            if (adjDir == dir && adjFront == front && rot.isSameDir(dir, adjRot, adjDir)) {
                Direction camoSide = adjRot.withFacing(adjDir).m_122424_();
                return SideSkipPredicate.compareState(level, pos, side, perpRotDir.m_122424_(), camoSide);
            }
            if (adjDir == dir.m_122424_() && adjFront != front && rot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
                Direction camoSide = adjRot.getOpposite().withFacing(adjDir).m_122424_();
                return SideSkipPredicate.compareState(level, pos, side, perpRotDir.m_122424_(), camoSide);
            }
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, HorizontalRotation perpRot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        Direction adjRotDir = adjRot.withFacing(adjDir);
        if (FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            if ((adjDir == dir && !front || adjDir == dir.m_122424_() && front) && adjRotDir == side.m_122424_()) {
                return SideSkipPredicate.compareState(level, pos, side);
            }
            if ((adjDir == dir.m_122424_() && !front || adjDir == dir && front) && adjRotDir == side) {
                return SideSkipPredicate.compareState(level, pos, side);
            }
        }
        if (!front) {
            return false;
        }
        if (side == rotDir) {
            if (adjDir == dir && perpRot.isSameDir(dir, adjRot, adjDir)) {
                Direction camoSide = adjRot.withFacing(adjDir).m_122424_();
                return SideSkipPredicate.compareState(level, pos, side, rotDir.m_122424_(), camoSide);
            }
            if (adjDir == dir.m_122424_() && perpRot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
                Direction camoSide = adjRot.withFacing(adjDir);
                return SideSkipPredicate.compareState(level, pos, side, rotDir.m_122424_(), camoSide);
            }
        } else if (side == perpRotDir) {
            if (adjDir == dir && rot.isSameDir(dir, adjRot, adjDir)) {
                Direction camoSide = adjRot.withFacing(adjDir).m_122424_();
                return SideSkipPredicate.compareState(level, pos, side, perpRotDir.m_122424_(), camoSide);
            }
            if (adjDir == dir.m_122424_() && rot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
                Direction camoSide = adjRot.withFacing(adjDir);
                return SideSkipPredicate.compareState(level, pos, side, perpRotDir.m_122424_(), camoSide);
            }
        }
        return false;
    }

    private static boolean testAgainstExtendedDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        Direction adjRotDir = adjRot.withFacing(adjDir);
        if (FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side) && adjRotDir == side.m_122424_() && (adjDir == dir || adjDir == dir.m_122424_())) {
            Direction camoSide = front ? dir.m_122424_() : dir;
            return SideSkipPredicate.compareState(level, pos, side, side, camoSide);
        }
        if (side == rotDir && rot.rotate(Rotation.CLOCKWISE_90).isSameDir(dir, adjRot, adjDir)) {
            return SideSkipPredicate.compareState(level, pos, side, rotDir.m_122424_(), dir);
        }
        if (side == perpRotDir && rot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
            return SideSkipPredicate.compareState(level, pos, side, perpRotDir.m_122424_(), dir);
        }
        return false;
    }

    private static boolean testAgainstSlabEdge(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, BlockState adjState, Direction side) {
        if (!FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side) || !Utils.isY(side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjDir == dir && front || adjDir == dir.m_122424_() && !front) {
            return false;
        }
        if (side == Direction.UP && !adjTop || side == Direction.DOWN && adjTop) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, BlockState adjState, Direction side) {
        if (!FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (adjDir == dir && !front || adjDir == dir.m_122424_() && front) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, BlockState adjState, Direction side) {
        if (!FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_NE);
        if (adjDir == dir || adjDir == dir.m_122424_()) {
            Direction camoSide = front ? dir.m_122424_() : dir;
            return SideSkipPredicate.compareState(level, pos, side, side, camoSide);
        }
        return false;
    }

    private static boolean testAgainstCornerPillar(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction secondPanelSide;
        if (!FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side) || Utils.isY(side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        Direction direction = secondPanelSide = front ? dir.m_122424_() : dir;
        if (CornerPillarSkipPredicate.isPanelSide(adjDir, side.m_122424_()) && CornerPillarSkipPredicate.isPanelSide(adjDir, secondPanelSide)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, BlockState adjState, Direction side) {
        boolean adjTop;
        if (!FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)StairBlock.f_56843_);
        boolean bl = adjTop = adjState.m_61143_((Property)StairBlock.f_56842_) == Half.TOP;
        if (adjShape != StairsShape.STRAIGHT || adjTop && side != Direction.UP || !adjTop && side != Direction.DOWN) {
            return false;
        }
        if (!front && adjDir == dir || front && adjDir == dir.m_122424_()) {
            return SideSkipPredicate.compareState(level, pos, side, side, adjDir);
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, BlockState adjState, Direction side) {
        if (!FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjDir.m_122434_() == dir.m_122434_() && (side == Direction.UP && adjTop || side == Direction.DOWN && !adjTop)) {
            Direction camoSide = front ? dir.m_122424_() : dir;
            return SideSkipPredicate.compareState(level, pos, side, side, camoSide);
        }
        return false;
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, BlockState adjState, Direction side) {
        if (!FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (adjType != StairsType.VERTICAL) {
            return false;
        }
        if (side == dir.m_122427_() && (!front && adjDir == dir.m_122427_() || front && adjDir == dir.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (side == dir.m_122428_() && (!front && adjDir == dir || front && adjDir == dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstVerticalDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, BlockState adjState, Direction side) {
        if (!FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (side == dir.m_122427_() && (adjDir == dir.m_122427_() || adjDir == dir.m_122424_())) {
            Direction camoSide = front ? dir.m_122424_() : dir;
            return SideSkipPredicate.compareState(level, pos, side, side, camoSide);
        }
        if (side == dir.m_122428_() && (adjDir == dir || adjDir == dir.m_122428_())) {
            Direction camoSide = front ? dir.m_122424_() : dir;
            return SideSkipPredicate.compareState(level, pos, side, side, camoSide);
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, Direction dir, boolean front, HorizontalRotation rot, BlockState adjState, Direction side) {
        if (!FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if ((adjDir == side.m_122424_() || adjTop && side == Direction.DOWN || !adjTop && side == Direction.UP) && (adjDir == dir.m_122427_() && adjRight == front || adjDir == dir.m_122428_() && adjRight != front)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    public static boolean isPanelSide(Direction dir, HorizontalRotation rot, Direction side) {
        return side == rot.withFacing(dir).m_122424_() || side == rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir).m_122424_();
    }
}

